/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.IdlingPolicy;
import androidx.test.internal.util.Checks;
import java.util.concurrent.TimeUnit;

public final class IdlingPolicies {
    private static volatile IdlingPolicy masterIdlingPolicy = new IdlingPolicy.Builder().withIdlingTimeout(60L).withIdlingTimeoutUnit(TimeUnit.SECONDS).throwAppNotIdleException().build();
    private static volatile IdlingPolicy dynamicIdlingResourceErrorPolicy = new IdlingPolicy.Builder().withIdlingTimeout(26L).withIdlingTimeoutUnit(TimeUnit.SECONDS).throwIdlingResourceTimeoutException().build();
    private static volatile IdlingPolicy dynamicIdlingResourceWarningPolicy = new IdlingPolicy.Builder().withIdlingTimeout(5L).withIdlingTimeoutUnit(TimeUnit.SECONDS).logWarning().build();

    private IdlingPolicies() {
    }

    public static void setMasterPolicyTimeout(long timeout, TimeUnit unit) {
        Checks.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Checks.checkNotNull((Object)((Object)unit));
        masterIdlingPolicy = masterIdlingPolicy.toBuilder().withIdlingTimeout(timeout).withIdlingTimeoutUnit(unit).build();
    }

    public static void setIdlingResourceTimeout(long timeout, TimeUnit unit) {
        Checks.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Checks.checkNotNull((Object)((Object)unit));
        dynamicIdlingResourceErrorPolicy = dynamicIdlingResourceErrorPolicy.toBuilder().withIdlingTimeout(timeout).withIdlingTimeoutUnit(unit).build();
    }

    public static void setMasterPolicyTimeoutWhenDebuggerAttached(boolean timeoutWhenDebuggerAttached) {
        masterIdlingPolicy = masterIdlingPolicy.toBuilder().withTimeoutIfDebuggerAttached(timeoutWhenDebuggerAttached).build();
    }

    public static IdlingPolicy getMasterIdlingPolicy() {
        return masterIdlingPolicy;
    }

    public static IdlingPolicy getDynamicIdlingResourceWarningPolicy() {
        return dynamicIdlingResourceWarningPolicy;
    }

    public static IdlingPolicy getDynamicIdlingResourceErrorPolicy() {
        return dynamicIdlingResourceErrorPolicy;
    }
}

