/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.content.Context;
import android.os.Looper;
import android.util.Log;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.CheckResult;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.BaseLayerComponent;
import androidx.test.espresso.DataInteraction;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.GraphHolder;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.ViewInteractionModule;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.TracingUtil;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.espresso.util.concurrent.ListenableFutureTask;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.platform.tracing.Tracer;
import androidx.test.platform.tracing.Tracing;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Espresso {
    private static final String TAG = Espresso.class.getSimpleName();
    private static final BaseLayerComponent BASE = GraphHolder.baseLayer();
    private static final IdlingResourceRegistry baseRegistry = BASE.idlingResourceRegistry();
    private static final Tracing tracer = BASE.tracer();
    private static final int TIMEOUT_SECONDS = 5;
    private static final Matcher<View> OVERFLOW_BUTTON_MATCHER = Matchers.anyOf((Matcher)Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.withContentDescription("More options")), (Matcher)Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.withClassName((Matcher<String>)Matchers.endsWith((String)"OverflowMenuButton"))));

    private Espresso() {
    }

    @CheckReturnValue
    @CheckResult
    public static ViewInteraction onView(Matcher<View> viewMatcher) {
        String spanName = TracingUtil.getSpanName("Espresso", "onView", viewMatcher);
        try (Tracer.Span ignored = tracer.beginSpan(spanName);){
            ViewInteraction viewInteraction = BASE.plus(new ViewInteractionModule(viewMatcher)).viewInteraction();
            return viewInteraction;
        }
    }

    @CheckReturnValue
    @CheckResult
    public static DataInteraction onData(Matcher<? extends Object> dataMatcher) {
        return new DataInteraction(dataMatcher);
    }

    @Deprecated
    public static void registerLooperAsIdlingResource(Looper looper) {
        Espresso.registerLooperAsIdlingResource(looper, false);
    }

    @Deprecated
    public static void registerLooperAsIdlingResource(Looper looper, boolean considerWaitIdle) {
        IdlingRegistry.getInstance().registerLooperAsIdlingResource(looper);
        baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
    }

    @Deprecated
    public static boolean registerIdlingResources(IdlingResource ... resources) {
        if (IdlingRegistry.getInstance().register(resources)) {
            baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
            return true;
        }
        return resources.length == 0;
    }

    @Deprecated
    public static boolean unregisterIdlingResources(IdlingResource ... resources) {
        if (IdlingRegistry.getInstance().unregister(resources)) {
            baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
            return true;
        }
        return resources.length == 0;
    }

    @Deprecated
    public static List<IdlingResource> getIdlingResources() {
        return baseRegistry.getResources();
    }

    public static void setFailureHandler(FailureHandler failureHandler) {
        BASE.failureHolder().update((FailureHandler)Checks.checkNotNull((Object)failureHandler));
    }

    public static void closeSoftKeyboard() {
        try (Tracer.Span ignored = tracer.beginSpan("Espresso.closeSoftKeyboard");){
            Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.closeSoftKeyboard());
        }
    }

    public static void openContextualActionModeOverflowMenu() {
        try (Tracer.Span ignored = tracer.beginSpan("Espresso.openContextualActionModeOverflowMenu");){
            Espresso.onView(ViewMatchers.isRoot()).perform(new TransitionBridgingViewAction());
            Espresso.onView(OVERFLOW_BUTTON_MATCHER).perform(ViewActions.click(ViewActions.pressBack()));
        }
    }

    public static void pressBack() {
        try (Tracer.Span ignored = tracer.beginSpan("Espresso.pressBack");){
            Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressBack());
        }
    }

    public static void pressBackUnconditionally() {
        try (Tracer.Span ignored = tracer.beginSpan("Espresso.pressBackUnconditionally");){
            Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressBackUnconditionally());
        }
    }

    public static void openActionBarOverflowOrOptionsMenu(Context context) {
        try (Tracer.Span ignored = tracer.beginSpan("Espresso.openActionBarOverflowOrOptionsMenu");){
            Espresso.waitUntilNextFrame(2);
            if (context.getApplicationInfo().targetSdkVersion < 11) {
                Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressMenuKey());
            } else if (Espresso.hasVirtualOverflowButton(context)) {
                Espresso.onView(ViewMatchers.isRoot()).perform(new TransitionBridgingViewAction());
                Espresso.onView(OVERFLOW_BUTTON_MATCHER).perform(ViewActions.click());
            } else {
                Espresso.onView(ViewMatchers.isRoot()).perform(ViewActions.pressMenuKey());
            }
            Espresso.waitUntilNextFrame(2);
        }
    }

    private static void waitUntilNextFrame(int times) {
        for (int i = 0; i < times; ++i) {
            CountDownLatch latch = new CountDownLatch(1);
            InstrumentationRegistry.getInstrumentation().runOnMainSync(() -> Choreographer.getInstance().postFrameCallback(frameTimeNanos -> latch.countDown()));
            BASE.controlledLooper().drainMainThreadUntilIdle();
            try {
                latch.await(5L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException e) {
                Log.w((String)TAG, (String)"Waited for the next frame to start but never happened.");
                return;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T onIdle(Callable<T> action) {
        Tracer.Span ignored = tracer.beginSpan("Espresso.onIdle");
        if (Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            BASE.controlledLooper().drainMainThreadUntilIdle();
            BASE.uiController().loopMainThreadUntilIdle();
            try {
                T t = action.call();
                return t;
            }
            catch (Exception e) {
                throw new RuntimeException("Callable action in onIdle reported an exception.", e);
            }
        }
        FutureTask<T> actionTask = new FutureTask<T>(action);
        ListenableFutureTask<Void> idleFuture = ListenableFutureTask.create(() -> {
            BASE.uiController().loopMainThreadUntilIdle();
            return null;
        });
        Executor mainThreadExecutor = BASE.mainThreadExecutor();
        idleFuture.addListener(actionTask, mainThreadExecutor);
        mainThreadExecutor.execute(idleFuture);
        BASE.controlledLooper().drainMainThreadUntilIdle();
        try {
            idleFuture.get();
            T t = actionTask.get();
            return t;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
            catch (ExecutionException ee) {
                if (!(ee.getCause() instanceof AppNotIdleException)) throw new RuntimeException(ee);
                throw (AppNotIdleException)ee.getCause();
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    public static void onIdle() {
        Espresso.onIdle(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        });
    }

    private static boolean hasVirtualOverflowButton(Context context) {
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static class TransitionBridgingViewAction
    implements ViewAction {
        private TransitionBridgingViewAction() {
        }

        @Override
        public void perform(UiController controller, View view) {
            for (int loops = 0; this.isTransitioningBetweenActionBars(view) && loops < 100; ++loops) {
                controller.loopMainThreadForAtLeast(50L);
            }
        }

        @Override
        public String getDescription() {
            return "Handle transition between action bar and action bar context.";
        }

        @Override
        public Matcher<View> getConstraints() {
            return ViewMatchers.isRoot();
        }

        private boolean isTransitioningBetweenActionBars(View view) {
            int actionButtonCount = 0;
            for (View child : TreeIterables.breadthFirstViewTraversal(view)) {
                if (!OVERFLOW_BUTTON_MATCHER.matches((Object)child)) continue;
                ++actionButtonCount;
            }
            return actionButtonCount > 1;
        }
    }
}

