/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import android.view.ViewParent;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.action.AdapterDataLoaderAction;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.action.AdapterViewProtocols;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.ConstructorInvocation;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.internal.util.Checks;
import javax.annotation.CheckReturnValue;
import kotlin.jvm.functions.Function1;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class DataInteraction {
    private final Matcher<? extends Object> dataMatcher;
    private Matcher<View> adapterMatcher = ViewMatchers.isAssignableFrom(AdapterView.class);
    @Nullable
    private Matcher<View> childViewMatcher = null;
    @Nullable
    private Integer atPosition = null;
    private AdapterViewProtocol adapterViewProtocol = AdapterViewProtocols.standardProtocol();
    private Matcher<Root> rootMatcher = RootMatchers.DEFAULT;

    DataInteraction(Matcher<? extends Object> dataMatcher) {
        this.dataMatcher = (Matcher)Checks.checkNotNull(dataMatcher);
    }

    @CheckReturnValue
    @CheckResult
    public DataInteraction onChildView(Matcher<View> childMatcher) {
        this.childViewMatcher = (Matcher)Checks.checkNotNull(childMatcher);
        return this;
    }

    @CheckReturnValue
    @CheckResult
    public DataInteraction inRoot(Matcher<Root> rootMatcher) {
        this.rootMatcher = (Matcher)Checks.checkNotNull(rootMatcher);
        return this;
    }

    @CheckReturnValue
    @CheckResult
    public DataInteraction inAdapterView(Matcher<View> adapterMatcher) {
        this.adapterMatcher = (Matcher)Checks.checkNotNull(adapterMatcher);
        return this;
    }

    @CheckReturnValue
    @CheckResult
    public DataInteraction atPosition(Integer atPosition) {
        this.atPosition = (Integer)Checks.checkNotNull((Object)atPosition);
        return this;
    }

    @CheckReturnValue
    @CheckResult
    public DataInteraction usingAdapterViewProtocol(AdapterViewProtocol adapterViewProtocol) {
        this.adapterViewProtocol = (AdapterViewProtocol)Checks.checkNotNull((Object)adapterViewProtocol);
        return this;
    }

    public ViewInteraction perform(ViewAction ... actions) {
        return Espresso.onView(this.makeTargetMatcher()).inRoot(this.rootMatcher).perform(actions);
    }

    public ViewInteraction check(ViewAssertion assertion) {
        return Espresso.onView(this.makeTargetMatcher()).inRoot(this.rootMatcher).check(assertion);
    }

    private Matcher<View> makeTargetMatcher() {
        DisplayDataMatcher targetView = DisplayDataMatcher.displayDataMatcher(this.adapterMatcher, this.dataMatcher, this.rootMatcher, this.atPosition, this.adapterViewProtocol);
        if (this.childViewMatcher != null) {
            targetView = Matchers.allOf(this.childViewMatcher, ViewMatchers.isDescendantOfA((Matcher<View>)targetView));
        }
        return targetView;
    }

    public static final class DisplayDataMatcher
    extends TypeSafeMatcher<View> {
        private static final String TAG = "DisplayDataMatcher";
        @RemoteMsgField(order=0)
        private final Matcher<View> adapterMatcher;
        @RemoteMsgField(order=1)
        private final Matcher<? extends Object> dataMatcher;
        @RemoteMsgField(order=2)
        private final Class<? extends AdapterViewProtocol> adapterViewProtocolClass;
        @RemoteMsgField(order=3)
        private final AdapterDataLoaderAction adapterDataLoaderAction;
        private final AdapterViewProtocol adapterViewProtocol;

        @RemoteMsgConstructor
        DisplayDataMatcher(@NonNull Matcher<View> adapterMatcher, @NonNull Matcher<? extends Object> dataMatcher, @NonNull Class<? extends AdapterViewProtocol> adapterViewProtocolClass, @NonNull AdapterDataLoaderAction adapterDataLoaderAction) throws IllegalAccessException, InstantiationException {
            this(adapterMatcher, dataMatcher, RootMatchers.DEFAULT, adapterViewProtocolClass.cast(new ConstructorInvocation(adapterViewProtocolClass, null, new Class[0]).invokeConstructor(new Object[0])), adapterDataLoaderAction);
        }

        private DisplayDataMatcher(@NonNull Matcher<View> adapterMatcher, @NonNull Matcher<? extends Object> dataMatcher, @NonNull Matcher<Root> rootMatcher, @NonNull AdapterViewProtocol adapterViewProtocol, @NonNull AdapterDataLoaderAction adapterDataLoaderAction) {
            this(adapterMatcher, dataMatcher, adapterViewProtocol, adapterDataLoaderAction, (Function1<AdapterDataLoaderAction, ViewInteraction>)((Function1)adapterDataLoaderAction1 -> Espresso.onView(adapterMatcher).inRoot(rootMatcher).perform((ViewAction)adapterDataLoaderAction1)));
        }

        @VisibleForTesting
        DisplayDataMatcher(@NonNull Matcher<View> adapterMatcher, @NonNull Matcher<? extends Object> dataMatcher, @NonNull AdapterViewProtocol adapterViewProtocol, @NonNull AdapterDataLoaderAction adapterDataLoaderAction, @NonNull Function1<AdapterDataLoaderAction, ViewInteraction> loadDataFunction) {
            this.adapterMatcher = (Matcher)Checks.checkNotNull(adapterMatcher);
            this.dataMatcher = (Matcher)Checks.checkNotNull(dataMatcher);
            this.adapterViewProtocol = (AdapterViewProtocol)Checks.checkNotNull((Object)adapterViewProtocol);
            this.adapterViewProtocolClass = adapterViewProtocol.getClass();
            this.adapterDataLoaderAction = (AdapterDataLoaderAction)Checks.checkNotNull((Object)adapterDataLoaderAction);
            Object unused = ((Function1)Checks.checkNotNull(loadDataFunction)).invoke((Object)adapterDataLoaderAction);
        }

        @Deprecated
        public static DisplayDataMatcher displayDataMatcher(@NonNull Matcher<View> adapterMatcher, @NonNull Matcher<? extends Object> dataMatcher, @NonNull Matcher<Root> rootMatcher, EspressoOptional<Integer> atPosition, @NonNull AdapterViewProtocol adapterViewProtocol) {
            return new DisplayDataMatcher(adapterMatcher, dataMatcher, rootMatcher, adapterViewProtocol, new AdapterDataLoaderAction(dataMatcher, atPosition, adapterViewProtocol));
        }

        public static DisplayDataMatcher displayDataMatcher(@NonNull Matcher<View> adapterMatcher, @NonNull Matcher<? extends Object> dataMatcher, @NonNull Matcher<Root> rootMatcher, @Nullable Integer atPosition, @NonNull AdapterViewProtocol adapterViewProtocol) {
            return new DisplayDataMatcher(adapterMatcher, dataMatcher, rootMatcher, adapterViewProtocol, new AdapterDataLoaderAction(dataMatcher, atPosition, adapterViewProtocol));
        }

        public void describeTo(Description description) {
            description.appendText(" displaying data matching: ");
            this.dataMatcher.describeTo(description);
            description.appendText(" within adapter view matching: ");
            this.adapterMatcher.describeTo(description);
        }

        public boolean matchesSafely(View view) {
            AdapterViewProtocol.AdaptedData data;
            ViewParent parent;
            Checks.checkState((this.adapterViewProtocol != null ? 1 : 0) != 0, (Object)"adapterViewProtocol cannot be null!");
            for (parent = view.getParent(); parent != null && !(parent instanceof AdapterView); parent = parent.getParent()) {
            }
            if (parent != null && this.adapterMatcher.matches((Object)parent) && (data = this.adapterViewProtocol.getDataRenderedByView2((AdapterView<? extends Adapter>)((AdapterView)parent), view)) != null) {
                return data.opaqueToken.equals(this.adapterDataLoaderAction.getAdaptedData().opaqueToken);
            }
            return false;
        }
    }
}

