/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.content.Context;
import android.os.Looper;
import android.view.View;
import androidx.test.espresso.BaseLayerComponent;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.ViewInteractionComponent;
import androidx.test.espresso.ViewInteractionModule;
import androidx.test.espresso.ViewInteractionModule_ProvideNeedsActivityFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRemoteInteractionFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRootMatcherFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRootViewFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideTestFlowVisualizerFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideViewFinderFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideViewMatcherFactory;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.BaseLayerModule;
import androidx.test.espresso.base.BaseLayerModule_FailureHandlerHolder_Factory;
import androidx.test.espresso.base.BaseLayerModule_ProvideActiveRootListerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideControlledLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDefaultFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDynamicNotiferFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideEventInjectorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHandlerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideLifecycleMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainThreadExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideRemoteExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideTargetContextFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvidesTracingFactory;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingResourceRegistry_Factory;
import androidx.test.espresso.base.PlatformTestStorageModule;
import androidx.test.espresso.base.PlatformTestStorageModule_ProvideTestStorageFactory;
import androidx.test.espresso.base.RootViewPicker;
import androidx.test.espresso.base.RootViewPicker_Factory;
import androidx.test.espresso.base.RootViewPicker_RootResultFetcher_Factory;
import androidx.test.espresso.base.RootsOracle;
import androidx.test.espresso.base.RootsOracle_Factory;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor_Factory;
import androidx.test.espresso.base.UiControllerImpl;
import androidx.test.espresso.base.UiControllerImpl_Factory;
import androidx.test.espresso.base.UiControllerModule;
import androidx.test.espresso.base.UiControllerModule_ProvideUiControllerFactory;
import androidx.test.espresso.base.ViewFinderImpl;
import androidx.test.espresso.base.ViewFinderImpl_Factory;
import androidx.test.espresso.core.internal.deps.dagger.internal.DaggerGenerated;
import androidx.test.espresso.core.internal.deps.dagger.internal.DoubleCheck;
import androidx.test.espresso.core.internal.deps.dagger.internal.Preconditions;
import androidx.test.espresso.internal.data.TestFlowVisualizer;
import androidx.test.espresso.util.concurrent.ListeningExecutorService;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.tracing.Tracing;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

@DaggerGenerated
public final class DaggerBaseLayerComponent {
    private DaggerBaseLayerComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BaseLayerComponent create() {
        return new Builder().build();
    }

    private static final class BaseLayerComponentImpl
    implements BaseLayerComponent {
        private final BaseLayerModule baseLayerModule;
        private final PlatformTestStorageModule platformTestStorageModule;
        private final BaseLayerComponentImpl baseLayerComponentImpl = this;
        private Provider<Context> provideTargetContextProvider;
        private Provider<DefaultFailureHandler> provideDefaultFailureHanderProvider;
        private Provider<FailureHandler> provideFailureHanderProvider;
        private Provider<BaseLayerModule.FailureHandlerHolder> failureHandlerHolderProvider;
        private Provider<Looper> provideMainLooperProvider;
        private Provider<Tracing> providesTracingProvider;
        private Provider<IdlingResourceRegistry> idlingResourceRegistryProvider;
        private Provider provideEventInjectorProvider;
        private Provider threadPoolExecutorExtractorProvider;
        private Provider provideSdkAsyncTaskMonitorProvider;
        private Provider provideCompatAsyncTaskMonitorProvider;
        private Provider provideDynamicNotiferProvider;
        private Provider uiControllerImplProvider;
        private Provider<UiController> provideUiControllerProvider;
        private Provider<Executor> provideMainThreadExecutorProvider;
        private Provider<ControlledLooper> provideControlledLooperProvider;
        private Provider rootsOracleProvider;
        private Provider<ActiveRootLister> provideActiveRootListerProvider;
        private Provider<ActivityLifecycleMonitor> provideLifecycleMonitorProvider;
        private Provider<ListeningExecutorService> provideRemoteExecutorProvider;

        private BaseLayerComponentImpl(BaseLayerModule baseLayerModuleParam, PlatformTestStorageModule platformTestStorageModuleParam, UiControllerModule uiControllerModuleParam) {
            this.baseLayerModule = baseLayerModuleParam;
            this.platformTestStorageModule = platformTestStorageModuleParam;
            this.initialize(baseLayerModuleParam, platformTestStorageModuleParam, uiControllerModuleParam);
        }

        private Object rootsOracle() {
            return RootsOracle_Factory.newInstance((Looper)this.provideMainLooperProvider.get());
        }

        private void initialize(BaseLayerModule baseLayerModuleParam, PlatformTestStorageModule platformTestStorageModuleParam, UiControllerModule uiControllerModuleParam) {
            this.provideTargetContextProvider = BaseLayerModule_ProvideTargetContextFactory.create(baseLayerModuleParam);
            this.provideDefaultFailureHanderProvider = BaseLayerModule_ProvideDefaultFailureHanderFactory.create(baseLayerModuleParam, this.provideTargetContextProvider);
            this.provideFailureHanderProvider = BaseLayerModule_ProvideFailureHanderFactory.create(baseLayerModuleParam, this.provideDefaultFailureHanderProvider);
            this.failureHandlerHolderProvider = DoubleCheck.provider(BaseLayerModule_FailureHandlerHolder_Factory.create(this.provideFailureHanderProvider));
            this.provideMainLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainLooperFactory.create(baseLayerModuleParam));
            this.providesTracingProvider = DoubleCheck.provider(BaseLayerModule_ProvidesTracingFactory.create(baseLayerModuleParam));
            this.idlingResourceRegistryProvider = DoubleCheck.provider(IdlingResourceRegistry_Factory.create(this.provideMainLooperProvider, this.providesTracingProvider));
            this.provideEventInjectorProvider = DoubleCheck.provider(BaseLayerModule_ProvideEventInjectorFactory.create(baseLayerModuleParam));
            this.threadPoolExecutorExtractorProvider = DoubleCheck.provider(ThreadPoolExecutorExtractor_Factory.create(this.provideMainLooperProvider));
            this.provideSdkAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory.create(baseLayerModuleParam, (Provider<ThreadPoolExecutorExtractor>)this.threadPoolExecutorExtractorProvider));
            this.provideCompatAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory.create(baseLayerModuleParam, (Provider<ThreadPoolExecutorExtractor>)this.threadPoolExecutorExtractorProvider));
            this.provideDynamicNotiferProvider = BaseLayerModule_ProvideDynamicNotiferFactory.create(baseLayerModuleParam, this.idlingResourceRegistryProvider);
            this.uiControllerImplProvider = DoubleCheck.provider(UiControllerImpl_Factory.create((Provider<EventInjector>)this.provideEventInjectorProvider, (Provider<IdleNotifier<Runnable>>)this.provideSdkAsyncTaskMonitorProvider, (Provider<IdleNotifier<Runnable>>)this.provideCompatAsyncTaskMonitorProvider, (Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>>)this.provideDynamicNotiferProvider, this.provideMainLooperProvider, this.idlingResourceRegistryProvider));
            this.provideUiControllerProvider = DoubleCheck.provider(UiControllerModule_ProvideUiControllerFactory.create(uiControllerModuleParam, (Provider<UiControllerImpl>)this.uiControllerImplProvider));
            this.provideMainThreadExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainThreadExecutorFactory.create(baseLayerModuleParam, this.provideMainLooperProvider));
            this.provideControlledLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideControlledLooperFactory.create(baseLayerModuleParam));
            this.rootsOracleProvider = RootsOracle_Factory.create(this.provideMainLooperProvider);
            this.provideActiveRootListerProvider = BaseLayerModule_ProvideActiveRootListerFactory.create(baseLayerModuleParam, (Provider<RootsOracle>)this.rootsOracleProvider);
            this.provideLifecycleMonitorProvider = BaseLayerModule_ProvideLifecycleMonitorFactory.create(baseLayerModuleParam);
            this.provideRemoteExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideRemoteExecutorFactory.create(baseLayerModuleParam));
        }

        @Override
        public BaseLayerModule.FailureHandlerHolder failureHolder() {
            return (BaseLayerModule.FailureHandlerHolder)this.failureHandlerHolderProvider.get();
        }

        @Override
        public FailureHandler failureHandler() {
            return BaseLayerModule_ProvideFailureHandlerFactory.provideFailureHandler(this.baseLayerModule, (BaseLayerModule.FailureHandlerHolder)this.failureHandlerHolderProvider.get());
        }

        @Override
        public ActiveRootLister activeRootLister() {
            return BaseLayerModule_ProvideActiveRootListerFactory.provideActiveRootLister(this.baseLayerModule, this.rootsOracle());
        }

        @Override
        public IdlingResourceRegistry idlingResourceRegistry() {
            return (IdlingResourceRegistry)this.idlingResourceRegistryProvider.get();
        }

        @Override
        public UiController uiController() {
            return (UiController)this.provideUiControllerProvider.get();
        }

        @Override
        public Executor mainThreadExecutor() {
            return (Executor)this.provideMainThreadExecutorProvider.get();
        }

        @Override
        public ControlledLooper controlledLooper() {
            return (ControlledLooper)this.provideControlledLooperProvider.get();
        }

        @Override
        public PlatformTestStorage testStorage() {
            return PlatformTestStorageModule_ProvideTestStorageFactory.provideTestStorage(this.platformTestStorageModule);
        }

        @Override
        public Tracing tracer() {
            return (Tracing)this.providesTracingProvider.get();
        }

        @Override
        public ViewInteractionComponent plus(ViewInteractionModule module) {
            Preconditions.checkNotNull(module);
            return new ViewInteractionComponentImpl(this.baseLayerComponentImpl, module);
        }
    }

    private static final class ViewInteractionComponentImpl
    implements ViewInteractionComponent {
        private final ViewInteractionModule viewInteractionModule;
        private final BaseLayerComponentImpl baseLayerComponentImpl;
        private final ViewInteractionComponentImpl viewInteractionComponentImpl = this;
        private Provider<AtomicReference<Matcher<Root>>> provideRootMatcherProvider;
        private Provider rootResultFetcherProvider;
        private Provider<AtomicReference<Boolean>> provideNeedsActivityProvider;
        private Provider<RootViewPicker> rootViewPickerProvider;
        private Provider<View> provideRootViewProvider;

        private ViewInteractionComponentImpl(BaseLayerComponentImpl baseLayerComponentImpl, ViewInteractionModule viewInteractionModuleParam) {
            this.baseLayerComponentImpl = baseLayerComponentImpl;
            this.viewInteractionModule = viewInteractionModuleParam;
            this.initialize(viewInteractionModuleParam);
        }

        private ViewFinderImpl viewFinderImpl() {
            return ViewFinderImpl_Factory.newInstance(ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(this.viewInteractionModule), this.provideRootViewProvider);
        }

        private ViewFinder viewFinder() {
            return ViewInteractionModule_ProvideViewFinderFactory.provideViewFinder(this.viewInteractionModule, this.viewFinderImpl());
        }

        private TestFlowVisualizer testFlowVisualizer() {
            return ViewInteractionModule_ProvideTestFlowVisualizerFactory.provideTestFlowVisualizer(this.viewInteractionModule, PlatformTestStorageModule_ProvideTestStorageFactory.provideTestStorage(this.baseLayerComponentImpl.platformTestStorageModule));
        }

        private void initialize(ViewInteractionModule viewInteractionModuleParam) {
            this.provideRootMatcherProvider = ViewInteractionModule_ProvideRootMatcherFactory.create(viewInteractionModuleParam);
            this.rootResultFetcherProvider = RootViewPicker_RootResultFetcher_Factory.create((Provider<ActiveRootLister>)this.baseLayerComponentImpl.provideActiveRootListerProvider, this.provideRootMatcherProvider);
            this.provideNeedsActivityProvider = ViewInteractionModule_ProvideNeedsActivityFactory.create(viewInteractionModuleParam);
            this.rootViewPickerProvider = DoubleCheck.provider(RootViewPicker_Factory.create((Provider<UiController>)this.baseLayerComponentImpl.provideUiControllerProvider, (Provider<RootViewPicker.RootResultFetcher>)this.rootResultFetcherProvider, (Provider<ActivityLifecycleMonitor>)this.baseLayerComponentImpl.provideLifecycleMonitorProvider, this.provideNeedsActivityProvider, (Provider<ControlledLooper>)this.baseLayerComponentImpl.provideControlledLooperProvider, (Provider<Context>)this.baseLayerComponentImpl.provideTargetContextProvider));
            this.provideRootViewProvider = ViewInteractionModule_ProvideRootViewFactory.create(viewInteractionModuleParam, this.rootViewPickerProvider);
        }

        @Override
        public ViewInteraction viewInteraction() {
            return new ViewInteraction((UiController)this.baseLayerComponentImpl.provideUiControllerProvider.get(), this.viewFinder(), (Executor)this.baseLayerComponentImpl.provideMainThreadExecutorProvider.get(), this.baseLayerComponentImpl.failureHandler(), ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(this.viewInteractionModule), ViewInteractionModule_ProvideRootMatcherFactory.provideRootMatcher(this.viewInteractionModule), ViewInteractionModule_ProvideNeedsActivityFactory.provideNeedsActivity(this.viewInteractionModule), ViewInteractionModule_ProvideRemoteInteractionFactory.provideRemoteInteraction(this.viewInteractionModule), (ListeningExecutorService)this.baseLayerComponentImpl.provideRemoteExecutorProvider.get(), (ControlledLooper)this.baseLayerComponentImpl.provideControlledLooperProvider.get(), this.testFlowVisualizer(), (Tracing)this.baseLayerComponentImpl.providesTracingProvider.get());
        }
    }

    public static final class Builder {
        private BaseLayerModule baseLayerModule;
        private PlatformTestStorageModule platformTestStorageModule;
        private UiControllerModule uiControllerModule;

        private Builder() {
        }

        public Builder baseLayerModule(BaseLayerModule baseLayerModule) {
            this.baseLayerModule = Preconditions.checkNotNull(baseLayerModule);
            return this;
        }

        public Builder platformTestStorageModule(PlatformTestStorageModule platformTestStorageModule) {
            this.platformTestStorageModule = Preconditions.checkNotNull(platformTestStorageModule);
            return this;
        }

        public Builder uiControllerModule(UiControllerModule uiControllerModule) {
            this.uiControllerModule = Preconditions.checkNotNull(uiControllerModule);
            return this;
        }

        public BaseLayerComponent build() {
            if (this.baseLayerModule == null) {
                this.baseLayerModule = new BaseLayerModule();
            }
            if (this.platformTestStorageModule == null) {
                this.platformTestStorageModule = new PlatformTestStorageModule();
            }
            if (this.uiControllerModule == null) {
                this.uiControllerModule = new UiControllerModule();
            }
            return new BaseLayerComponentImpl(this.baseLayerModule, this.platformTestStorageModule, this.uiControllerModule);
        }
    }
}

