/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.Looper;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.util.StringJoinerKt;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import java.util.List;
import java.util.Locale;

public final class AppNotIdleException
extends RuntimeException
implements EspressoException {
    private AppNotIdleException(String description) {
        super(description);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-AppNotIdleException.txt");
    }

    @Deprecated
    public static AppNotIdleException create(List<String> idleConditions, int loopCount, int seconds) {
        Checks.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        String errorMessage = String.format(Locale.ROOT, "App not idle within timeout of %s seconds evenafter trying for %s iterations. The following Idle Conditions failed %s", seconds, loopCount, StringJoinerKt.joinToString(idleConditions, ","));
        return new AppNotIdleException(errorMessage);
    }

    public static AppNotIdleException create(List<String> idleConditions, String message) {
        String errorMessage = String.format(Locale.ROOT, "%s The following Idle Conditions failed %s.", message, StringJoinerKt.joinToString(idleConditions, ","));
        return new AppNotIdleException(errorMessage);
    }
}

