/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.test.espresso.RootViewException;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class AmbiguousViewMatcherException
extends RuntimeException
implements RootViewException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private View view1;
    private View view2;
    private View[] others;

    private AmbiguousViewMatcherException(String description) {
        super(description);
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-AmbiguousViewMatcherException.txt");
    }

    private AmbiguousViewMatcherException(Builder builder) {
        this(AmbiguousViewMatcherException.getErrorMessage(builder));
        this.viewMatcher = builder.viewMatcher;
        this.rootView = builder.rootView;
        this.view1 = builder.view1;
        this.view2 = builder.view2;
        this.others = builder.others;
    }

    private static String getErrorMessage(Builder builder) {
        String errorMessage = "";
        if (builder.includeViewHierarchy) {
            ArrayList<View> ambiguousViews = new ArrayList<View>();
            ambiguousViews.add(builder.view1);
            ambiguousViews.add(builder.view2);
            Collections.addAll(ambiguousViews, builder.others);
            StringBuilder viewsAsText = new StringBuilder();
            int numViews = ambiguousViews.size();
            for (int i = 0; i < numViews; ++i) {
                if (i >= 5) {
                    viewsAsText.append(String.format(Locale.ROOT, "\n- [truncated, listing 5 out of %d views].", numViews));
                    break;
                }
                viewsAsText.append(String.format(Locale.ROOT, "\n- [%d] %s", i + 1, HumanReadables.describe((View)ambiguousViews.get(i))));
            }
            errorMessage = HumanReadables.getViewHierarchyErrorMessage(builder.rootView, ambiguousViews, String.format(Locale.ROOT, "'%s' matches %d views in the hierarchy:%s", builder.viewMatcher, numViews, viewsAsText), "****MATCHES****", builder.maxMsgLen);
            if (builder.viewHierarchyFile != null) {
                errorMessage = errorMessage + String.format("\nThe complete view hierarchy is available in artifact file '%s'.", builder.viewHierarchyFile);
            }
        } else {
            errorMessage = String.format(Locale.ROOT, "Multiple ambiguous views found for matcher %s", builder.viewMatcher);
        }
        return errorMessage;
    }

    @Override
    public View getRootView() {
        return this.rootView;
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private View view1;
        private View view2;
        private View[] others;
        private boolean includeViewHierarchy = true;
        private int maxMsgLen = Integer.MAX_VALUE;
        private String viewHierarchyFile = null;

        public Builder from(AmbiguousViewMatcherException exception) {
            this.viewMatcher = exception.viewMatcher;
            this.rootView = exception.rootView;
            this.view1 = exception.view1;
            this.view2 = exception.view2;
            this.others = exception.others;
            return this;
        }

        public Builder withViewMatcher(Matcher<? super View> viewMatcher) {
            this.viewMatcher = viewMatcher;
            return this;
        }

        public Builder withRootView(View rootView) {
            this.rootView = rootView;
            return this;
        }

        public Builder withView1(View view1) {
            this.view1 = view1;
            return this;
        }

        public Builder withView2(View view2) {
            this.view2 = view2;
            return this;
        }

        public Builder withOtherAmbiguousViews(View ... others) {
            this.others = others;
            return this;
        }

        public Builder includeViewHierarchy(boolean includeViewHierarchy) {
            this.includeViewHierarchy = includeViewHierarchy;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder withMaxMsgLen(int maxMsgLen) {
            this.maxMsgLen = maxMsgLen;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder withViewHierarchyFile(@Nullable String viewHierarchyFile) {
            this.viewHierarchyFile = viewHierarchyFile;
            return this;
        }

        public AmbiguousViewMatcherException build() {
            Checks.checkNotNull(this.viewMatcher);
            Checks.checkNotNull((Object)this.rootView);
            Checks.checkNotNull((Object)this.view1);
            Checks.checkNotNull((Object)this.view2);
            Checks.checkNotNull((Object)this.others);
            return new AmbiguousViewMatcherException(this);
        }
    }
}

