// Generated by Dagger (https://dagger.dev).
package androidx.test.espresso;

import android.content.Context;
import android.os.Looper;
import android.view.View;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.BaseLayerModule;
import androidx.test.espresso.base.BaseLayerModule_FailureHandlerHolder_Factory;
import androidx.test.espresso.base.BaseLayerModule_ProvideActiveRootListerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideControlledLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDefaultFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDynamicNotiferFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideEventInjectorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHandlerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideLifecycleMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainThreadExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideRemoteExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideTargetContextFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvidesTracingFactory;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingResourceRegistry_Factory;
import androidx.test.espresso.base.PlatformTestStorageModule;
import androidx.test.espresso.base.PlatformTestStorageModule_ProvideTestStorageFactory;
import androidx.test.espresso.base.RootViewPicker;
import androidx.test.espresso.base.RootViewPicker_Factory;
import androidx.test.espresso.base.RootViewPicker_RootResultFetcher_Factory;
import androidx.test.espresso.base.RootsOracle_Factory;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor_Factory;
import androidx.test.espresso.base.UiControllerImpl_Factory;
import androidx.test.espresso.base.UiControllerModule;
import androidx.test.espresso.base.UiControllerModule_ProvideUiControllerFactory;
import androidx.test.espresso.base.ViewFinderImpl;
import androidx.test.espresso.base.ViewFinderImpl_Factory;
import androidx.test.espresso.internal.data.TestFlowVisualizer;
import androidx.test.espresso.util.concurrent.ListeningExecutorService;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.tracing.Tracing;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class DaggerBaseLayerComponent {
  private DaggerBaseLayerComponent() {
  }

  public static Builder builder() {
    return new Builder();
  }

  public static BaseLayerComponent create() {
    return new Builder().build();
  }

  public static final class Builder {
    private BaseLayerModule baseLayerModule;

    private PlatformTestStorageModule platformTestStorageModule;

    private UiControllerModule uiControllerModule;

    private Builder() {
    }

    public Builder baseLayerModule(BaseLayerModule baseLayerModule) {
      this.baseLayerModule = Preconditions.checkNotNull(baseLayerModule);
      return this;
    }

    public Builder platformTestStorageModule(PlatformTestStorageModule platformTestStorageModule) {
      this.platformTestStorageModule = Preconditions.checkNotNull(platformTestStorageModule);
      return this;
    }

    public Builder uiControllerModule(UiControllerModule uiControllerModule) {
      this.uiControllerModule = Preconditions.checkNotNull(uiControllerModule);
      return this;
    }

    public BaseLayerComponent build() {
      if (baseLayerModule == null) {
        this.baseLayerModule = new BaseLayerModule();
      }
      if (platformTestStorageModule == null) {
        this.platformTestStorageModule = new PlatformTestStorageModule();
      }
      if (uiControllerModule == null) {
        this.uiControllerModule = new UiControllerModule();
      }
      return new BaseLayerComponentImpl(baseLayerModule, platformTestStorageModule, uiControllerModule);
    }
  }

  private static final class ViewInteractionComponentImpl implements ViewInteractionComponent {
    private final ViewInteractionModule viewInteractionModule;

    private final BaseLayerComponentImpl baseLayerComponentImpl;

    private final ViewInteractionComponentImpl viewInteractionComponentImpl = this;

    private Provider<AtomicReference<Matcher<Root>>> provideRootMatcherProvider;

    @SuppressWarnings("rawtypes")
    private Provider rootResultFetcherProvider;

    private Provider<AtomicReference<Boolean>> provideNeedsActivityProvider;

    private Provider<RootViewPicker> rootViewPickerProvider;

    private Provider<View> provideRootViewProvider;

    private ViewInteractionComponentImpl(BaseLayerComponentImpl baseLayerComponentImpl,
        ViewInteractionModule viewInteractionModuleParam) {
      this.baseLayerComponentImpl = baseLayerComponentImpl;
      this.viewInteractionModule = viewInteractionModuleParam;
      initialize(viewInteractionModuleParam);

    }

    private ViewFinderImpl viewFinderImpl() {
      return ViewFinderImpl_Factory.newInstance(ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(viewInteractionModule), provideRootViewProvider);
    }

    private ViewFinder viewFinder() {
      return ViewInteractionModule_ProvideViewFinderFactory.provideViewFinder(viewInteractionModule, viewFinderImpl());
    }

    private TestFlowVisualizer testFlowVisualizer() {
      return ViewInteractionModule_ProvideTestFlowVisualizerFactory.provideTestFlowVisualizer(viewInteractionModule, PlatformTestStorageModule_ProvideTestStorageFactory.provideTestStorage(baseLayerComponentImpl.platformTestStorageModule));
    }

    @SuppressWarnings("unchecked")
    private void initialize(final ViewInteractionModule viewInteractionModuleParam) {
      this.provideRootMatcherProvider = ViewInteractionModule_ProvideRootMatcherFactory.create(viewInteractionModuleParam);
      this.rootResultFetcherProvider = RootViewPicker_RootResultFetcher_Factory.create(baseLayerComponentImpl.provideActiveRootListerProvider, provideRootMatcherProvider);
      this.provideNeedsActivityProvider = ViewInteractionModule_ProvideNeedsActivityFactory.create(viewInteractionModuleParam);
      this.rootViewPickerProvider = DoubleCheck.provider(RootViewPicker_Factory.create(baseLayerComponentImpl.provideUiControllerProvider, rootResultFetcherProvider, baseLayerComponentImpl.provideLifecycleMonitorProvider, provideNeedsActivityProvider, baseLayerComponentImpl.provideControlledLooperProvider, baseLayerComponentImpl.provideTargetContextProvider));
      this.provideRootViewProvider = ViewInteractionModule_ProvideRootViewFactory.create(viewInteractionModuleParam, rootViewPickerProvider);
    }

    @Override
    public ViewInteraction viewInteraction() {
      return new ViewInteraction(baseLayerComponentImpl.provideUiControllerProvider.get(), viewFinder(), baseLayerComponentImpl.provideMainThreadExecutorProvider.get(), baseLayerComponentImpl.failureHandler(), ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(viewInteractionModule), ViewInteractionModule_ProvideRootMatcherFactory.provideRootMatcher(viewInteractionModule), ViewInteractionModule_ProvideNeedsActivityFactory.provideNeedsActivity(viewInteractionModule), ViewInteractionModule_ProvideRemoteInteractionFactory.provideRemoteInteraction(viewInteractionModule), baseLayerComponentImpl.provideRemoteExecutorProvider.get(), baseLayerComponentImpl.provideControlledLooperProvider.get(), testFlowVisualizer(), baseLayerComponentImpl.providesTracingProvider.get());
    }
  }

  private static final class BaseLayerComponentImpl implements BaseLayerComponent {
    private final BaseLayerModule baseLayerModule;

    private final PlatformTestStorageModule platformTestStorageModule;

    private final BaseLayerComponentImpl baseLayerComponentImpl = this;

    private Provider<Context> provideTargetContextProvider;

    private Provider<DefaultFailureHandler> provideDefaultFailureHanderProvider;

    private Provider<FailureHandler> provideFailureHanderProvider;

    private Provider<BaseLayerModule.FailureHandlerHolder> failureHandlerHolderProvider;

    private Provider<Looper> provideMainLooperProvider;

    private Provider<Tracing> providesTracingProvider;

    private Provider<IdlingResourceRegistry> idlingResourceRegistryProvider;

    @SuppressWarnings("rawtypes")
    private Provider provideEventInjectorProvider;

    @SuppressWarnings("rawtypes")
    private Provider threadPoolExecutorExtractorProvider;

    @SuppressWarnings("rawtypes")
    private Provider provideSdkAsyncTaskMonitorProvider;

    @SuppressWarnings("rawtypes")
    private Provider provideCompatAsyncTaskMonitorProvider;

    @SuppressWarnings("rawtypes")
    private Provider provideDynamicNotiferProvider;

    @SuppressWarnings("rawtypes")
    private Provider uiControllerImplProvider;

    private Provider<UiController> provideUiControllerProvider;

    private Provider<Executor> provideMainThreadExecutorProvider;

    private Provider<ControlledLooper> provideControlledLooperProvider;

    @SuppressWarnings("rawtypes")
    private Provider rootsOracleProvider;

    private Provider<ActiveRootLister> provideActiveRootListerProvider;

    private Provider<ActivityLifecycleMonitor> provideLifecycleMonitorProvider;

    private Provider<ListeningExecutorService> provideRemoteExecutorProvider;

    private BaseLayerComponentImpl(BaseLayerModule baseLayerModuleParam,
        PlatformTestStorageModule platformTestStorageModuleParam,
        UiControllerModule uiControllerModuleParam) {
      this.baseLayerModule = baseLayerModuleParam;
      this.platformTestStorageModule = platformTestStorageModuleParam;
      initialize(baseLayerModuleParam, platformTestStorageModuleParam, uiControllerModuleParam);

    }

    private Object rootsOracle() {
      return RootsOracle_Factory.newInstance(provideMainLooperProvider.get());
    }

    @SuppressWarnings("unchecked")
    private void initialize(final BaseLayerModule baseLayerModuleParam,
        final PlatformTestStorageModule platformTestStorageModuleParam,
        final UiControllerModule uiControllerModuleParam) {
      this.provideTargetContextProvider = BaseLayerModule_ProvideTargetContextFactory.create(baseLayerModuleParam);
      this.provideDefaultFailureHanderProvider = BaseLayerModule_ProvideDefaultFailureHanderFactory.create(baseLayerModuleParam, provideTargetContextProvider);
      this.provideFailureHanderProvider = BaseLayerModule_ProvideFailureHanderFactory.create(baseLayerModuleParam, provideDefaultFailureHanderProvider);
      this.failureHandlerHolderProvider = DoubleCheck.provider(BaseLayerModule_FailureHandlerHolder_Factory.create(provideFailureHanderProvider));
      this.provideMainLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainLooperFactory.create(baseLayerModuleParam));
      this.providesTracingProvider = DoubleCheck.provider(BaseLayerModule_ProvidesTracingFactory.create(baseLayerModuleParam));
      this.idlingResourceRegistryProvider = DoubleCheck.provider(IdlingResourceRegistry_Factory.create(provideMainLooperProvider, providesTracingProvider));
      this.provideEventInjectorProvider = DoubleCheck.provider(BaseLayerModule_ProvideEventInjectorFactory.create(baseLayerModuleParam));
      this.threadPoolExecutorExtractorProvider = DoubleCheck.provider(ThreadPoolExecutorExtractor_Factory.create(provideMainLooperProvider));
      this.provideSdkAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory.create(baseLayerModuleParam, threadPoolExecutorExtractorProvider));
      this.provideCompatAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory.create(baseLayerModuleParam, threadPoolExecutorExtractorProvider));
      this.provideDynamicNotiferProvider = BaseLayerModule_ProvideDynamicNotiferFactory.create(baseLayerModuleParam, idlingResourceRegistryProvider);
      this.uiControllerImplProvider = DoubleCheck.provider(UiControllerImpl_Factory.create(provideEventInjectorProvider, provideSdkAsyncTaskMonitorProvider, provideCompatAsyncTaskMonitorProvider, provideDynamicNotiferProvider, provideMainLooperProvider, idlingResourceRegistryProvider));
      this.provideUiControllerProvider = DoubleCheck.provider(UiControllerModule_ProvideUiControllerFactory.create(uiControllerModuleParam, uiControllerImplProvider));
      this.provideMainThreadExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainThreadExecutorFactory.create(baseLayerModuleParam, provideMainLooperProvider));
      this.provideControlledLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideControlledLooperFactory.create(baseLayerModuleParam));
      this.rootsOracleProvider = RootsOracle_Factory.create(provideMainLooperProvider);
      this.provideActiveRootListerProvider = BaseLayerModule_ProvideActiveRootListerFactory.create(baseLayerModuleParam, rootsOracleProvider);
      this.provideLifecycleMonitorProvider = BaseLayerModule_ProvideLifecycleMonitorFactory.create(baseLayerModuleParam);
      this.provideRemoteExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideRemoteExecutorFactory.create(baseLayerModuleParam));
    }

    @Override
    public BaseLayerModule.FailureHandlerHolder failureHolder() {
      return failureHandlerHolderProvider.get();
    }

    @Override
    public FailureHandler failureHandler() {
      return BaseLayerModule_ProvideFailureHandlerFactory.provideFailureHandler(baseLayerModule, failureHandlerHolderProvider.get());
    }

    @Override
    public ActiveRootLister activeRootLister() {
      return BaseLayerModule_ProvideActiveRootListerFactory.provideActiveRootLister(baseLayerModule, rootsOracle());
    }

    @Override
    public IdlingResourceRegistry idlingResourceRegistry() {
      return idlingResourceRegistryProvider.get();
    }

    @Override
    public UiController uiController() {
      return provideUiControllerProvider.get();
    }

    @Override
    public Executor mainThreadExecutor() {
      return provideMainThreadExecutorProvider.get();
    }

    @Override
    public ControlledLooper controlledLooper() {
      return provideControlledLooperProvider.get();
    }

    @Override
    public PlatformTestStorage testStorage() {
      return PlatformTestStorageModule_ProvideTestStorageFactory.provideTestStorage(platformTestStorageModule);
    }

    @Override
    public Tracing tracer() {
      return providesTracingProvider.get();
    }

    @Override
    public ViewInteractionComponent plus(ViewInteractionModule module) {
      Preconditions.checkNotNull(module);
      return new ViewInteractionComponentImpl(baseLayerComponentImpl, module);
    }
  }
}
