/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import java.util.ArrayList;

public final class TracingUtil {
    private static final int SPAN_NAME_MAX_LEN = 100;
    private static final String SPAN_NAME_EXCLUDE = "[^0-9A-Za-z._$()\\[\\] /:-]";

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String getClassName(Object element, String defaultName) {
        Object object;
        object = element == null ? null : object.getClass().getSimpleName();
        if (Strings.isNullOrEmpty((String)object)) {
            void var1_1;
            object = var1_1;
        }
        return Strings.nullToEmpty((String)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getSpanName(String prefix, String methodName, Object ... arguments) {
        CharSequence charSequence;
        StringBuilder stringBuilder;
        Object object;
        String string = TracingUtil.sanitizeName(prefix, SPAN_NAME_EXCLUDE, -1);
        object = TracingUtil.sanitizeName((String)object, SPAN_NAME_EXCLUDE, -1);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        if (stringBuilder != null) {
            for (CharSequence charSequence2 : stringBuilder) {
                if (charSequence2 == null || ((String)(charSequence2 = TracingUtil.sanitizeName(((Object)charSequence2).toString(), SPAN_NAME_EXCLUDE, -1))).isEmpty()) continue;
                arrayList.add(charSequence2);
            }
        }
        if (!string.isEmpty()) {
            if (!((String)object).isEmpty()) {
                charSequence = new StringBuilder();
                charSequence = ((StringBuilder)charSequence).append(string).append(".").toString();
            } else {
                charSequence = string;
            }
        } else {
            charSequence = string;
        }
        stringBuilder = new StringBuilder();
        charSequence = stringBuilder.append((String)charSequence).append((String)object).toString();
        if (!arrayList.isEmpty()) {
            object = Joiner.on(", ");
            object = ((Joiner)object).join(arrayList);
            stringBuilder = new StringBuilder();
            charSequence = stringBuilder.append((String)charSequence).append("(").append((String)object).append(")").toString();
        }
        return TracingUtil.sanitizeName((String)charSequence, null, 100);
    }

    /*
     * WARNING - void declaration
     */
    private static String sanitizeName(String name, String exclude, int maxLength) {
        void var2_2;
        String string;
        void var1_1;
        if (name == null) {
            return "";
        }
        if (!Strings.isNullOrEmpty((String)var1_1)) {
            string = string.replaceAll((String)var1_1, "").trim();
        }
        if (var2_2 > 0 && string.length() > var2_2) {
            return string.substring(0, (int)var2_2).trim();
        }
        return string;
    }

    private TracingUtil() {
    }
}

