/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.cache.Cache;
import androidx.test.espresso.core.internal.deps.guava.cache.CacheBuilder;
import androidx.test.espresso.remote.RemoteProtocolException;
import androidx.test.internal.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

final class MethodInvocation {
    private static final String TAG = "MethodInvocation";
    private static final Cache<MethodKey, Method> methodCache = CacheBuilder.newBuilder().maximumSize(256L).build();
    private final Class<?> clazz;
    private final Object instance;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public Object invokeDeclaredMethod(Object ... methodParams) {
        Object object;
        try {
            MethodKey methodKey = new MethodKey(this.clazz, this.methodName, this.parameterTypes);
            object = this.invokeMethodExplosively(MethodInvocation.getDeclaredMethod(methodKey), (Object[])object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.methodName, Arrays.asList(this.parameterTypes), this.clazz.getName(), Arrays.asList(this.clazz.getDeclaredMethods())};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, "No method: %s(%s) found for clazz: %s Available methods: %s", objectArray), noSuchMethodException);
            throw remoteProtocolException;
        }
        return object;
    }

    public Object invokeMethod(Object ... methodParams) {
        Object object;
        try {
            MethodKey methodKey = new MethodKey(this.clazz, this.methodName, this.parameterTypes);
            object = this.invokeMethodExplosively(MethodInvocation.getMethod(methodKey), (Object[])object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.methodName, this.clazz.getName(), Arrays.asList(this.clazz.getMethods())};
            RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, "No method: %s found for clazz: %s. Available methods: %s", objectArray), noSuchMethodException);
            throw remoteProtocolException;
        }
        return object;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeMethodExplosively(Method method, Object ... args) {
        Object[] objectArray;
        String string;
        Locale locale;
        SecurityException securityException2222;
        Object[] objectArray2;
        block7: {
            Object object;
            void var2_4;
            try {
                method.setAccessible(true);
                object = objectArray2.invoke(this.instance, (Object[])var2_4);
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    Locale locale2 = Locale.ROOT;
                    String string2 = "Cannot invoke method %s with args [%s] on builder %s";
                    Object[] objectArray3 = new Object[]{objectArray2, Arrays.toString((Object[])var2_4), this.clazz.getName()};
                    RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale2, string2, objectArray3), invocationTargetException);
                    throw remoteProtocolException;
                    catch (IllegalAccessException illegalAccessException) {
                        Locale locale3 = Locale.ROOT;
                        String string3 = "Cannot create instance of %s";
                        Object[] objectArray4 = new Object[]{this.clazz.getName()};
                        RemoteProtocolException remoteProtocolException2 = new RemoteProtocolException(String.format(locale3, string3, objectArray4), illegalAccessException);
                        throw remoteProtocolException2;
                    }
                    catch (SecurityException securityException2222) {
                        locale = Locale.ROOT;
                        string = "Method not accessible: %s";
                        objectArray = new Object[1];
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    Object[] objectArray5 = new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString((Object[])var2_4)};
                    LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])objectArray5);
                    throw throwable;
                }
            }
            objectArray2 = new Object[]{this.clazz.getSimpleName(), this.methodName, Arrays.toString((Object[])var2_4)};
            LogUtil.logDebug((String)TAG, (String)"%s.invokeMethodExplosively(%s,%s)", (Object[])objectArray2);
            return object;
        }
        objectArray[0] = objectArray2.getName();
        RemoteProtocolException remoteProtocolException = new RemoteProtocolException(String.format(locale, string, objectArray), securityException2222);
        throw remoteProtocolException;
    }

    private static Method getDeclaredMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, true);
    }

    private static Method getMethod(MethodKey methodKey) throws NoSuchMethodException {
        return MethodInvocation.getMethodInternal(methodKey, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Method getMethodInternal(MethodKey methodKey, boolean declaredMethod) throws NoSuchMethodException {
        void var1_4;
        void var0_2;
        MethodKey methodKey2;
        Object[] objectArray = (Object[])methodCache.getIfPresent(methodKey2);
        if (objectArray != null) {
            Object[] objectArray2 = new Object[]{methodKey2.type.getSimpleName(), methodKey2.methodName, Arrays.toString(methodKey2.parameterTypes)};
            LogUtil.logDebug((String)TAG, (String)"Cache hit for method: %s#%s(%s).", (Object[])objectArray2);
            Object[] objectArray3 = objectArray;
            return var0_2;
        }
        objectArray = new Object[]{methodKey2.type.getSimpleName(), methodKey2.methodName, Arrays.toString(methodKey2.parameterTypes)};
        LogUtil.logDebug((String)TAG, (String)"Cache miss for method: %s#%s(%s). Loading into cache.", (Object[])objectArray);
        Method method = var1_4 != false ? methodKey2.type.getDeclaredMethod(methodKey2.methodName, methodKey2.parameterTypes) : methodKey2.type.getMethod(methodKey2.methodName, methodKey2.parameterTypes);
        methodCache.put(methodKey2, method);
        Method method2 = method;
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public MethodInvocation(Class<?> clazz, Object instance, String methodName, Class<?> ... parameterTypes) {
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_1;
        this.clazz = (Class)Preconditions.checkNotNull(var1_1, "clazz cannot be null!");
        this.instance = var2_3;
        boolean bl = var3_4 != null && !var3_4.isEmpty();
        Preconditions.checkArgument(bl, "methodName cannot be null or empty");
        this.methodName = var3_4;
        this.parameterTypes = var4_5;
    }

    public static void invalidateCache() {
        methodCache.invalidateAll();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class MethodKey {
        private final Class<?> type;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        public int hashCode() {
            return (this.type.hashCode() * 31 + this.methodName.hashCode()) * 31 + Arrays.hashCode(this.parameterTypes);
        }

        /*
         * WARNING - void declaration
         */
        public MethodKey(Class<?> type, String methodName, Class<?>[] parameterTypes) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.type = var1_1;
            this.methodName = var2_2;
            this.parameterTypes = var3_3;
        }

        public boolean equals(Object o) {
            MethodKey methodKey;
            if (this == methodKey) {
                return true;
            }
            if (methodKey == null || this.getClass() != methodKey.getClass()) {
                return false;
            }
            methodKey = methodKey;
            if (!this.type.equals(methodKey.type)) {
                return false;
            }
            if (!this.methodName.equals(methodKey.methodName)) {
                return false;
            }
            return Arrays.equals(this.parameterTypes, methodKey.parameterTypes);
        }
    }
}

