/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ListenableFutureTask
extends FutureTask
implements ListenableFuture {
    private final ExecutionList executionList;

    public static ListenableFutureTask create(Callable callable) {
        ListenableFutureTask listenableFutureTask = new ListenableFutureTask(callable);
        return listenableFutureTask;
    }

    public static ListenableFutureTask create(Runnable runnable, Object object) {
        ListenableFutureTask listenableFutureTask = new ListenableFutureTask(runnable, object);
        return listenableFutureTask;
    }

    @Override
    public Object get(long l, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
        long l2 = timeUnit.toNanos(l);
        if (l2 <= 2147483647999999999L) {
            return super.get(l, timeUnit);
        }
        return super.get(Math.min(l2, 2147483647999999999L), TimeUnit.NANOSECONDS);
    }

    ListenableFutureTask(Callable object) {
        super(object);
        this.executionList = object = new ExecutionList();
    }

    ListenableFutureTask(Runnable object, Object object2) {
        super((Runnable)object, object2);
        this.executionList = object = new ExecutionList();
    }

    public void addListener(Runnable runnable, Executor executor) {
        this.executionList.add(runnable, executor);
    }

    @Override
    protected void done() {
        this.executionList.execute();
    }
}

