/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.DirectExecutor;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.NullnessCasts;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.OverflowAvoidingLockSupport;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.internal.InternalFutureFailureAccess;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.internal.InternalFutures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public abstract class AbstractFuture<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile Listener listeners;
    private volatile Waiter waiters;

    static /* synthetic */ Listener access$702(AbstractFuture abstractFuture, Listener listener) {
        abstractFuture.listeners = listener;
        return listener;
    }

    private Listener clearListeners(Listener listener) {
        Object object = ATOMIC_HELPER.gasListeners((AbstractFuture)object, Listener.TOMBSTONE);
        Object object2 = listener;
        while (object != null) {
            listener = ((Listener)object).next;
            ((Listener)object).next = object2;
            object2 = object;
            object = listener;
        }
        return object2;
    }

    static /* synthetic */ Waiter access$802(AbstractFuture abstractFuture, Waiter waiter) {
        abstractFuture.waiters = waiter;
        return waiter;
    }

    static /* synthetic */ Object access$302(AbstractFuture abstractFuture, Object object) {
        abstractFuture.value = object;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object get() throws InterruptedException, ExecutionException {
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Object object3;
        block5: {
            if (Thread.interrupted()) {
                object3 = new InterruptedException();
                throw object3;
            }
            object2 = ((AbstractFuture)object3).value;
            boolean bl3 = object2 != null;
            if (bl3 & (bl2 = !(object2 instanceof SetFuture))) {
                return super.getDoneValue(object2);
            }
            Object object4 = ((AbstractFuture)object3).waiters;
            if (object4 != Waiter.TOMBSTONE) {
                object2 = new Waiter();
                do {
                    ((Waiter)object2).setNext((Waiter)object4);
                    if (ATOMIC_HELPER.casWaiters((AbstractFuture)object3, (Waiter)object4, (Waiter)object2)) break block5;
                } while ((object4 = ((AbstractFuture)object3).waiters) != Waiter.TOMBSTONE);
            }
            object4 = ((AbstractFuture)object3).value;
            object4.getClass();
            return super.getDoneValue(object4);
        }
        do {
            LockSupport.park(object3);
            if (!Thread.interrupted()) continue;
            super.removeWaiter((Waiter)object2);
            object3 = new InterruptedException();
            throw object3;
        } while (!((bl = (object = ((AbstractFuture)object3).value) != null) & (bl2 = !(object instanceof SetFuture))));
        return super.getDoneValue(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object get(long l, TimeUnit object) throws InterruptedException, TimeoutException, ExecutionException {
        CharSequence charSequence;
        CharSequence charSequence2;
        Object object2;
        block24: {
            Object object3;
            boolean bl;
            long l2;
            block23: {
                Object object4;
                block22: {
                    block21: {
                        long l3;
                        long l4;
                        boolean bl2;
                        block20: {
                            Waiter waiter;
                            long l5;
                            block16: {
                                block18: {
                                    Waiter waiter2;
                                    block19: {
                                        block17: {
                                            long l6;
                                            l5 = ((TimeUnit)((Object)object)).toNanos(l);
                                            if (Thread.interrupted()) {
                                                object2 = new InterruptedException();
                                                throw object2;
                                            }
                                            Object object5 = ((AbstractFuture)object2).value;
                                            boolean bl3 = object5 != null;
                                            if (bl3 & (bl2 = !(object5 instanceof SetFuture))) {
                                                return super.getDoneValue(object5);
                                            }
                                            l4 = l5 > 0L ? (l6 = System.nanoTime() + l5) : 0L;
                                            if (l5 < 1000L) break block17;
                                            waiter2 = ((AbstractFuture)object2).waiters;
                                            if (waiter2 == Waiter.TOMBSTONE) break block18;
                                            break block19;
                                        }
                                        l3 = l5;
                                        break block20;
                                    }
                                    waiter = new Waiter();
                                    Waiter waiter3 = waiter2;
                                    while (true) {
                                        waiter.setNext(waiter3);
                                        if (!ATOMIC_HELPER.casWaiters((AbstractFuture)object2, waiter3, waiter)) {
                                            waiter2 = ((AbstractFuture)object2).waiters;
                                            if (waiter2 == Waiter.TOMBSTONE) break;
                                            waiter3 = waiter2;
                                            continue;
                                        }
                                        break block16;
                                        break;
                                    }
                                }
                                object = ((AbstractFuture)object2).value;
                                object.getClass();
                                return super.getDoneValue(object);
                            }
                            long l7 = l5;
                            while (true) {
                                OverflowAvoidingLockSupport.parkNanos(object2, l7);
                                if (Thread.interrupted()) {
                                    super.removeWaiter(waiter);
                                    object2 = new InterruptedException();
                                    throw object2;
                                }
                                object4 = ((AbstractFuture)object2).value;
                                boolean bl4 = object4 != null;
                                if (bl4 & (bl2 = !(object4 instanceof SetFuture))) {
                                    return super.getDoneValue(object4);
                                }
                                long l8 = l4 - System.nanoTime();
                                if (l8 < 1000L) {
                                    super.removeWaiter(waiter);
                                    l3 = l8;
                                    break;
                                }
                                l7 = l8;
                            }
                        }
                        while (l3 > 0L) {
                            long l9;
                            object4 = ((AbstractFuture)object2).value;
                            boolean bl5 = object4 != null;
                            if (bl5 & (bl2 = !(object4 instanceof SetFuture))) {
                                return super.getDoneValue(object4);
                            }
                            if (Thread.interrupted()) {
                                object2 = new InterruptedException();
                                throw object2;
                            }
                            l3 = l9 = l4 - System.nanoTime();
                        }
                        charSequence2 = ((AbstractFuture)object2).toString();
                        charSequence = ((Enum)object).toString().toLowerCase(Locale.ROOT);
                        object4 = new StringBuilder();
                        object4 = ((StringBuilder)object4).append("Waited ").append(l).append(" ").append(((Enum)object).toString().toLowerCase(Locale.ROOT)).toString();
                        if (l3 + 1000L >= 0L) break block21;
                        StringBuilder stringBuilder = new StringBuilder();
                        object4 = stringBuilder.append((String)object4).append(" (plus ").toString();
                        l = -l3;
                        long l10 = ((TimeUnit)((Object)object)).convert(l, TimeUnit.NANOSECONDS);
                        l2 = l - ((TimeUnit)((Object)object)).toNanos(l10);
                        bl = l10 == 0L || l2 > 1000L;
                        if (l10 <= 0L) break block22;
                        stringBuilder = new StringBuilder();
                        charSequence = stringBuilder.append((String)object4).append(l10).append(" ").append((String)charSequence).toString();
                        if (bl) {
                            object4 = new StringBuilder();
                            charSequence = ((StringBuilder)object4).append((String)charSequence).append(",").toString();
                            object3 = charSequence;
                        } else {
                            object3 = charSequence;
                        }
                        charSequence = new StringBuilder();
                        charSequence = ((StringBuilder)charSequence).append((String)object3).append(" ").toString();
                        object3 = charSequence;
                        break block23;
                    }
                    object = object4;
                    break block24;
                }
                object3 = object4;
            }
            if (bl) {
                object = new StringBuilder();
                object = ((StringBuilder)object).append((String)object3).append(l2).append(" nanoseconds ").toString();
            } else {
                object = object3;
            }
            charSequence = new StringBuilder();
            object = ((StringBuilder)charSequence).append((String)object).append("delay)").toString();
        }
        if (((AbstractFuture)object2).isDone()) {
            charSequence2 = new StringBuilder();
            object2 = new TimeoutException(((StringBuilder)charSequence2).append((String)object).append(" but future completed as timeout expired").toString());
            throw object2;
        }
        charSequence = new StringBuilder();
        object2 = new TimeoutException(((StringBuilder)charSequence).append((String)object).append(" for ").append((String)charSequence2).toString());
        throw object2;
    }

    private Object getDoneValue(Object object) throws ExecutionException {
        if (object instanceof Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)object).cause);
        }
        if (object instanceof Failure) {
            Object object2 = new ExecutionException(((Failure)object).exception);
            throw object2;
        }
        if (object == NULL) {
            return NullnessCasts.uncheckedNull();
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getFutureValue(ListenableFuture object) {
        boolean bl;
        Throwable throwable;
        if (object instanceof Trusted) {
            object = ((AbstractFuture)object).value;
            if (object instanceof Cancellation) {
                Cancellation cancellation = (Cancellation)object;
                if (cancellation.wasInterrupted) {
                    object = cancellation.cause != null ? new Cancellation(false, cancellation.cause) : Cancellation.CAUSELESS_CANCELLED;
                }
            }
            object.getClass();
            return object;
        }
        if (object instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)object)) != null) {
            return new Failure(throwable);
        }
        boolean bl2 = !GENERATE_CANCELLATION_CAUSES;
        if (bl2 & (bl = object.isCancelled())) {
            object = Cancellation.CAUSELESS_CANCELLED;
            object.getClass();
            return object;
        }
        try {
            Object object2 = AbstractFuture.getUninterruptibly((Future)object);
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(object).toString());
                return new Cancellation(false, illegalArgumentException);
            }
            if (object2 != null) return object2;
            return NULL;
        }
        catch (ExecutionException executionException) {
            if (!bl) return new Failure(executionException.getCause());
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(object).toString(), executionException);
            return new Cancellation(false, illegalArgumentException);
        }
        catch (CancellationException cancellationException) {
            if (bl) return new Cancellation(false, cancellationException);
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("get() threw CancellationException, despite reporting isCancelled() == false: ").append(object).toString(), cancellationException);
            return new Failure(illegalArgumentException);
        }
        catch (Error | RuntimeException throwable2) {
            return new Failure(throwable2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getUninterruptibly(Future future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            try {
                Object v = future.get();
                if (!bl) return v;
                Thread.currentThread().interrupt();
                return v;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    throw throwable;
                }
                Thread.currentThread().interrupt();
                throw throwable;
            }
            break;
        }
    }

    protected String pendingToString() {
        if (this instanceof ScheduledFuture) {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append("remaining delay=[").append(((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS)).append(" ms]").toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getClass().getName().startsWith("androidx.test.espresso.core.internal.deps.guava.util.concurrent.")) {
            stringBuilder.append(this.getClass().getSimpleName());
        } else {
            stringBuilder.append(this.getClass().getName());
        }
        stringBuilder.append('@').append(Integer.toHexString(System.identityHashCode(this))).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
            return stringBuilder.append("]").toString();
        }
        if (this.isDone()) {
            this.addDoneString(stringBuilder);
            return stringBuilder.append("]").toString();
        }
        this.addPendingString(stringBuilder);
        return stringBuilder.append("]").toString();
    }

    @Override
    protected final Throwable tryInternalFastPathGetFailure() {
        if (this instanceof Trusted && (this = ((AbstractFuture)this).value) instanceof Failure) {
            return ((Failure)this).exception;
        }
        return null;
    }

    private static CancellationException cancellationExceptionWithCause(String string, Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Class<Waiter> clazz;
        Throwable throwable;
        Object object;
        boolean bl;
        try {
            bl = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        GENERATE_CANCELLATION_CAUSES = bl;
        log = Logger.getLogger(AbstractFuture.class.getName());
        try {
            object = new UnsafeAtomicHelper();
            throwable = null;
            clazz = null;
        }
        catch (Error | RuntimeException throwable2) {
            try {
                clazz = Waiter.class;
                Class<Thread> clazz2 = Thread.class;
                String string = "thread";
                object = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(clazz, clazz2, string), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
                clazz = null;
            }
            catch (Error | RuntimeException throwable3) {
                object = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = object;
        if (clazz != null) {
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
            log.logp(Level.SEVERE, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", (Throwable)((Object)clazz));
        }
        NULL = object = new Object();
    }

    protected AbstractFuture() {
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            Object object = AbstractFuture.getUninterruptibly((Future)((Object)this));
            stringBuilder.append("SUCCESS, result=[");
            this.appendResultObject(stringBuilder, object);
            stringBuilder.append("]");
            return;
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
            return;
        }
    }

    public void addListener(Runnable runnable, Executor executor) {
        Listener listener;
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        if (!this.isDone() && (listener = this.listeners) != Listener.TOMBSTONE) {
            Listener listener2 = new Listener(runnable, executor);
            do {
                listener2.next = listener;
                if (!ATOMIC_HELPER.casListeners(this, listener, listener2)) continue;
                return;
            } while ((listener = this.listeners) != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addPendingString(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        stringBuilder.append("PENDING");
        Object object = this.value;
        if (object instanceof SetFuture) {
            stringBuilder.append(", setFuture=[");
            this.appendUserObject(stringBuilder, ((SetFuture)object).future);
            stringBuilder.append("]");
        } else {
            try {
                object = Strings.emptyToNull(this.pendingToString());
            }
            catch (RuntimeException | StackOverflowError throwable) {
                StringBuilder stringBuilder2 = new StringBuilder();
                object = stringBuilder2.append("Exception thrown from implementation: ").append(throwable.getClass()).toString();
            }
            if (object != null) {
                stringBuilder.append(", info=[").append((String)object).append("]");
            }
        }
        if (this.isDone()) {
            stringBuilder.delete(n, stringBuilder.length());
            this.addDoneString(stringBuilder);
            return;
        }
    }

    protected void afterDone() {
    }

    private void appendResultObject(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
            return;
        }
        if (object == this) {
            stringBuilder.append("this future");
            return;
        }
        stringBuilder.append(object.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(object)));
    }

    /*
     * Unable to fully structure code
     */
    private void appendUserObject(StringBuilder var1_2, Object var2_3) {
        if (var2_3 != this) ** GOTO lbl6
        try {
            var1_2.append("this future");
            return;
lbl6:
            // 1 sources

            var1_2.append(var2_3);
            return;
        }
        catch (RuntimeException | StackOverflowError var0_1) {
            var1_2.append("Exception thrown from implementation: ").append(var0_1.getClass());
            return;
        }
    }

    private static void complete(AbstractFuture object) {
        Listener listener = null;
        block0: while (true) {
            ((AbstractFuture)object).releaseWaiters();
            ((AbstractFuture)object).afterDone();
            object = ((AbstractFuture)object).clearListeners(listener);
            while (object != null) {
                listener = ((Listener)object).next;
                Object object2 = ((Listener)object).task;
                object2.getClass();
                if (object2 instanceof SetFuture) {
                    object = (SetFuture)object2;
                    object2 = ((SetFuture)object).owner;
                    if (((AbstractFuture)object2).value == object) {
                        Object object3 = ((SetFuture)object).future;
                        if (ATOMIC_HELPER.casValue((AbstractFuture)object2, object, object3 = AbstractFuture.getFutureValue(object3))) {
                            object = object2;
                            continue block0;
                        }
                        object = listener;
                        continue;
                    }
                    object = listener;
                    continue;
                }
                object = ((Listener)object).executor;
                object.getClass();
                AbstractFuture.executeListener((Runnable)object2, (Executor)object);
                object = listener;
            }
            break;
        }
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            logger.logp(level, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture", "executeListener", stringBuilder.append("RuntimeException while executing runnable ").append(runnable).append(" with executor ").append(executor).toString(), runtimeException);
            return;
        }
    }

    protected void interruptTask() {
    }

    /*
     * Enabled aggressive block sorting
     */
    final void maybePropagateCancellationTo(Future future) {
        boolean bl = future != null;
        if (bl & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
            return;
        }
    }

    private void releaseWaiters() {
        Object object = ATOMIC_HELPER.gasWaiters((AbstractFuture)object, Waiter.TOMBSTONE);
        while (object != null) {
            ((Waiter)object).unpark();
            object = ((Waiter)object).next;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter var1_1) {
        var1_1.thread = null;
        block0: while ((var2_2 = this.waiters) != Waiter.TOMBSTONE) {
            var1_1 = null;
            block1: while (var2_2 != null) {
                block4: {
                    var3_3 = var2_2.next;
                    if (var2_2.thread != null) {
                        var1_1 = var2_2;
lbl8:
                        // 3 sources

                        while (true) {
                            var2_2 = var3_3;
                            continue block1;
                            break;
                        }
                    }
                    if (var1_1 == null) break block4;
                    var1_1.next = var3_3;
                    if (var1_1.thread != null) ** GOTO lbl8
                    continue block0;
                }
                if (!AbstractFuture.ATOMIC_HELPER.casWaiters(this, var2_2, var3_3)) ** break;
                ** continue;
                continue block0;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean cancel(boolean bl) {
        Cancellation cancellation;
        Object object = abstractFuture2.value;
        boolean bl2 = object == null;
        if (!(bl2 | object instanceof SetFuture)) {
            return false;
        }
        if (GENERATE_CANCELLATION_CAUSES) {
            CancellationException cancellationException = new CancellationException("Future.cancel() was called.");
            cancellation = new Cancellation(bl, cancellationException);
        } else {
            cancellation = bl ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED;
            cancellation.getClass();
        }
        boolean bl3 = false;
        AbstractFuture abstractFuture = abstractFuture2;
        while (true) {
            if (ATOMIC_HELPER.casValue(abstractFuture, object, cancellation)) {
                if (bl) {
                    abstractFuture.interruptTask();
                }
                AbstractFuture.complete(abstractFuture);
                if (!(object instanceof SetFuture)) {
                    return true;
                }
                AbstractFuture abstractFuture2 = ((SetFuture)object).future;
                if (!(abstractFuture2 instanceof Trusted)) {
                    abstractFuture2.cancel(bl);
                    return true;
                }
                abstractFuture = abstractFuture2;
                object = abstractFuture.value;
                boolean bl4 = object == null;
                if (!(bl4 | object instanceof SetFuture)) {
                    return true;
                }
                bl3 = true;
                continue;
            }
            object = abstractFuture.value;
            if (!(object instanceof SetFuture)) break;
        }
        return bl3;
    }

    public boolean isCancelled() {
        return this.value instanceof Cancellation;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isDone() {
        boolean bl;
        Object object = this.value;
        boolean bl2 = object != null;
        if (!(object instanceof SetFuture)) {
            bl = true;
            return bl2 & bl;
        }
        bl = false;
        return bl2 & bl;
    }

    protected boolean set(Object object) {
        if (object == null) {
            object = NULL;
        }
        if (ATOMIC_HELPER.casValue(this, null, object)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        Failure failure = new Failure((Throwable)Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, failure)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setFuture(ListenableFuture object) {
        Object object2;
        Preconditions.checkNotNull(object);
        SetFuture setFuture = ((AbstractFuture)object2).value;
        if (setFuture == null) {
            if (object.isDone()) {
                Object object3 = AbstractFuture.getFutureValue(object);
                if (!ATOMIC_HELPER.casValue((AbstractFuture)object2, null, object3)) return false;
                AbstractFuture.complete((AbstractFuture)object2);
                return true;
            }
            setFuture = new SetFuture((AbstractFuture)object2, (ListenableFuture)object);
            if (ATOMIC_HELPER.casValue((AbstractFuture)object2, null, setFuture)) {
                object.addListener(setFuture, (Executor)DirectExecutor.INSTANCE);
                return true;
            }
            object2 = ((AbstractFuture)object2).value;
        } else {
            object2 = setFuture;
        }
        if (!(object2 instanceof Cancellation)) return false;
        object.cancel(((Cancellation)object2).wasInterrupted);
        return false;
        catch (Error | RuntimeException throwable) {
            void var1_5;
            try {
                Failure failure;
                Failure failure2 = failure = new Failure(throwable);
            }
            catch (Error | RuntimeException throwable2) {
                Failure failure = Failure.FALLBACK_INSTANCE;
            }
            ATOMIC_HELPER.casValue((AbstractFuture)object2, setFuture, var1_5);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean wasInterrupted() {
        Object object = ((AbstractFuture)object).value;
        if (!(object instanceof Cancellation)) return false;
        if (!((Cancellation)object).wasInterrupted) return false;
        return true;
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE;
        volatile Thread thread;
        volatile Waiter next;

        static {
            Waiter waiter;
            TOMBSTONE = waiter = new Waiter(false);
        }

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        Waiter(boolean bl) {
        }

        void setNext(Waiter waiter) {
            ATOMIC_HELPER.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
                return;
            }
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE;
        final Runnable task;
        final Executor executor;
        Listener next;

        static {
            Listener listener;
            TOMBSTONE = listener = new Listener();
        }

        Listener() {
            this.task = null;
            this.executor = null;
        }

        Listener(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }
    }

    private static abstract class AtomicHelper {
        abstract Listener gasListeners(AbstractFuture var1, Listener var2);

        abstract Waiter gasWaiters(AbstractFuture var1, Waiter var2);

        private AtomicHelper() {
        }

        abstract void putNext(Waiter var1, Waiter var2);

        abstract void putThread(Waiter var1, Thread var2);

        abstract boolean casListeners(AbstractFuture var1, Listener var2, Listener var3);

        abstract boolean casValue(AbstractFuture var1, Object var2, Object var3);

        abstract boolean casWaiters(AbstractFuture var1, Waiter var2, Waiter var3);
    }

    private static final class SetFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        SetFuture(AbstractFuture abstractFuture, ListenableFuture listenableFuture) {
            this.owner = abstractFuture;
            this.future = listenableFuture;
        }

        @Override
        public void run() {
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object object = this.future;
            object = AbstractFuture.getFutureValue(object);
            if (ATOMIC_HELPER.casValue(this.owner, this, object)) {
                AbstractFuture.complete((AbstractFuture)this.owner);
                return;
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                Cancellation cancellation;
                CAUSELESS_CANCELLED = cancellation = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = cancellation = new Cancellation(true, null);
            }
        }

        Cancellation(boolean bl, Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE;
        final Throwable exception;

        static {
            Failure failure;
            Throwable throwable = new Throwable("Failure occurred while trying to finish a future."){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
            FALLBACK_INSTANCE = failure = new Failure(throwable);
        }

        Failure(Throwable throwable) {
            this.exception = (Throwable)Preconditions.checkNotNull(throwable);
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        @Override
        Listener gasListeners(AbstractFuture abstractFuture, Listener listener) {
            Listener listener2;
            do {
                if (listener != (listener2 = abstractFuture.listeners)) continue;
                return listener2;
            } while (!this.casListeners(abstractFuture, listener2, listener));
            return listener2;
        }

        @Override
        Waiter gasWaiters(AbstractFuture abstractFuture, Waiter waiter) {
            Waiter waiter2;
            do {
                if (waiter != (waiter2 = abstractFuture.waiters)) continue;
                return waiter2;
            } while (!this.casWaiters(abstractFuture, waiter2, waiter));
            return waiter2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            PrivilegedExceptionAction<Unsafe> privilegedExceptionAction;
            try {
                privilegedExceptionAction = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    privilegedExceptionAction = new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            Field[] fieldArray = clazz.getDeclaredFields();
                            int n = fieldArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 < n) {
                                    Object object = fieldArray[n2];
                                    ((Field)object).setAccessible(true);
                                    object = ((Field)object).get(null);
                                    if (clazz.isInstance(object)) {
                                        return (Unsafe)clazz.cast(object);
                                    }
                                } else {
                                    NoSuchFieldError noSuchFieldError = new NoSuchFieldError("the Unsafe");
                                    throw noSuchFieldError;
                                }
                                ++n2;
                            }
                        }
                    };
                    privilegedExceptionAction = (Unsafe)AccessController.doPrivileged(privilegedExceptionAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    RuntimeException runtimeException = new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                    throw runtimeException;
                }
            }
            try {
                Class<AbstractFuture> clazz = AbstractFuture.class;
                WAITERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("waiters"));
                LISTENERS_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("listeners"));
                VALUE_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(clazz.getDeclaredField("value"));
                WAITER_THREAD_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = ((Unsafe)((Object)privilegedExceptionAction)).objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = privilegedExceptionAction;
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                RuntimeException runtimeException = new RuntimeException(noSuchFieldException);
                throw runtimeException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }

        private UnsafeAtomicHelper() {
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }

        @Override
        boolean casListeners(AbstractFuture abstractFuture, Listener listener, Listener listener2) {
            return AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(UNSAFE, abstractFuture, LISTENERS_OFFSET, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture abstractFuture, Object object, Object object2) {
            return AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(UNSAFE, abstractFuture, VALUE_OFFSET, object, object2);
        }

        @Override
        boolean casWaiters(AbstractFuture abstractFuture, Waiter waiter, Waiter waiter2) {
            return AbstractFuture$UnsafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(UNSAFE, abstractFuture, WAITERS_OFFSET, waiter, waiter2);
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater;

        @Override
        Listener gasListeners(AbstractFuture abstractFuture, Listener listener) {
            return this.listenersUpdater.getAndSet(abstractFuture, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFuture abstractFuture, Waiter waiter) {
            return this.waitersUpdater.getAndSet(abstractFuture, waiter);
        }

        SafeAtomicHelper(AtomicReferenceFieldUpdater atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            this.waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            this.waiterThreadUpdater.lazySet(waiter, thread);
        }

        @Override
        boolean casListeners(AbstractFuture abstractFuture, Listener listener, Listener listener2) {
            return AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.listenersUpdater, abstractFuture, listener, listener2);
        }

        @Override
        boolean casValue(AbstractFuture abstractFuture, Object object, Object object2) {
            return AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.valueUpdater, abstractFuture, object, object2);
        }

        @Override
        boolean casWaiters(AbstractFuture abstractFuture, Waiter waiter, Waiter waiter2) {
            return AbstractFuture$SafeAtomicHelper$$ExternalSyntheticBackportWithForwarding0.m(this.waitersUpdater, abstractFuture, waiter, waiter2);
        }
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Listener gasListeners(AbstractFuture abstractFuture, Listener listener) {
            synchronized (abstractFuture) {
                Listener listener2 = abstractFuture.listeners;
                if (listener2 == listener) return listener2;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$702(abstractFuture, listener);
                    return listener2;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        Waiter gasWaiters(AbstractFuture abstractFuture, Waiter waiter) {
            synchronized (abstractFuture) {
                Waiter waiter2 = abstractFuture.waiters;
                if (waiter2 == waiter) return waiter2;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$802(abstractFuture, waiter);
                    return waiter2;
                }
            }
        }

        private SynchronizedHelper() {
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casListeners(AbstractFuture abstractFuture, Listener listener, Listener listener2) {
            synchronized (abstractFuture) {
                Listener listener3 = abstractFuture.listeners;
                if (listener3 != listener) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$702(abstractFuture, listener2);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casValue(AbstractFuture abstractFuture, Object object, Object object2) {
            synchronized (abstractFuture) {
                Object object3 = abstractFuture.value;
                if (object3 != object) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$302(abstractFuture, object2);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        boolean casWaiters(AbstractFuture abstractFuture, Waiter waiter, Waiter waiter2) {
            synchronized (abstractFuture) {
                Waiter waiter3 = abstractFuture.waiters;
                if (waiter3 != waiter) return false;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
                {
                    AbstractFuture.access$802(abstractFuture, waiter2);
                    return true;
                }
            }
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        @Override
        public final Object get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public final Object get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }

        TrustedFuture() {
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        public final boolean cancel(boolean bl) {
            return super.cancel(bl);
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }
    }
}

