/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.core.internal.deps.guava.collect.RegularImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Sets;
import androidx.test.espresso.core.internal.deps.guava.collect.SingletonImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList asList;

    /*
     * Enabled aggressive block sorting
     */
    static int chooseTableSize(int n) {
        int n2 = Math.max(n, 2);
        if (n2 < 0x2CCCCCCC) {
            n = Integer.highestOneBit(n2 + -1);
            n += n;
            while (true) {
                if (!((double)n * 0.7 < (double)n2)) {
                    return n;
                }
                n += n;
            }
        }
        n = n2 < 0x40000000 ? 1 : 0;
        Preconditions.checkArgument(n != 0, "collection too large");
        return 0x40000000;
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    public ImmutableList asList() {
        ImmutableList immutableList = this.asList;
        if (immutableList == null) {
            this.asList = immutableList = this.createAsList();
            return immutableList;
        }
        return immutableList;
    }

    ImmutableList createAsList() {
        return ImmutableList.asImmutableList(this.toArray());
    }

    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static ImmutableSet construct(int var0, Object ... var1_4) {
        switch (var0) {
            default: {
                var6_5 = ImmutableSet.chooseTableSize(var0);
                var7_6 = new Object[var6_5];
                var8_7 = var6_5 + -1;
                var2_8 = 0;
                var3_9 = 0;
                block4: for (var4_10 = 0; var4_10 < var0; ++var4_10) {
                    var9_12 = ObjectArrays.checkElementNotNull(var1_4[var4_10], var4_10);
                    var10_13 = var9_12.hashCode();
                    var5_11 = Hashing.smear(var10_13);
                    while (true) {
                        if ((var12_15 = var7_6[var11_14 = var5_11 & var8_7]) == null) {
                            var5_11 = var3_9 + 1;
                            var1_4[var3_9] = var9_12;
                            var7_6[var11_14] = var9_12;
                            var2_8 += var10_13;
lbl18:
                            // 2 sources

                            while (true) {
                                var3_9 = var5_11;
                                continue block4;
                                break;
                            }
                        }
                        if (var12_15.equals(var9_12)) {
                            var5_11 = var3_9;
                            ** continue;
                        }
                        ++var5_11;
                    }
                }
                Arrays.fill(var1_4, var3_9, var0, null);
                if (var3_9 == 1) {
                    var0_1 = var1_4[0];
                    var0_1.getClass();
                    var1_4 = new SingletonImmutableSet(var0_1);
                    return var1_4;
                }
                if (ImmutableSet.chooseTableSize(var3_9) < var6_5 / 2) {
                    return ImmutableSet.construct(var3_9, var1_4);
                }
                if (ImmutableSet.shouldTrim(var3_9, var1_4.length)) {
                    var0_2 = Arrays.copyOf(var1_4, var3_9);
lbl37:
                    // 2 sources

                    while (true) {
                        var1_4 = new RegularImmutableSet(var0_2, var2_8, var7_6, var8_7, var3_9);
                        return var1_4;
                    }
                }
                var0_2 = var1_4;
                ** continue;
            }
            case 1: {
                var0_3 = var1_4[0];
                var0_3.getClass();
                return ImmutableSet.of(var0_3);
            }
            case 0: 
        }
        return ImmutableSet.of();
    }

    public static ImmutableSet copyOf(Object[] objectArray) {
        switch (objectArray.length) {
            default: {
                return ImmutableSet.construct(objectArray.length, (Object[])objectArray.clone());
            }
            case 1: {
                return ImmutableSet.of(objectArray[0]);
            }
            case 0: 
        }
        return ImmutableSet.of();
    }

    public static ImmutableSet of() {
        return RegularImmutableSet.EMPTY;
    }

    public static ImmutableSet of(Object object) {
        SingletonImmutableSet singletonImmutableSet = new SingletonImmutableSet(object);
        return singletonImmutableSet;
    }

    @Override
    public abstract UnmodifiableIterator iterator();

    @Override
    Object writeReplace() {
        SerializedForm serializedForm = new SerializedForm(this.toArray());
        return serializedForm;
    }

    ImmutableSet() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        Serializable serializable = new InvalidObjectException("Use SerializedForm");
        throw serializable;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    boolean isHashCodeFast() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTrim(int n, int n2) {
        if (n >= (n2 >> 1) + (n2 >> 2)) return 0 != 0;
        return 1 != 0;
    }

    public static class Builder
    extends ImmutableCollection.ArrayBasedBuilder {
        Object[] hashTable;
        private int hashCode;

        @Override
        public Builder add(Object object) {
            Preconditions.checkNotNull(object);
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) <= this.hashTable.length) {
                this.addDeduping(object);
                return this;
            }
            this.hashTable = null;
            super.add(object);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Builder add(Object ... objectArray) {
            if (this.hashTable != null) {
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.add(objectArray[i]);
                }
                return this;
            }
            super.add(objectArray);
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public ImmutableSet build() {
            switch (((Builder)object).size) {
                default: {
                    void var1_4;
                    if (((Builder)object).hashTable != null && ImmutableSet.chooseTableSize(((Builder)object).size) == ((Builder)object).hashTable.length) {
                        void var1_2;
                        RegularImmutableSet regularImmutableSet;
                        if (ImmutableSet.shouldTrim(((Builder)object).size, ((Builder)object).contents.length)) {
                            Object[] objectArray = Arrays.copyOf(((Builder)object).contents, ((Builder)object).size);
                        } else {
                            Object[] objectArray = ((Builder)object).contents;
                        }
                        RegularImmutableSet regularImmutableSet2 = regularImmutableSet = new RegularImmutableSet((Object[])var1_2, ((Builder)object).hashCode, ((Builder)object).hashTable, ((Builder)object).hashTable.length + -1, ((Builder)object).size);
                    } else {
                        ImmutableSet immutableSet = ImmutableSet.construct(((Builder)object).size, ((Builder)object).contents);
                        ((Builder)object).size = immutableSet.size();
                    }
                    ((Builder)object).forceCopy = true;
                    ((Builder)object).hashTable = null;
                    return var1_4;
                }
                case 1: {
                    Object object = ((Builder)object).contents[0];
                    object.getClass();
                    return ImmutableSet.of(object);
                }
                case 0: 
            }
            return ImmutableSet.of();
        }

        public Builder() {
            super(4);
        }

        private void addDeduping(Object object) {
            this.hashTable.getClass();
            int n = this.hashTable.length + -1;
            int n2 = object.hashCode();
            int n3 = Hashing.smear(n2);
            while (true) {
                Object object2;
                if ((object2 = this.hashTable[n3 &= n]) == null) {
                    this.hashTable[n3] = object;
                    this.hashCode += n2;
                    super.add(object);
                    return;
                }
                if (object2.equals(object)) {
                    return;
                }
                ++n3;
            }
        }
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Object[] elements;

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }
    }
}

