/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.cache;

import androidx.test.espresso.core.internal.deps.guava.cache.LongAddable;
import androidx.test.espresso.core.internal.deps.guava.cache.Striped64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class LongAdder
extends Striped64
implements Serializable,
LongAddable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    public double doubleValue() {
        return this.sum();
    }

    @Override
    public float floatValue() {
        return this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    final long fn(long l, long l2) {
        return l + l2;
    }

    @Override
    public long longValue() {
        return this.sum();
    }

    /*
     * Enabled aggressive block sorting
     */
    public long sum() {
        long l = this.base;
        Striped64.Cell[] cellArray = this.cells;
        if (cellArray == null) {
            return l;
        }
        int n = cellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Striped64.Cell cell = cellArray[n2];
            long l2 = cell != null ? (l += cell.value) : l;
            ++n2;
            l = l2;
        }
        return l;
    }

    public String toString() {
        return Long.toString(this.sum());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(long l) {
        block0: {
            boolean bl;
            int[] nArray;
            block5: {
                block1: {
                    block2: {
                        block3: {
                            block4: {
                                long l2;
                                Object object = this.cells;
                                if (object == null && this.casBase(l2 = this.base, l2 + l)) break block0;
                                nArray = (int[])threadHashCode.get();
                                if (nArray == null) break block1;
                                if (object == null) break block2;
                                int n = ((Striped64.Cell[])object).length;
                                if (n <= 0) break block3;
                                if ((object = object[n + -1 & nArray[0]]) == null) break block4;
                                l2 = ((Striped64.Cell)object).value;
                                bl = ((Striped64.Cell)object).cas(l2, l2 + l);
                                if (bl) break block0;
                                break block5;
                            }
                            bl = true;
                            break block5;
                        }
                        bl = true;
                        break block5;
                    }
                    bl = true;
                    break block5;
                }
                bl = true;
            }
            this.retryUpdate(l, nArray, bl);
            return;
        }
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        void var1_1;
        s.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = var1_1.readLong();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        void var1_1;
        s.defaultWriteObject();
        var1_1.writeLong(this.sum());
    }
}

