/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.util.Log;
import android.view.View;
import androidx.test.espresso.RootViewException;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.ViewHierarchyExceptionHandler$$ExternalSyntheticBackport0;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.util.Checks;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.services.storage.TestStorageException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;

class ViewHierarchyExceptionHandler<T extends Throwable>
extends DefaultFailureHandler.TypedFailureHandler<T> {
    private static final String TAG = ViewHierarchyExceptionHandler.class.getSimpleName();
    private static final int MAX_MSG_SIZE = 63488;
    private static final String VIEW_HIERARCHY_CHAR_LIMIT = "view_hierarchy_char_limit";
    private final PlatformTestStorage testStorage;
    private final AtomicInteger failureCount;
    private final Truncater<T> truncater;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getMsgLen() {
        boolean bl = ((ViewHierarchyExceptionHandler)((Object)this_)).testStorage.getInputArgs().containsKey(VIEW_HIERARCHY_CHAR_LIMIT);
        if (!bl) return 63488;
        String this_ = ((ViewHierarchyExceptionHandler)((Object)this_)).testStorage.getInputArg(VIEW_HIERARCHY_CHAR_LIMIT);
        if (this_ == null) return 63488;
        try {
            return Integer.parseInt(this_);
        }
        catch (TestStorageException | NumberFormatException throwable) {
            Log.e((String)TAG, (String)"Failed to parse input argument view_hierarchy_char_limit", (Throwable)throwable);
            return 63488;
        }
    }

    private String dumpFullViewHierarchyToFile(T error) {
        CharSequence charSequence = HumanReadables.getViewHierarchyErrorMessage(((RootViewException)error).getRootView(), null, "", null);
        Object object = ((ViewHierarchyExceptionHandler)((Object)string)).failureCount;
        object = String.valueOf(object);
        StringBuilder stringBuilder = new StringBuilder();
        object = stringBuilder.append("view-hierarchy-").append((String)object).append(".txt").toString();
        try {
            ((ViewHierarchyExceptionHandler)((Object)string)).addOutputFile((String)object, (String)charSequence);
            String string = TAG;
            charSequence = new StringBuilder();
            Log.w((String)string, (String)((StringBuilder)charSequence).append("The complete view hierarchy is available in artifact file '").append((String)object).append("'.").toString());
            return object;
        }
        catch (IOException iOException) {
            charSequence = TAG;
            stringBuilder = new StringBuilder();
            Log.w((String)charSequence, (String)stringBuilder.append("Failed to save the view hierarchy to file ").append((String)object).toString(), (Throwable)iOException);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ViewHierarchyExceptionHandler(PlatformTestStorage testStorage, AtomicInteger failureCount, Class<T> expectedType, Truncater<T> truncater) {
        void var4_4;
        void var2_2;
        void var1_1;
        void var3_3;
        Class[] classArray = new Class[]{var3_3};
        super(classArray);
        this.testStorage = (PlatformTestStorage)Checks.checkNotNull((Object)var1_1);
        this.failureCount = var2_2;
        this.truncater = var4_4;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addOutputFile(String filename, String content) throws IOException {
        void var1_2;
        OutputStream this_;
        OutputStream outputStream = ((ViewHierarchyExceptionHandler)((Object)this_)).testStorage.openOutputFile((String)var1_2);
        try {
            void var2_4;
            outputStream.write(var2_4.getBytes());
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
            }
            catch (Throwable throwable2) {
                ViewHierarchyExceptionHandler$$ExternalSyntheticBackport0.m(throwable, throwable2);
                throw throwable;
            }
            throw throwable;
        }
        outputStream.close();
    }

    @Override
    public void handleSafely(T exception, Matcher<View> object) {
        RuntimeException runtimeException;
        object = ((ViewHierarchyExceptionHandler)((Object)this_)).dumpFullViewHierarchyToFile(runtimeException);
        runtimeException.setStackTrace(Thread.currentThread().getStackTrace());
        int n = ((ViewHierarchyExceptionHandler)((Object)this_)).getMsgLen();
        Throwable this_ = ((ViewHierarchyExceptionHandler)((Object)this_)).truncater.truncateExceptionMessage((void)runtimeException, n, (String)object);
        Throwables.throwIfUnchecked(this_);
        runtimeException = new RuntimeException(this_);
        throw runtimeException;
    }

    static interface Truncater<T> {
        public Throwable truncateExceptionMessage(T var1, int var2, String var3);
    }
}

