/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.assertion;

import android.view.View;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public final class ViewAssertions {
    private static final String TAG = ViewAssertions.class.getSimpleName();

    public static ViewAssertion doesNotExist() {
        DoesNotExistViewAssertion doesNotExistViewAssertion = new DoesNotExistViewAssertion();
        return doesNotExistViewAssertion;
    }

    public static ViewAssertion matches(Matcher<? super View> viewMatcher) {
        Matcher<? super View> matcher;
        MatchesViewAssertion matchesViewAssertion = new MatchesViewAssertion((Matcher)Preconditions.checkNotNull(matcher));
        return matchesViewAssertion;
    }

    /*
     * WARNING - void declaration
     */
    public static ViewAssertion selectedDescendantsMatch(Matcher<View> selector, Matcher<View> matcher) {
        void var1_1;
        Matcher<View> matcher2;
        SelectedDescendantsMatchViewAssertion selectedDescendantsMatchViewAssertion = new SelectedDescendantsMatchViewAssertion(matcher2, (Matcher)var1_1);
        return selectedDescendantsMatchViewAssertion;
    }

    private ViewAssertions() {
    }

    static class DoesNotExistViewAssertion
    implements ViewAssertion {
        @RemoteMsgConstructor
        private DoesNotExistViewAssertion() {
        }

        @Override
        public void check(View view, NoMatchingViewException noMatchingViewException) {
            if (view != null) {
                StringBuilder stringBuilder;
                String string = HumanReadables.describe((View)stringBuilder);
                stringBuilder = new StringBuilder();
                ViewMatchers.assertThat(stringBuilder.append("View is present in the hierarchy: ").append(string).toString(), true, Matchers.is((Object)false));
                return;
            }
        }
    }

    static class MatchesViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        final Matcher<? super View> viewMatcher;

        public String toString() {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.viewMatcher};
            return String.format(locale, "MatchesViewAssertion{viewMatcher=%s}", objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private MatchesViewAssertion(Matcher<? super View> viewMatcher) {
            void var1_1;
            this.viewMatcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(View view, NoMatchingViewException noViewException) {
            void var1_1;
            StringDescription stringDescription;
            if (noViewException != null) {
                throw stringDescription;
            }
            stringDescription = new StringDescription();
            stringDescription.appendText("'");
            this.viewMatcher.describeTo((Description)stringDescription);
            stringDescription.appendText("' doesn't match the selected view.");
            ViewMatchers.assertThat(stringDescription.toString(), var1_1, this.viewMatcher);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class SelectedDescendantsMatchViewAssertion
    implements ViewAssertion {
        @RemoteMsgField(order=0)
        private final Matcher<View> selector;
        @RemoteMsgField(order=1)
        private final Matcher<View> matcher;

        public String toString() {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{this.selector, this.matcher};
            return String.format(locale, "SelectedDescendantsMatchViewAssertion{selector=%s, matcher=%s}", objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private SelectedDescendantsMatchViewAssertion(Matcher<View> selector, Matcher<View> matcher) {
            void var2_2;
            void var1_1;
            this.selector = var1_1;
            this.matcher = var2_2;
        }

        @Override
        public void check(View view, NoMatchingViewException predicate) {
            Object[] objectArray;
            AssertionFailedError assertionFailedError;
            Preconditions.checkNotNull(view);
            predicate = new Predicate<View>((SelectedDescendantsMatchViewAssertion)object){
                final /* synthetic */ SelectedDescendantsMatchViewAssertion this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean apply(View input) {
                    void var1_1;
                    return this.this$0.selector.matches((Object)var1_1);
                }
            };
            predicate = Iterables.filter(TreeIterables.breadthFirstViewTraversal((View)assertionFailedError), predicate).iterator();
            ArrayList<View> arrayList = new ArrayList<View>();
            while (predicate.hasNext()) {
                objectArray = predicate.next();
                if (((SelectedDescendantsMatchViewAssertion)object).matcher.matches((Object)objectArray)) continue;
                arrayList.add((View)objectArray);
            }
            if (arrayList.size() > 0) {
                predicate = Locale.ROOT;
                objectArray = new Object[]{((SelectedDescendantsMatchViewAssertion)object).matcher};
                Object object = String.format((Locale)((Object)predicate), "At least one view did not match the required matcher: %s", objectArray);
                object = HumanReadables.getViewHierarchyErrorMessage((View)assertionFailedError, arrayList, (String)object, "****DOES NOT MATCH****");
                assertionFailedError = new AssertionFailedError((String)object);
                throw assertionFailedError;
            }
        }
    }
}

