/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.SystemClock;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.ActivityLifecycles;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Locale;
import org.hamcrest.Matcher;

class KeyEventActionBase
implements ViewAction {
    private static final String TAG = "KeyEventActionBase";
    public static final int BACK_ACTIVITY_TRANSITION_MILLIS_DELAY = 150;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_ATTEMPTS = 4;
    public static final int CLEAR_TRANSITIONING_ACTIVITIES_MILLIS_DELAY = 150;
    final EspressoKey espressoKey;

    static Activity getCurrentActivity() {
        return (Activity)Iterables.getOnlyElement(ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED));
    }

    @Override
    public String getDescription() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.espressoKey};
        return String.format(locale, "send %s key event", objectArray);
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayed();
    }

    /*
     * WARNING - void declaration
     */
    KeyEventActionBase(EspressoKey espressoKey) {
        void var1_1;
        this.espressoKey = (EspressoKey)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void perform(UiController uiController, View view) {
        block3: {
            void var2_5;
            try {
                void var1_1;
                boolean bl = this.sendKeyEvent((UiController)var1_1);
                if (bl) break block3;
            }
            catch (InjectEventSecurityException injectEventSecurityException) {
                Object object = this.espressoKey;
                object = String.valueOf(object);
                StringBuilder stringBuilder = new StringBuilder();
                Log.e((String)TAG, (String)stringBuilder.append("Failed to inject espressoKey event: ").append((String)object).toString());
                object = new PerformException.Builder();
                throw ((PerformException.Builder)object).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)var2_5)).withCause((Throwable)((Object)injectEventSecurityException)).build();
            }
            Object object = this.espressoKey;
            object = String.valueOf(object);
            Object object2 = new StringBuilder();
            Log.e((String)TAG, (String)((StringBuilder)object2).append("Failed to inject espressoKey event: ").append((String)object).toString());
            object = new PerformException.Builder();
            object = ((PerformException.Builder)object).withActionDescription(this.getDescription());
            object2 = HumanReadables.describe((View)var2_5);
            object = ((PerformException.Builder)object).withViewDescription((String)object2);
            Object object3 = this.espressoKey;
            object3 = String.valueOf(object3);
            StringBuilder stringBuilder = new StringBuilder();
            object2 = new RuntimeException(stringBuilder.append("Failed to inject espressoKey event ").append((String)object3).toString());
            throw ((PerformException.Builder)object).withCause((Throwable)object2).build();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static void waitForPendingForegroundActivities(UiController controller, boolean conditional) {
        boolean bl;
        ActivityLifecycleMonitor activityLifecycleMonitor;
        block5: {
            activityLifecycleMonitor = ActivityLifecycleMonitorRegistry.getInstance();
            boolean bl2 = false;
            for (int i = 0; i < 4; ++i) {
                UiController uiController;
                uiController.loopMainThreadUntilIdle();
                bl2 = ActivityLifecycles.hasTransitioningActivities(activityLifecycleMonitor);
                if (bl2) {
                    uiController.loopMainThreadForAtLeast(150L);
                    continue;
                }
                bl = bl2;
                break block5;
            }
            bl = bl2;
        }
        if (!ActivityLifecycles.hasForegroundActivities(activityLifecycleMonitor)) {
            void var1_3;
            if (var1_3 != false) {
                NoActivityResumedException noActivityResumedException = new NoActivityResumedException("Pressed back and killed the app");
                throw noActivityResumedException;
            }
            Log.w((String)TAG, (String)"Pressed back and hopped to a different process or potentially killed the app");
        }
        if (bl) {
            Log.w((String)TAG, (String)"Back was pressed and left the application in an inconsistent state even after 600ms.");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void waitForStageChangeInitialActivity(UiController controller, Activity initialActivity) {
        if (KeyEventActionBase.isActivityResumed(initialActivity)) {
            void var1_1;
            UiController uiController;
            uiController.loopMainThreadForAtLeast(150L);
            if (KeyEventActionBase.isActivityResumed((Activity)var1_1)) {
                Log.i((String)TAG, (String)"Back was pressed but there was no Activity stage transition in 150ms. Pressing back may trigger an activity stage transition if the activity is finished as a result. However, the activity may handle the back behavior in any number of other ways internally as well, such as popping the fragment back stack, dismissing a dialog, otherwise manually transacting fragments, etc.");
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isActivityResumed(Activity activity) {
        Activity activity2;
        if (ActivityLifecycleMonitorRegistry.getInstance().getLifecycleStageOf(activity2) != Stage.RESUMED) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean sendKeyEvent(UiController controller) throws InjectEventSecurityException {
        void var1_1;
        int n;
        long l = SystemClock.uptimeMillis();
        boolean bl = false;
        for (n = 0; !bl && n < 4; ++n) {
            KeyEvent keyEvent = new KeyEvent(l, l, 0, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState());
            bl = var1_1.injectKeyEvent(keyEvent);
        }
        if (!bl) {
            return false;
        }
        long l2 = SystemClock.uptimeMillis();
        bl = false;
        for (n = 0; !bl && n < 4; ++n) {
            KeyEvent keyEvent = new KeyEvent(l2, l2, 1, this.espressoKey.getKeyCode(), 0, this.espressoKey.getMetaState());
            bl = var1_1.injectKeyEvent(keyEvent);
        }
        return bl;
    }
}

