/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.view.View;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;

public interface AdapterViewProtocol {
    public EspressoOptional<AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> var1, View var2);

    public Iterable<AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> var1);

    public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> var1, AdaptedData var2);

    public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> var1, AdaptedData var2);

    public static class AdaptedData {
        @Deprecated
        public final Object data;
        public final Object opaqueToken;
        private final DataFunction dataFunction;

        public Object getData() {
            return this.dataFunction.getData();
        }

        /*
         * Enabled aggressive block sorting
         */
        public String toString() {
            Object object = this.getData();
            String string = object == null ? "null" : object.getClass().getName();
            if (object instanceof Cursor) {
                object = HumanReadables.describe((Cursor)object);
            }
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{object, string, this.opaqueToken};
            return String.format(locale, "Data: %s (class: %s) token: %s", objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private AdaptedData(Object data, Object opaqueToken, DataFunction dataFunction) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.data = var1_1;
            this.opaqueToken = Preconditions.checkNotNull(var2_2);
            this.dataFunction = (DataFunction)Preconditions.checkNotNull(var3_3);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static class Builder {
            private Object data;
            private Object opaqueToken;
            private DataFunction dataFunction;

            /*
             * WARNING - void declaration
             */
            public Builder withData(Object data) {
                void var1_1;
                this.data = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder withDataFunction(DataFunction dataFunction) {
                void var1_1;
                this.dataFunction = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder withOpaqueToken(Object opaqueToken) {
                void var1_1;
                this.opaqueToken = var1_1;
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public AdaptedData build() {
                if (this.dataFunction != null) {
                    this.data = this.dataFunction.getData();
                    return new AdaptedData(this.data, this.opaqueToken, this.dataFunction);
                }
                DataFunction dataFunction = new DataFunction(this){
                    final /* synthetic */ Builder this$0;

                    @Override
                    public Object getData() {
                        return this.this$0.data;
                    }
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }
                };
                this.dataFunction = dataFunction;
                return new AdaptedData(this.data, this.opaqueToken, this.dataFunction);
            }
        }
    }

    public static interface DataFunction {
        public Object getData();
    }
}

