/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.InteractionResultsHandler;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.ViewInteraction$1$$ExternalSyntheticBackport0;
import androidx.test.espresso.ViewInteraction$2$$ExternalSyntheticBackport0;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.base.InterruptableUiController;
import androidx.test.espresso.base.MainThread;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableMap;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.internal.data.TestFlowVisualizer;
import androidx.test.espresso.internal.data.model.ActionData;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.remote.IInteractionExecutionStatus;
import androidx.test.espresso.remote.RemoteInteraction;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TracingUtil;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.Checks;
import androidx.test.internal.util.LogUtil;
import androidx.test.platform.tracing.Tracer;
import androidx.test.platform.tracing.Tracing;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ViewInteraction {
    private static final String TAG = ViewInteraction.class.getSimpleName();
    private final InterruptableUiController uiController;
    private final ViewFinder viewFinder;
    private final Executor mainThreadExecutor;
    private final ControlledLooper controlledLooper;
    private volatile FailureHandler failureHandler;
    private final Matcher<View> viewMatcher;
    private final AtomicReference<Matcher<Root>> rootMatcherRef;
    private final AtomicReference<Boolean> needsActivity;
    private final RemoteInteraction remoteInteraction;
    private final ListeningExecutorService remoteExecutor;
    private final TestFlowVisualizer testFlowVisualizer;
    private final Tracing tracer;
    private boolean hasRootMatcher = false;

    /*
     * WARNING - void declaration
     */
    public ViewInteraction check(ViewAssertion viewAssert) {
        void var1_1;
        Preconditions.checkNotNull(viewAssert);
        SingleExecutionViewAssertion singleExecutionViewAssertion = new SingleExecutionViewAssertion((ViewAssertion)var1_1);
        Callable<Void> callable = new Callable<Void>(){
            final /* synthetic */ ViewAssertion val$viewAssert;
            final /* synthetic */ SingleExecutionViewAssertion val$singleExecutionViewAssertion;
            final /* synthetic */ ViewInteraction this$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() {
                Object[] objectArray = new Object[]{TracingUtil.getClassName(this.val$viewAssert, "ViewAssertion"), this.this$0.viewMatcher};
                objectArray = TracingUtil.getSpanName("Espresso", "check", objectArray);
                Tracer.Span span = this.this$0.tracer.beginSpan((String)objectArray);
                try {
                    NoMatchingViewException noMatchingViewException;
                    this.this$0.uiController.loopMainThreadUntilIdle();
                    try {
                        objectArray = this.this$0.viewFinder.getView();
                        noMatchingViewException = null;
                    }
                    catch (NoMatchingViewException noMatchingViewException2) {
                        objectArray = null;
                    }
                    String string = TAG;
                    Locale locale = Locale.ROOT;
                    String string2 = "Checking '%s' assertion on view %s";
                    Object[] objectArray2 = new Object[]{this.val$viewAssert, this.this$0.viewMatcher};
                    Log.i((String)string, (String)String.format(locale, string2, objectArray2));
                    this.val$singleExecutionViewAssertion.check((View)objectArray, noMatchingViewException);
                    if (span == null) return null;
                }
                catch (Throwable throwable) {
                    if (span == null) throw throwable;
                    try {
                        span.close();
                    }
                    catch (Throwable throwable2) {
                        ViewInteraction$2$$ExternalSyntheticBackport0.m(throwable, throwable2);
                        throw throwable;
                    }
                    throw throwable;
                }
                span.close();
                return null;
            }
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$viewAssert = viewAssertion;
                this.val$singleExecutionViewAssertion = singleExecutionViewAssertion;
            }
        };
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            callable = this.remoteExecutor;
            RemoteInteraction remoteInteraction = this.remoteInteraction;
            Matcher matcher = this.rootMatcherRef;
            matcher = matcher.get();
            matcher = matcher;
            Matcher<View> matcher2 = this.viewMatcher;
            ViewAssertion[] viewAssertionArray = new ViewAssertion[]{singleExecutionViewAssertion, var1_1};
            arrayList.add((ListenableFuture<Void>)callable.submit(remoteInteraction.createRemoteCheckCallable((Matcher<Root>)matcher, matcher2, ViewInteraction.getIBindersFromViewAssertions(viewAssertionArray), (ViewAssertion)var1_1)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction inRoot(Matcher<Root> rootMatcher) {
        void var1_1;
        this.hasRootMatcher = true;
        this.rootMatcherRef.set((Matcher<Root>)((Matcher)Preconditions.checkNotNull(var1_1)));
        return this;
    }

    public ViewInteraction noActivity() {
        if (!this.hasRootMatcher) {
            this.rootMatcherRef.set((Matcher<Root>)Matchers.anyOf(RootMatchers.DEFAULT, (Matcher)Matchers.allOf(RootMatchers.hasWindowLayoutParams(), RootMatchers.isSystemAlertWindow())));
        }
        this.needsActivity.set(false);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction perform(ViewAction ... viewActions) {
        void var1_1;
        Preconditions.checkNotNull(viewActions);
        for (void var4_4 : var1_1) {
            int n = this.testFlowVisualizer.getLastActionIndexAndIncrement();
            boolean bl = this.testFlowVisualizer.isEnabled();
            if (bl) {
                this.testFlowVisualizer.beforeActionGenerateTestArtifact(n);
            }
            SingleExecutionViewAction singleExecutionViewAction = new SingleExecutionViewAction((ViewAction)var4_4, this.viewMatcher);
            this.desugaredPerform(singleExecutionViewAction, n, bl);
            if (!bl) continue;
            this.testFlowVisualizer.afterActionGenerateTestArtifact(n);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction withFailureHandler(FailureHandler failureHandler) {
        void var1_1;
        this.failureHandler = (FailureHandler)Preconditions.checkNotNull(var1_1);
        return this;
    }

    private ListenableFuture<Void> postAsynchronouslyOnUiThread(Callable<Void> interaction) {
        ListenableFutureTask listenableFutureTask;
        Checks.checkNotMainThread();
        listenableFutureTask = ListenableFutureTask.create((Callable)((Object)listenableFutureTask));
        this.mainThreadExecutor.execute(listenableFutureTask);
        return listenableFutureTask;
    }

    private static List<Bindable> getBindables(Object ... objects) {
        Object[] objectArray;
        ArrayList arrayList = Lists.newArrayListWithCapacity(objects.length);
        for (Object object : objectArray) {
            if (!(object instanceof Bindable)) continue;
            arrayList.add((Bindable)object);
        }
        return arrayList;
    }

    private static Map<String, IBinder> getIBindersFromBindables(List<Bindable> bindables) {
        Iterator<Bindable> iterator;
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Bindable bindable = (Bindable)iterator.next();
            hashMap.put((String)Preconditions.checkNotNull(bindable.getId(), "Bindable id cannot be null!"), (IBinder)Preconditions.checkNotNull(bindable.getIBinder(), "Bindable binder cannot be null!"));
        }
        return ImmutableMap.copyOf(hashMap);
    }

    private static Map<String, IBinder> getIBindersFromViewActions(ViewAction ... viewActions) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewActions));
    }

    private static Map<String, IBinder> getIBindersFromViewAssertions(ViewAssertion ... viewAssertions) {
        return ViewInteraction.getIBindersFromBindables(ViewInteraction.getBindables(viewAssertions));
    }

    /*
     * WARNING - void declaration
     */
    ViewInteraction(UiController uiController, ViewFinder viewFinder, @MainThread Executor mainThreadExecutor, FailureHandler failureHandler, Matcher<View> viewMatcher, AtomicReference<Matcher<Root>> rootMatcherRef, AtomicReference<Boolean> needsActivity, RemoteInteraction remoteInteraction, ListeningExecutorService remoteExecutor, ControlledLooper controlledLooper, TestFlowVisualizer testFlowVisualizer, Tracing tracer) {
        void var12_12;
        void var11_11;
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var3_3;
        void var4_4;
        void var1_1;
        void var2_2;
        this.viewFinder = (ViewFinder)Preconditions.checkNotNull(var2_2);
        this.uiController = (InterruptableUiController)Preconditions.checkNotNull(var1_1);
        this.failureHandler = (FailureHandler)Preconditions.checkNotNull(var4_4);
        this.mainThreadExecutor = (Executor)Preconditions.checkNotNull(var3_3);
        this.viewMatcher = (Matcher)Preconditions.checkNotNull(var5_5);
        this.rootMatcherRef = (AtomicReference)Preconditions.checkNotNull(var6_6);
        this.needsActivity = (AtomicReference)Preconditions.checkNotNull(var7_7);
        this.remoteInteraction = (RemoteInteraction)Preconditions.checkNotNull(var8_8);
        this.remoteExecutor = (ListeningExecutorService)Preconditions.checkNotNull(var9_9);
        this.controlledLooper = (ControlledLooper)Preconditions.checkNotNull(var10_10);
        this.testFlowVisualizer = (TestFlowVisualizer)Preconditions.checkNotNull(var11_11);
        this.tracer = var12_12;
    }

    /*
     * WARNING - void declaration
     */
    private void desugaredPerform(SingleExecutionViewAction va, int actionIndex, boolean testFlowEnabled) {
        void var3_4;
        void var2_2;
        Map<String, IBinder> map;
        ViewAction viewAction = va.getInnerViewAction();
        Callable<Void> callable = new Callable<Void>(){
            final /* synthetic */ ViewAction val$innerViewAction;
            final /* synthetic */ SingleExecutionViewAction val$va;
            final /* synthetic */ int val$actionIndex;
            final /* synthetic */ boolean val$testFlowEnabled;
            final /* synthetic */ ViewInteraction this$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() {
                Object[] objectArray = new Object[]{TracingUtil.getClassName(this.val$innerViewAction, this.val$innerViewAction.getDescription()), this.this$0.viewMatcher};
                objectArray = TracingUtil.getSpanName("Espresso", "perform", objectArray);
                objectArray = this.this$0.tracer.beginSpan((String)objectArray);
                try {
                    this.this$0.doPerform(this.val$va, this.val$actionIndex, this.val$testFlowEnabled);
                    if (objectArray == null) return null;
                }
                catch (Throwable throwable) {
                    if (objectArray == null) throw throwable;
                    try {
                        objectArray.close();
                    }
                    catch (Throwable throwable2) {
                        ViewInteraction$1$$ExternalSyntheticBackport0.m(throwable, throwable2);
                        throw throwable;
                    }
                    throw throwable;
                }
                objectArray.close();
                return null;
            }
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$innerViewAction = viewAction;
                this.val$va = singleExecutionViewAction;
                this.val$actionIndex = n;
                this.val$testFlowEnabled = bl;
            }
        };
        ArrayList<ListenableFuture<Void>> arrayList = new ArrayList<ListenableFuture<Void>>();
        arrayList.add(this.postAsynchronouslyOnUiThread(callable));
        if (!this.remoteInteraction.isRemoteProcess()) {
            ListeningExecutorService listeningExecutorService = this.remoteExecutor;
            callable = this.remoteInteraction;
            Matcher matcher = this.rootMatcherRef;
            matcher = matcher.get();
            matcher = matcher;
            Matcher<View> matcher2 = this.viewMatcher;
            ViewAction[] viewActionArray = new ViewAction[]{map, viewAction};
            map = ViewInteraction.getIBindersFromViewActions(viewActionArray);
            viewActionArray = new ViewAction[]{viewAction};
            arrayList.add((ListenableFuture<Void>)listeningExecutorService.submit(callable.createRemotePerformCallable((Matcher<Root>)matcher, matcher2, map, viewActionArray)));
        }
        this.waitForAndHandleInteractionResults(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    private void doPerform(SingleExecutionViewAction viewAction, int actionIndex, boolean testFlowEnabled) {
        void var3_4;
        void var2_2;
        Object object;
        Preconditions.checkNotNull(viewAction);
        Object object2 = (Matcher)Preconditions.checkNotNull(((SingleExecutionViewAction)object).getConstraints());
        ((ViewInteraction)object4).uiController.loopMainThreadUntilIdle();
        View view = ((ViewInteraction)object4).viewFinder.getView();
        String string = TAG;
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((SingleExecutionViewAction)object).getDescription(), ((ViewInteraction)object4).viewMatcher};
        Log.i((String)string, (String)String.format(locale, "Performing '%s' action on view %s", objectArray));
        if (!object2.matches((Object)view)) {
            Object object3 = new StringBuilder("Action will not be performed because the target view does not match one or more of the following constraints:\n");
            StringDescription stringDescription = new StringDescription((Appendable)object3);
            object2.describeTo((Description)stringDescription);
            stringDescription.appendText("\nTarget view: ").appendValue((Object)HumanReadables.describe(view));
            if (((SingleExecutionViewAction)object).getInnerViewAction() instanceof ScrollToAction && ViewMatchers.isDescendantOfA(ViewMatchers.isAssignableFrom(AdapterView.class)).matches((Object)view)) {
                stringDescription.appendText("\nFurther Info: ScrollToAction on a view inside an AdapterView will not work. Use Espresso.onData to load the view.");
            }
            object3 = new PerformException.Builder();
            object = ((SingleExecutionViewAction)object).getDescription();
            object = ((PerformException.Builder)object3).withActionDescription((String)object);
            Object object4 = ((ViewInteraction)object4).viewMatcher;
            object4 = object4.toString();
            object4 = ((PerformException.Builder)object).withViewDescription((String)object4);
            object = new RuntimeException(stringDescription.toString());
            throw ((PerformException.Builder)object4).withCause((Throwable)object).build();
        }
        object2 = new ActionData((int)var2_2, ((SingleExecutionViewAction)object).viewAction);
        if (var3_4 != false) {
            ((ViewInteraction)object4).testFlowVisualizer.beforeActionRecordData((ActionData)object2, view);
        }
        ((SingleExecutionViewAction)object).perform(((ViewInteraction)object4).uiController, view);
        if (var3_4 != false) {
            ((ViewInteraction)object4).testFlowVisualizer.afterActionRecordData((ActionData)object2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForAndHandleInteractionResults(List<ListenableFuture<Void>> interactions) {
        try {
            void var1_1;
            this.controlledLooper.drainMainThreadUntilIdle();
            InteractionResultsHandler.gatherAnyResult(var1_1);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.failureHandler.handle(runtimeException, this.viewMatcher);
            return;
        }
        catch (Error error) {
            this.failureHandler.handle(error, this.viewMatcher);
        }
        finally {
            this.uiController.interruptEspressoTasks();
        }
    }

    private static final class SingleExecutionViewAction
    implements ViewAction,
    Bindable {
        final ViewAction viewAction;
        final Matcher<View> viewMatcher;
        private IInteractionExecutionStatus actionExecutionStatus;

        @Override
        public IBinder getIBinder() {
            return this.actionExecutionStatus.asBinder();
        }

        ViewAction getInnerViewAction() {
            return this.viewAction;
        }

        @Override
        public String getDescription() {
            return this.viewAction.getDescription();
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        @Override
        public Matcher<View> getConstraints() {
            return this.viewAction.getConstraints();
        }

        /*
         * WARNING - void declaration
         */
        private SingleExecutionViewAction(ViewAction viewAction, Matcher<View> viewMatcher) {
            void var2_2;
            void var1_1;
            IInteractionExecutionStatus.Stub stub = new IInteractionExecutionStatus.Stub(this){
                AtomicBoolean run;
                {
                    this.run = object = new AtomicBoolean(true);
                }

                @Override
                public boolean canExecute() throws RemoteException {
                    return this.run.getAndSet(false);
                }
            };
            this.actionExecutionStatus = stub;
            this.viewAction = var1_1;
            this.viewMatcher = var2_2;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void perform(UiController uiController, View view) {
            Object object;
            String string;
            try {
                boolean bl = ((SingleExecutionViewAction)this_).actionExecutionStatus.canExecute();
                if (!bl) {
                    string = TAG;
                    object = ((SingleExecutionViewAction)this_).viewAction;
                    object = String.valueOf(object);
                    Object[] objectArray = new StringBuilder();
                    object = objectArray.append("Attempted to execute a Single Execution Action more then once: ").append((String)object).toString();
                    objectArray = new Object[]{};
                    LogUtil.logDebugWithProcess((String)string, (String)object, (Object[])objectArray);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                object = new PerformException.Builder();
                Object object2 = ((SingleExecutionViewAction)this_).viewAction;
                object2 = object2.getDescription();
                object = ((PerformException.Builder)object).withActionDescription((String)object2);
                Object this_ = ((SingleExecutionViewAction)this_).viewMatcher;
                this_ = this_.toString();
                this_ = ((PerformException.Builder)object).withViewDescription((String)this_);
                object = new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
                throw ((PerformException.Builder)this_).withCause((Throwable)object).build();
            }
            {
                ((SingleExecutionViewAction)this_).viewAction.perform((UiController)((Object)string), (View)object);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setIBinder(IBinder binder) {
            void var1_1;
            this.actionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface((IBinder)var1_1);
        }
    }

    private static final class SingleExecutionViewAssertion
    implements ViewAssertion,
    Bindable {
        final ViewAssertion viewAssertion;
        private IInteractionExecutionStatus assertionExecutionStatus;

        @Override
        public IBinder getIBinder() {
            return this.assertionExecutionStatus.asBinder();
        }

        @Override
        public String getId() {
            return "executionStatus";
        }

        /*
         * WARNING - void declaration
         */
        private SingleExecutionViewAssertion(ViewAssertion viewAssertion) {
            void var1_1;
            IInteractionExecutionStatus.Stub stub = new IInteractionExecutionStatus.Stub(this){
                AtomicBoolean run;
                {
                    this.run = object = new AtomicBoolean(true);
                }

                @Override
                public boolean canExecute() throws RemoteException {
                    return this.run.getAndSet(false);
                }
            };
            this.assertionExecutionStatus = stub;
            this.viewAssertion = var1_1;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void check(View view, NoMatchingViewException noViewFoundException) {
            Object[] objectArray;
            Object object;
            try {
                boolean bl = ((SingleExecutionViewAssertion)this_).assertionExecutionStatus.canExecute();
                if (!bl) {
                    object = TAG;
                    Object this_ = ((SingleExecutionViewAssertion)this_).viewAssertion;
                    this_ = String.valueOf(this_);
                    objectArray = new StringBuilder();
                    this_ = objectArray.append("Attempted to execute a Single Execution Assertion more then once: ").append((String)this_).toString();
                    objectArray = new Object[]{};
                    LogUtil.logDebugWithProcess((String)object, (String)this_, (Object[])objectArray);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                object = new RuntimeException("Unable to query interaction execution status", remoteException.getCause());
                throw object;
            }
            {
                ((SingleExecutionViewAssertion)this_).viewAssertion.check((View)object, (NoMatchingViewException)objectArray);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setIBinder(IBinder binder) {
            void var1_1;
            this.assertionExecutionStatus = IInteractionExecutionStatus.Stub.asInterface((IBinder)var1_1);
        }
    }
}

