/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import android.view.ViewParent;
import android.widget.Adapter;
import android.widget.AdapterView;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.Root;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.action.AdapterDataLoaderAction;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.action.AdapterViewProtocols;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.RootMatchers;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.ConstructorInvocation;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.EspressoOptional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class DataInteraction {
    private final Matcher<? extends Object> dataMatcher;
    private Matcher<View> adapterMatcher = ViewMatchers.isAssignableFrom(AdapterView.class);
    private EspressoOptional<Matcher<View>> childViewMatcher = EspressoOptional.absent();
    private EspressoOptional<Integer> atPosition = EspressoOptional.absent();
    private AdapterViewProtocol adapterViewProtocol = AdapterViewProtocols.standardProtocol();
    private Matcher<Root> rootMatcher = RootMatchers.DEFAULT;

    /*
     * WARNING - void declaration
     */
    public DataInteraction atPosition(Integer atPosition) {
        void var1_1;
        this.atPosition = EspressoOptional.of((Integer)Preconditions.checkNotNull(var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DataInteraction inAdapterView(Matcher<View> adapterMatcher) {
        void var1_1;
        this.adapterMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DataInteraction inRoot(Matcher<Root> rootMatcher) {
        void var1_1;
        this.rootMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DataInteraction onChildView(Matcher<View> childMatcher) {
        void var1_1;
        this.childViewMatcher = EspressoOptional.of((Matcher)Preconditions.checkNotNull(var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DataInteraction usingAdapterViewProtocol(AdapterViewProtocol adapterViewProtocol) {
        void var1_1;
        this.adapterViewProtocol = (AdapterViewProtocol)Preconditions.checkNotNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction check(ViewAssertion assertion) {
        void var1_1;
        return Espresso.onView(this.makeTargetMatcher()).inRoot(this.rootMatcher).check((ViewAssertion)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ViewInteraction perform(ViewAction ... actions) {
        void var1_1;
        return Espresso.onView(this.makeTargetMatcher()).inRoot(this.rootMatcher).perform((ViewAction[])var1_1);
    }

    private Matcher<View> makeTargetMatcher() {
        DisplayDataMatcher displayDataMatcher = DisplayDataMatcher.displayDataMatcher(this.adapterMatcher, this.dataMatcher, this.rootMatcher, this.atPosition, this.adapterViewProtocol);
        if (this.childViewMatcher.isPresent()) {
            return Matchers.allOf(this.childViewMatcher.get(), ViewMatchers.isDescendantOfA((Matcher<View>)displayDataMatcher));
        }
        return displayDataMatcher;
    }

    /*
     * WARNING - void declaration
     */
    DataInteraction(Matcher<? extends Object> dataMatcher) {
        void var1_1;
        this.dataMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
    }

    public static final class DisplayDataMatcher
    extends TypeSafeMatcher<View> {
        private static final String TAG = "DisplayDataMatcher";
        @RemoteMsgField(order=0)
        private final Matcher<View> adapterMatcher;
        @RemoteMsgField(order=1)
        private final Matcher<? extends Object> dataMatcher;
        @RemoteMsgField(order=2)
        private final Class<? extends AdapterViewProtocol> adapterViewProtocolClass;
        @RemoteMsgField(order=3)
        private final AdapterDataLoaderAction adapterDataLoaderAction;
        private final AdapterViewProtocol adapterViewProtocol;

        /*
         * WARNING - void declaration
         */
        public static DisplayDataMatcher displayDataMatcher(Matcher<View> adapterMatcher, Matcher<? extends Object> dataMatcher, Matcher<Root> rootMatcher, EspressoOptional<Integer> atPosition, AdapterViewProtocol adapterViewProtocol) {
            void var2_2;
            Matcher<View> matcher;
            void var4_4;
            void var3_3;
            void var1_1;
            AdapterDataLoaderAction adapterDataLoaderAction = new AdapterDataLoaderAction((Matcher<? extends Object>)var1_1, (EspressoOptional<Integer>)var3_3, (AdapterViewProtocol)var4_4);
            DisplayDataMatcher displayDataMatcher = new DisplayDataMatcher(matcher, (Matcher<? extends Object>)var1_1, (Matcher<Root>)var2_2, (AdapterViewProtocol)var4_4, adapterDataLoaderAction);
            return displayDataMatcher;
        }

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        DisplayDataMatcher(Matcher<View> adapterMatcher, Matcher<? extends Object> dataMatcher, Class<? extends AdapterViewProtocol> adapterViewProtocolClass, AdapterDataLoaderAction adapterDataLoaderAction) throws IllegalAccessException, InstantiationException {
            void var4_4;
            void var2_2;
            void var1_1;
            void var3_3;
            Matcher<Root> matcher = RootMatchers.DEFAULT;
            ConstructorInvocation constructorInvocation = new ConstructorInvocation((Class<?>)var3_3, null, new Class[0]);
            this((Matcher<View>)var1_1, (Matcher<? extends Object>)var2_2, matcher, (AdapterViewProtocol)var3_3.cast(constructorInvocation.invokeConstructor(new Object[0])), (AdapterDataLoaderAction)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        DisplayDataMatcher(Matcher<View> adapterMatcher, Matcher<? extends Object> dataMatcher, AdapterViewProtocol adapterViewProtocol, AdapterDataLoaderAction adapterDataLoaderAction, Function<AdapterDataLoaderAction, ViewInteraction> loadDataFunction) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.adapterMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
            this.dataMatcher = (Matcher)Preconditions.checkNotNull(var2_2);
            this.adapterViewProtocol = (AdapterViewProtocol)Preconditions.checkNotNull(var3_3);
            this.adapterViewProtocolClass = var3_3.getClass();
            this.adapterDataLoaderAction = (AdapterDataLoaderAction)Preconditions.checkNotNull(var4_4);
            ((Function)Preconditions.checkNotNull(var5_5)).apply(var4_4);
        }

        /*
         * WARNING - void declaration
         */
        private DisplayDataMatcher(Matcher<View> adapterMatcher, Matcher<? extends Object> dataMatcher, Matcher<Root> rootMatcher, AdapterViewProtocol adapterViewProtocol, AdapterDataLoaderAction adapterDataLoaderAction) {
            void var5_5;
            void var4_4;
            void var2_2;
            void var3_3;
            void var1_1;
            Function<AdapterDataLoaderAction, ViewInteraction> function = new Function<AdapterDataLoaderAction, ViewInteraction>(){
                final /* synthetic */ Matcher val$adapterMatcher;
                final /* synthetic */ Matcher val$rootMatcher;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ViewInteraction apply(AdapterDataLoaderAction adapterDataLoaderAction) {
                    void var1_1;
                    Object object = this_.val$adapterMatcher;
                    object = Espresso.onView((Matcher<View>)object);
                    Object this_ = this_.val$rootMatcher;
                    this_ = ((ViewInteraction)object).inRoot((Matcher<Root>)this_);
                    object = new ViewAction[]{var1_1};
                    return ((ViewInteraction)this_).perform((ViewAction[])object);
                }
                {
                    this.val$adapterMatcher = matcher;
                    this.val$rootMatcher = matcher2;
                }
            };
            this((Matcher<View>)var1_1, (Matcher<? extends Object>)var2_2, (AdapterViewProtocol)var4_4, (AdapterDataLoaderAction)var5_5, function);
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            description.appendText(" displaying data matching: ");
            this.dataMatcher.describeTo((Description)var1_1);
            var1_1.appendText(" within adapter view matching: ");
            this.adapterMatcher.describeTo((Description)var1_1);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean matchesSafely(View view) {
            EspressoOptional<AdapterViewProtocol.AdaptedData> espressoOptional;
            ViewParent viewParent;
            boolean bl = this.adapterViewProtocol != null;
            Preconditions.checkState(bl, "adapterViewProtocol cannot be null!");
            for (viewParent = espressoOptional.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
            }
            if (viewParent != null && this.adapterMatcher.matches((Object)viewParent) && (espressoOptional = this.adapterViewProtocol.getDataRenderedByView((AdapterView<? extends Adapter>)((AdapterView)viewParent), (View)espressoOptional)).isPresent()) {
                return espressoOptional.get().opaqueToken.equals(this.adapterDataLoaderAction.getAdaptedData().opaqueToken);
            }
            return false;
        }
    }
}

