/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.content.Context;
import android.os.Looper;
import android.view.View;
import androidx.test.espresso.BaseLayerComponent;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.Root;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.ViewInteractionComponent;
import androidx.test.espresso.ViewInteractionModule;
import androidx.test.espresso.ViewInteractionModule_ProvideNeedsActivityFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRemoteInteractionFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRootMatcherFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideRootViewFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideTestFlowVisualizerFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideViewFinderFactory;
import androidx.test.espresso.ViewInteractionModule_ProvideViewMatcherFactory;
import androidx.test.espresso.base.ActiveRootLister;
import androidx.test.espresso.base.BaseLayerModule;
import androidx.test.espresso.base.BaseLayerModule_FailureHandlerHolder_Factory;
import androidx.test.espresso.base.BaseLayerModule_ProvideActiveRootListerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideControlledLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDefaultFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideDynamicNotiferFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideEventInjectorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHanderFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideFailureHandlerFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideLifecycleMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainLooperFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideMainThreadExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideRemoteExecutorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvideTargetContextFactory;
import androidx.test.espresso.base.BaseLayerModule_ProvidesTracingFactory;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.base.EventInjector;
import androidx.test.espresso.base.IdleNotifier;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.base.IdlingResourceRegistry_Factory;
import androidx.test.espresso.base.PlatformTestStorageModule;
import androidx.test.espresso.base.PlatformTestStorageModule_ProvideTestStorageFactory;
import androidx.test.espresso.base.RootViewPicker;
import androidx.test.espresso.base.RootViewPicker_Factory;
import androidx.test.espresso.base.RootViewPicker_RootResultFetcher_Factory;
import androidx.test.espresso.base.RootsOracle;
import androidx.test.espresso.base.RootsOracle_Factory;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor;
import androidx.test.espresso.base.ThreadPoolExecutorExtractor_Factory;
import androidx.test.espresso.base.UiControllerImpl;
import androidx.test.espresso.base.UiControllerImpl_Factory;
import androidx.test.espresso.base.UiControllerModule;
import androidx.test.espresso.base.UiControllerModule_ProvideUiControllerFactory;
import androidx.test.espresso.base.ViewFinderImpl;
import androidx.test.espresso.base.ViewFinderImpl_Factory;
import androidx.test.espresso.core.internal.deps.dagger.internal.DoubleCheck;
import androidx.test.espresso.core.internal.deps.dagger.internal.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.internal.data.TestFlowVisualizer;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.platform.io.PlatformTestStorage;
import androidx.test.platform.tracing.Tracing;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitor;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.hamcrest.Matcher;

public final class DaggerBaseLayerComponent {
    public static BaseLayerComponent create() {
        Builder builder = new Builder();
        return builder.build();
    }

    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    private DaggerBaseLayerComponent() {
    }

    public static final class Builder {
        private BaseLayerModule baseLayerModule;
        private PlatformTestStorageModule platformTestStorageModule;
        private UiControllerModule uiControllerModule;

        public BaseLayerComponent build() {
            Object object;
            if (this.baseLayerModule == null) {
                this.baseLayerModule = object = new BaseLayerModule();
            }
            if (this.platformTestStorageModule == null) {
                this.platformTestStorageModule = object = new PlatformTestStorageModule();
            }
            if (this.uiControllerModule == null) {
                this.uiControllerModule = object = new UiControllerModule();
            }
            object = new BaseLayerComponentImpl(this.baseLayerModule, this.platformTestStorageModule, this.uiControllerModule);
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public Builder baseLayerModule(BaseLayerModule baseLayerModule) {
            void var1_1;
            this.baseLayerModule = (BaseLayerModule)Preconditions.checkNotNull(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder platformTestStorageModule(PlatformTestStorageModule platformTestStorageModule) {
            void var1_1;
            this.platformTestStorageModule = (PlatformTestStorageModule)Preconditions.checkNotNull(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder uiControllerModule(UiControllerModule uiControllerModule) {
            void var1_1;
            this.uiControllerModule = (UiControllerModule)Preconditions.checkNotNull(var1_1);
            return this;
        }

        private Builder() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class BaseLayerComponentImpl
    implements BaseLayerComponent {
        private final BaseLayerModule baseLayerModule;
        private final PlatformTestStorageModule platformTestStorageModule;
        private final BaseLayerComponentImpl baseLayerComponentImpl = this;
        private Provider<Context> provideTargetContextProvider;
        private Provider<PlatformTestStorage> provideTestStorageProvider;
        private Provider<DefaultFailureHandler> provideDefaultFailureHanderProvider;
        private Provider<FailureHandler> provideFailureHanderProvider;
        private Provider<BaseLayerModule.FailureHandlerHolder> failureHandlerHolderProvider;
        private Provider<Looper> provideMainLooperProvider;
        private Provider<Tracing> providesTracingProvider;
        private Provider<IdlingResourceRegistry> idlingResourceRegistryProvider;
        private Provider provideEventInjectorProvider;
        private Provider threadPoolExecutorExtractorProvider;
        private Provider provideSdkAsyncTaskMonitorProvider;
        private Provider provideCompatAsyncTaskMonitorProvider;
        private Provider provideDynamicNotiferProvider;
        private Provider uiControllerImplProvider;
        private Provider<UiController> provideUiControllerProvider;
        private Provider<Executor> provideMainThreadExecutorProvider;
        private Provider<ControlledLooper> provideControlledLooperProvider;
        private Provider rootsOracleProvider;
        private Provider<ActiveRootLister> provideActiveRootListerProvider;
        private Provider<ActivityLifecycleMonitor> provideLifecycleMonitorProvider;
        private Provider<ListeningExecutorService> provideRemoteExecutorProvider;

        @Override
        public FailureHandler failureHandler() {
            return BaseLayerModule_ProvideFailureHandlerFactory.provideFailureHandler(this.baseLayerModule, (BaseLayerModule.FailureHandlerHolder)this.failureHandlerHolderProvider.get());
        }

        @Override
        public UiController uiController() {
            return (UiController)this.provideUiControllerProvider.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ViewInteractionComponent plus(ViewInteractionModule module) {
            void var1_1;
            Preconditions.checkNotNull(module);
            ViewInteractionComponentImpl viewInteractionComponentImpl = new ViewInteractionComponentImpl(this.baseLayerComponentImpl, (ViewInteractionModule)var1_1);
            return viewInteractionComponentImpl;
        }

        @Override
        public ActiveRootLister activeRootLister() {
            return BaseLayerModule_ProvideActiveRootListerFactory.provideActiveRootLister(this.baseLayerModule, this.rootsOracle());
        }

        @Override
        public BaseLayerModule.FailureHandlerHolder failureHolder() {
            return (BaseLayerModule.FailureHandlerHolder)this.failureHandlerHolderProvider.get();
        }

        @Override
        public IdlingResourceRegistry idlingResourceRegistry() {
            return (IdlingResourceRegistry)this.idlingResourceRegistryProvider.get();
        }

        @Override
        public ControlledLooper controlledLooper() {
            return (ControlledLooper)this.provideControlledLooperProvider.get();
        }

        @Override
        public PlatformTestStorage testStorage() {
            return PlatformTestStorageModule_ProvideTestStorageFactory.provideTestStorage(this.platformTestStorageModule);
        }

        @Override
        public Tracing tracer() {
            return (Tracing)this.providesTracingProvider.get();
        }

        private Object rootsOracle() {
            return RootsOracle_Factory.newInstance((Looper)this.provideMainLooperProvider.get());
        }

        @Override
        public Executor mainThreadExecutor() {
            return (Executor)this.provideMainThreadExecutorProvider.get();
        }

        /*
         * WARNING - void declaration
         */
        private BaseLayerComponentImpl(BaseLayerModule baseLayerModuleParam, PlatformTestStorageModule platformTestStorageModuleParam, UiControllerModule uiControllerModuleParam) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.baseLayerModule = var1_1;
            this.platformTestStorageModule = var2_2;
            this.initialize((BaseLayerModule)var1_1, (PlatformTestStorageModule)var2_2, (UiControllerModule)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private void initialize(BaseLayerModule baseLayerModuleParam, PlatformTestStorageModule platformTestStorageModuleParam, UiControllerModule uiControllerModuleParam) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.provideTargetContextProvider = BaseLayerModule_ProvideTargetContextFactory.create((BaseLayerModule)var1_1);
            this.provideTestStorageProvider = PlatformTestStorageModule_ProvideTestStorageFactory.create((PlatformTestStorageModule)var2_2);
            this.provideDefaultFailureHanderProvider = BaseLayerModule_ProvideDefaultFailureHanderFactory.create((BaseLayerModule)var1_1, this.provideTargetContextProvider, this.provideTestStorageProvider);
            this.provideFailureHanderProvider = BaseLayerModule_ProvideFailureHanderFactory.create((BaseLayerModule)var1_1, this.provideDefaultFailureHanderProvider);
            this.failureHandlerHolderProvider = DoubleCheck.provider(BaseLayerModule_FailureHandlerHolder_Factory.create(this.provideFailureHanderProvider));
            this.provideMainLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainLooperFactory.create((BaseLayerModule)var1_1));
            this.providesTracingProvider = DoubleCheck.provider(BaseLayerModule_ProvidesTracingFactory.create((BaseLayerModule)var1_1));
            this.idlingResourceRegistryProvider = DoubleCheck.provider(IdlingResourceRegistry_Factory.create(this.provideMainLooperProvider, this.providesTracingProvider));
            this.provideEventInjectorProvider = DoubleCheck.provider(BaseLayerModule_ProvideEventInjectorFactory.create((BaseLayerModule)var1_1));
            this.threadPoolExecutorExtractorProvider = DoubleCheck.provider(ThreadPoolExecutorExtractor_Factory.create(this.provideMainLooperProvider));
            this.provideSdkAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideSdkAsyncTaskMonitorFactory.create((BaseLayerModule)var1_1, (Provider<ThreadPoolExecutorExtractor>)this.threadPoolExecutorExtractorProvider));
            this.provideCompatAsyncTaskMonitorProvider = DoubleCheck.provider(BaseLayerModule_ProvideCompatAsyncTaskMonitorFactory.create((BaseLayerModule)var1_1, (Provider<ThreadPoolExecutorExtractor>)this.threadPoolExecutorExtractorProvider));
            this.provideDynamicNotiferProvider = BaseLayerModule_ProvideDynamicNotiferFactory.create((BaseLayerModule)var1_1, this.idlingResourceRegistryProvider);
            this.uiControllerImplProvider = DoubleCheck.provider(UiControllerImpl_Factory.create((Provider<EventInjector>)this.provideEventInjectorProvider, (Provider<IdleNotifier<Runnable>>)this.provideSdkAsyncTaskMonitorProvider, (Provider<IdleNotifier<Runnable>>)this.provideCompatAsyncTaskMonitorProvider, (Provider<IdleNotifier<IdlingResourceRegistry.IdleNotificationCallback>>)this.provideDynamicNotiferProvider, this.provideMainLooperProvider, this.idlingResourceRegistryProvider));
            this.provideUiControllerProvider = DoubleCheck.provider(UiControllerModule_ProvideUiControllerFactory.create((UiControllerModule)var3_3, (Provider<UiControllerImpl>)this.uiControllerImplProvider));
            this.provideMainThreadExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideMainThreadExecutorFactory.create((BaseLayerModule)var1_1, this.provideMainLooperProvider));
            this.provideControlledLooperProvider = DoubleCheck.provider(BaseLayerModule_ProvideControlledLooperFactory.create((BaseLayerModule)var1_1));
            this.rootsOracleProvider = RootsOracle_Factory.create(this.provideMainLooperProvider);
            this.provideActiveRootListerProvider = BaseLayerModule_ProvideActiveRootListerFactory.create((BaseLayerModule)var1_1, (Provider<RootsOracle>)this.rootsOracleProvider);
            this.provideLifecycleMonitorProvider = BaseLayerModule_ProvideLifecycleMonitorFactory.create((BaseLayerModule)var1_1);
            this.provideRemoteExecutorProvider = DoubleCheck.provider(BaseLayerModule_ProvideRemoteExecutorFactory.create((BaseLayerModule)var1_1));
        }
    }

    private static final class ViewInteractionComponentImpl
    implements ViewInteractionComponent {
        private final ViewInteractionModule viewInteractionModule;
        private final BaseLayerComponentImpl baseLayerComponentImpl;
        private final ViewInteractionComponentImpl viewInteractionComponentImpl = this;
        private Provider<AtomicReference<Matcher<Root>>> provideRootMatcherProvider;
        private Provider rootResultFetcherProvider;
        private Provider<AtomicReference<Boolean>> provideNeedsActivityProvider;
        private Provider<RootViewPicker> rootViewPickerProvider;
        private Provider<View> provideRootViewProvider;

        private ViewFinder viewFinder() {
            return ViewInteractionModule_ProvideViewFinderFactory.provideViewFinder(this.viewInteractionModule, this.viewFinderImpl());
        }

        @Override
        public ViewInteraction viewInteraction() {
            ViewInteraction viewInteraction = new ViewInteraction((UiController)this.baseLayerComponentImpl.provideUiControllerProvider.get(), this.viewFinder(), (Executor)this.baseLayerComponentImpl.provideMainThreadExecutorProvider.get(), this.baseLayerComponentImpl.failureHandler(), ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(this.viewInteractionModule), ViewInteractionModule_ProvideRootMatcherFactory.provideRootMatcher(this.viewInteractionModule), ViewInteractionModule_ProvideNeedsActivityFactory.provideNeedsActivity(this.viewInteractionModule), ViewInteractionModule_ProvideRemoteInteractionFactory.provideRemoteInteraction(this.viewInteractionModule), (ListeningExecutorService)this.baseLayerComponentImpl.provideRemoteExecutorProvider.get(), (ControlledLooper)this.baseLayerComponentImpl.provideControlledLooperProvider.get(), this.testFlowVisualizer(), (Tracing)this.baseLayerComponentImpl.providesTracingProvider.get());
            return viewInteraction;
        }

        private ViewFinderImpl viewFinderImpl() {
            return ViewFinderImpl_Factory.newInstance(ViewInteractionModule_ProvideViewMatcherFactory.provideViewMatcher(this.viewInteractionModule), this.provideRootViewProvider);
        }

        private TestFlowVisualizer testFlowVisualizer() {
            return ViewInteractionModule_ProvideTestFlowVisualizerFactory.provideTestFlowVisualizer(this.viewInteractionModule, PlatformTestStorageModule_ProvideTestStorageFactory.provideTestStorage(this.baseLayerComponentImpl.platformTestStorageModule));
        }

        /*
         * WARNING - void declaration
         */
        private ViewInteractionComponentImpl(BaseLayerComponentImpl baseLayerComponentImpl, ViewInteractionModule viewInteractionModuleParam) {
            void var2_2;
            void var1_1;
            this.baseLayerComponentImpl = var1_1;
            this.viewInteractionModule = var2_2;
            this.initialize((ViewInteractionModule)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void initialize(ViewInteractionModule viewInteractionModuleParam) {
            void var1_1;
            this.provideRootMatcherProvider = ViewInteractionModule_ProvideRootMatcherFactory.create((ViewInteractionModule)var1_1);
            this.rootResultFetcherProvider = RootViewPicker_RootResultFetcher_Factory.create((Provider<ActiveRootLister>)this.baseLayerComponentImpl.provideActiveRootListerProvider, this.provideRootMatcherProvider);
            this.provideNeedsActivityProvider = ViewInteractionModule_ProvideNeedsActivityFactory.create((ViewInteractionModule)var1_1);
            this.rootViewPickerProvider = DoubleCheck.provider(RootViewPicker_Factory.create((Provider<UiController>)this.baseLayerComponentImpl.provideUiControllerProvider, (Provider<RootViewPicker.RootResultFetcher>)this.rootResultFetcherProvider, (Provider<ActivityLifecycleMonitor>)this.baseLayerComponentImpl.provideLifecycleMonitorProvider, this.provideNeedsActivityProvider, (Provider<ControlledLooper>)this.baseLayerComponentImpl.provideControlledLooperProvider, (Provider<Context>)this.baseLayerComponentImpl.provideTargetContextProvider));
            this.provideRootViewProvider = ViewInteractionModule_ProvideRootViewFactory.create((ViewInteractionModule)var1_1, this.rootViewPickerProvider);
        }
    }
}

