/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.AmbiguousViewMatcherException-IA;
import androidx.test.espresso.RootViewException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class AmbiguousViewMatcherException
extends RuntimeException
implements RootViewException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private View view1;
    private View view2;
    private View[] others;

    @Override
    public View getRootView() {
        return this.rootView;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getErrorMessage(Builder builder) {
        String string;
        if (builder.includeViewHierarchy) {
            Object[] objectArray;
            Object[] objectArray2;
            void var1_3;
            ImmutableSet.Builder builder2 = ImmutableSet.builder();
            Object object = new View[]{((Builder)((Object)string)).view1, ((Builder)((Object)string)).view2};
            object = Lists.newArrayList(builder2.add((Object[])object).add(((Builder)((Object)string)).others).build());
            StringBuilder stringBuilder = new StringBuilder();
            int n = ((ArrayList)object).size();
            boolean bl = false;
            while (var1_3 < n) {
                if (var1_3 < 5) {
                    objectArray2 = Locale.ROOT;
                    objectArray = new Object[]{(int)(var1_3 + true), HumanReadables.describe((View)((ArrayList)object).get((int)var1_3))};
                    stringBuilder.append(String.format((Locale)objectArray2, "\n- [%d] %s", objectArray));
                    ++var1_3;
                    continue;
                }
                Locale locale = Locale.ROOT;
                objectArray2 = new Object[]{n};
                stringBuilder.append(String.format(locale, "\n- [truncated, listing 5 out of %d views].", objectArray2));
                break;
            }
            View view = ((Builder)((Object)string)).rootView;
            objectArray2 = Locale.ROOT;
            objectArray = new Object[]{((Builder)((Object)string)).viewMatcher, n, stringBuilder};
            String string2 = HumanReadables.getViewHierarchyErrorMessage(view, (List<View>)object, String.format((Locale)objectArray2, "'%s' matches %d views in the hierarchy:%s", objectArray), "****MATCHES****", ((Builder)((Object)string)).maxMsgLen);
            if (((Builder)((Object)string)).viewHierarchyFile == null) return string2;
            object = new Object[]{((Builder)((Object)string)).viewHierarchyFile};
            string = String.format("\nThe complete view hierarchy is available in artifact file '%s'.", (Object[])object);
            object = new StringBuilder();
            return ((StringBuilder)object).append(string2).append(string).toString();
        }
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((Builder)((Object)string)).viewMatcher};
        return String.format(locale, "Multiple ambiguous views found for matcher %s", objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private AmbiguousViewMatcherException(Builder builder) {
        this(AmbiguousViewMatcherException.getErrorMessage((Builder)var1_1));
        void var1_1;
        this.viewMatcher = ((Builder)var1_1).viewMatcher;
        this.rootView = ((Builder)var1_1).rootView;
        this.view1 = ((Builder)var1_1).view1;
        this.view2 = ((Builder)var1_1).view2;
        this.others = ((Builder)var1_1).others;
    }

    /*
     * WARNING - void declaration
     */
    private AmbiguousViewMatcherException(String description) {
        super((String)var1_1);
        void var1_1;
        TestOutputEmitter.dumpThreadStates((String)"ThreadState-AmbiguousViewMatcherException.txt");
    }

    /* synthetic */ AmbiguousViewMatcherException(Builder builder, AmbiguousViewMatcherException-IA ambiguousViewMatcherException-IA) {
        this(builder);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private View view1;
        private View view2;
        private View[] others;
        private boolean includeViewHierarchy = true;
        private int maxMsgLen = Integer.MAX_VALUE;
        private String viewHierarchyFile = null;

        /*
         * WARNING - void declaration
         */
        public Builder from(AmbiguousViewMatcherException exception) {
            void var1_1;
            this.viewMatcher = ((AmbiguousViewMatcherException)var1_1).viewMatcher;
            this.rootView = ((AmbiguousViewMatcherException)var1_1).rootView;
            this.view1 = ((AmbiguousViewMatcherException)var1_1).view1;
            this.view2 = ((AmbiguousViewMatcherException)var1_1).view2;
            this.others = ((AmbiguousViewMatcherException)var1_1).others;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder includeViewHierarchy(boolean includeViewHierarchy) {
            void var1_1;
            this.includeViewHierarchy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withMaxMsgLen(int maxMsgLen) {
            void var1_1;
            this.maxMsgLen = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withOtherAmbiguousViews(View ... others) {
            void var1_1;
            this.others = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withRootView(View rootView) {
            void var1_1;
            this.rootView = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withView1(View view1) {
            void var1_1;
            this.view1 = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withView2(View view2) {
            void var1_1;
            this.view2 = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewHierarchyFile(String viewHierarchyFile) {
            void var1_1;
            this.viewHierarchyFile = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewMatcher(Matcher<? super View> viewMatcher) {
            void var1_1;
            this.viewMatcher = var1_1;
            return this;
        }

        public AmbiguousViewMatcherException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.view1);
            Preconditions.checkNotNull(this.view2);
            Preconditions.checkNotNull(this.others);
            AmbiguousViewMatcherException ambiguousViewMatcherException = new AmbiguousViewMatcherException(this, null);
            return ambiguousViewMatcherException;
        }
    }
}

