/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.internal.data;

import android.graphics.Rect;
import android.os.Looper;
import android.view.View;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.internal.data.model.ActionData;
import androidx.test.espresso.internal.data.model.ScreenData;
import androidx.test.espresso.internal.data.model.TestFlow;
import androidx.test.espresso.internal.data.model.ViewData;
import androidx.test.internal.platform.util.TestOutputEmitter;
import androidx.test.internal.util.Checks;
import androidx.test.platform.io.PlatformTestStorage;
import java.io.PrintStream;
import java.util.Locale;

public class TestFlowVisualizer {
    private static TestFlowVisualizer testFlowVisualizer;
    private static final String TEST_FLOW_ARG = "enable_testflow_gallery";
    private static final String LOG_TAG = "TestFlowVisualizer";
    private final TestFlow testFlow;
    private final PlatformTestStorage platformTestStorage;
    private int actionIndex;
    private Boolean enabled;

    public int getLastActionIndex() {
        return this.actionIndex;
    }

    public int getLastActionIndexAndIncrement() {
        int n = this.actionIndex++;
        return n;
    }

    private Rect adjustViewCoords(View view) {
        float[] fArray;
        Object object = GeneralLocation.TOP_LEFT.calculateCoordinates((View)fArray);
        fArray = GeneralLocation.BOTTOM_RIGHT.calculateCoordinates((View)fArray);
        fArray[1] = Math.min(fArray[1], 800.0f);
        Rect rect = new Rect((int)object[0], (int)object[1], (int)fArray[0], (int)fArray[1]);
        return rect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TestFlowVisualizer getInstance(PlatformTestStorage platformTestStorage) {
        TestFlowVisualizer testFlowVisualizer;
        PlatformTestStorage platformTestStorage2;
        if (TestFlowVisualizer.testFlowVisualizer != null) {
            if (TestFlowVisualizer.testFlowVisualizer.platformTestStorage != platformTestStorage2) {
                IllegalStateException illegalStateException = new IllegalStateException("getInstance called with different instance of PlatformTestStorage.");
                throw illegalStateException;
            }
            return TestFlowVisualizer.testFlowVisualizer;
        }
        TestFlowVisualizer.testFlowVisualizer = testFlowVisualizer = new TestFlowVisualizer(platformTestStorage2);
        return TestFlowVisualizer.testFlowVisualizer;
    }

    /*
     * WARNING - void declaration
     */
    TestFlowVisualizer(PlatformTestStorage testStorage) {
        void var1_1;
        TestFlow testFlow = new TestFlow();
        this((PlatformTestStorage)var1_1, testFlow);
    }

    /*
     * WARNING - void declaration
     */
    TestFlowVisualizer(PlatformTestStorage testStorage, TestFlow testFlow) {
        void var2_2;
        void var1_1;
        this.actionIndex = 0;
        this.platformTestStorage = (PlatformTestStorage)Checks.checkNotNull((Object)var1_1);
        this.testFlow = (TestFlow)Checks.checkNotNull((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void afterActionGenerateTestArtifact(int actionIndex) {
        void var1_1;
        Object object = new StringBuilder();
        TestOutputEmitter.takeScreenshot((String)((StringBuilder)object).append("screenshot-after-").append((int)var1_1).append(".png").toString());
    }

    /*
     * WARNING - void declaration
     */
    public void afterActionRecordData(ActionData actionData) {
        void var1_1;
        Thread thread = Thread.currentThread();
        Object object = Looper.getMainLooper();
        object = object.getThread();
        boolean bl = thread.equals(object);
        object = new Object[]{Thread.currentThread().getName()};
        Checks.checkState((boolean)bl, (String)"Method cannot be called off the main application thread (on: %s)", (Object[])object);
        Checks.checkNotNull((Object)var1_1, (Object)"Requires ActionData to store in graph.");
        Object object2 = this.testFlow;
        object2 = ((TestFlow)object2).getTail();
        object = new ScreenData();
        var1_1.source = object2;
        var1_1.dest = object;
        this.testFlow.addScreen((ScreenData)object, (ActionData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void beforeActionGenerateTestArtifact(int actionIndex) {
        void var1_1;
        Object object = new StringBuilder();
        TestOutputEmitter.takeScreenshot((String)((StringBuilder)object).append("screenshot-before-").append((int)var1_1).append(".png").toString());
    }

    /*
     * WARNING - void declaration
     */
    public void beforeActionRecordData(ActionData actionData, View view) {
        Object object;
        void var2_2;
        Rect rect;
        Thread thread = Thread.currentThread();
        Object object2 = Looper.getMainLooper();
        object2 = object2.getThread();
        boolean bl = thread.equals(object2);
        object2 = new Object[]{Thread.currentThread().getName()};
        Checks.checkState((boolean)bl, (String)"Method cannot be called off the main application thread (on: %s)", (Object[])object2);
        Checks.checkNotNull((Object)rect, (Object)"Requires actionData to store in graph.");
        Checks.checkNotNull((Object)var2_2, (Object)"Requires View to analyze.");
        if (rect.getIndex() == null) {
            object = new IllegalStateException("ActionData must have a distinguishing index.");
            throw object;
        }
        if (((TestFlowVisualizer)object).testFlow.getEdge(rect.getIndex()) != null) {
            object = new IllegalStateException("Currently appending to existing ActionData objects is not supported.");
            throw object;
        }
        rect = new Rect();
        var2_2.getGlobalVisibleRect(rect);
        ScreenData screenData = new ScreenData();
        object2 = new ViewData(var2_2.toString(), super.adjustViewCoords((View)var2_2), rect);
        screenData.addViewData((ViewData)object2);
        ((TestFlowVisualizer)object).testFlow.addScreen(screenData);
    }

    private void beginActionOutput(PrintStream writer) {
        writer.append("<div class=\"action\"><div style=\"position:relative; display:inline-block;\">");
    }

    /*
     * WARNING - void declaration
     */
    private void displayActionData(ActionData action, PrintStream writer) {
        void var2_2;
        Object[] objectArray;
        void var1_1;
        Object object;
        if (action.getName() != null) {
            object = Locale.getDefault();
            objectArray = new Object[]{var1_1.getName()};
            var2_2.append(String.format((Locale)object, "<p>Classname: %s</p>", objectArray));
        }
        if (var1_1.getDesc() != null) {
            object = Locale.getDefault();
            objectArray = new Object[]{var1_1.getDesc()};
            var2_2.append(String.format((Locale)object, "<p>Description: %s</p>", objectArray));
        }
        if (var1_1.getConstraints() != null) {
            object = Locale.getDefault();
            objectArray = new Object[]{var1_1.getConstraints().replace('<', '(').replace('>', ')')};
            var2_2.append(String.format((Locale)object, "<p>Constraints: %s</p>", objectArray));
        }
        var2_2.append("</div>");
    }

    /*
     * WARNING - void declaration
     */
    private void displayScreenshot(String pathname, PrintStream writer) {
        void var2_2;
        void var1_1;
        writer.append("<div style=\"width:480px; display: inline-block\">");
        Locale locale = Locale.ENGLISH;
        Object[] objectArray = new Object[]{var1_1};
        var2_2.append(String.format(locale, "<img src=\"./%s\" />\n", objectArray));
        var2_2.append("</div>");
    }

    /*
     * WARNING - void declaration
     */
    private void displayViewData(ViewData viewData, PrintStream writer) {
        void var2_7;
        Object[] objectArray;
        Object object = viewData.getViewBox();
        Rect rect = objectArray.getVisibleViewBox();
        int n = ((Rect)object).left;
        int n2 = ((Rect)object).right;
        int n3 = ((Rect)object).top;
        int n4 = ((Rect)object).bottom;
        Locale locale = Locale.ENGLISH;
        Object[] objectArray2 = new Object[]{rect.right - rect.left, rect.bottom - (rect.top + 3)};
        var2_7.append(String.format(locale, "<div style=\"border:3px solid rgba(255, 0, 0, .5); width:%d; height:%d", objectArray2));
        locale = Locale.ENGLISH;
        objectArray2 = new Object[]{rect.top + -3, rect.left + -3};
        var2_7.append(String.format(locale, "px; position:absolute; top:%dpx; left: %dpx; z-index:10;\"></div>", objectArray2));
        locale = Locale.ENGLISH;
        objectArray2 = new Object[]{n2 - n, n4 - (n3 + 3)};
        var2_7.append(String.format(locale, "<div style=\"border:3px solid rgba(0, 0, 255, .5); width:%s; height:%s", objectArray2));
        locale = Locale.ENGLISH;
        objectArray2 = new Object[]{n3 + -3, n + -3};
        var2_7.append(String.format(locale, "; position:absolute; top:%spx; left: %spx; z-index:9;\"></div>", objectArray2));
        var2_7.append("<div class=\"action-item\">");
        var2_7.append("<div style=\"border:3px solid rgba(255, 0, 0, .5);\">Visible View</div>");
        var2_7.append("<div style=\"border:3px solid rgba(0, 0, 255, .5);\">Actual View</div>");
        locale = Locale.ENGLISH;
        objectArray2 = new Object[]{objectArray.getDesc()};
        var2_7.append(String.format(locale, "<p>%s</p>", objectArray2));
        objectArray = new Object[]{object};
        var2_7.append(String.format("View: %s<br />", objectArray));
        object = Locale.ENGLISH;
        objectArray = new Object[1];
        rect.getClass();
        objectArray[0] = rect;
        var2_7.append(String.format((Locale)object, "<p>Visible portion: %s</p>", objectArray));
        int n5 = rect.bottom;
        int n6 = rect.top;
        float f = Math.min(((float)n5 - (float)n6) / (float)(n4 - n3), 1.0f);
        n6 = rect.right;
        int n7 = rect.left;
        float f2 = Math.min(((float)n6 - (float)n7) / (float)(n2 - n), 1.0f);
        f = Math.max(f * f2 * 100.0f, 0.0f);
        Locale locale2 = Locale.ENGLISH;
        Object[] objectArray3 = new Object[]{Float.valueOf(f)};
        var2_7.append(String.format(locale2, "This view is %s%% visible.", objectArray3));
    }

    private void endActionOutput(PrintStream writer) {
        writer.append("</div></div>");
    }

    /*
     * WARNING - void declaration
     */
    private void setStyling(PrintStream writer) {
        void var1_1;
        writer.append("<style>\n.action-item {\ndisplay:inline-block;\nwidth:450px;\n");
        var1_1.append("margin-left:10px;\nmargin-right:10px;\n}\n</style>");
    }

    /*
     * Exception decompiling
     */
    public void visualize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 21[TRYBLOCK] [23 : 549->551)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isEnabled() {
        if (this.enabled == null) {
            boolean bl = this.platformTestStorage.getInputArgs().containsKey(TEST_FLOW_ARG) && Boolean.parseBoolean(this.platformTestStorage.getInputArg(TEST_FLOW_ARG));
            this.enabled = bl;
        }
        return this.enabled;
    }
}

