/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class ImmediateFuture
implements ListenableFuture {
    static final ListenableFuture NULL;
    private static final Logger log;
    private final Object value;

    public Object get() {
        return this.value;
    }

    public Object get(long l, TimeUnit timeUnit) throws ExecutionException {
        Preconditions.checkNotNull((Object)timeUnit);
        return this.get();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(super.toString()).append("[status=SUCCESS, result=[").append(this.value).append("]]").toString();
    }

    static {
        ImmediateFuture immediateFuture = new ImmediateFuture(null);
        NULL = immediateFuture;
        log = Logger.getLogger(ImmediateFuture.class.getName());
    }

    ImmediateFuture(Object object) {
        this.value = object;
    }

    public void addListener(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            StringBuilder stringBuilder = new StringBuilder();
            logger.logp(level, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.ImmediateFuture", "addListener", stringBuilder.append("RuntimeException while executing runnable ").append(runnable).append(" with executor ").append(executor).toString(), runtimeException);
            return;
        }
    }

    public boolean cancel(boolean bl) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    static final class ImmediateFailedFuture
    extends AbstractFuture.TrustedFuture {
        ImmediateFailedFuture(Throwable throwable) {
            this.setException(throwable);
        }
    }
}

