/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;

final class RegularImmutableSet
extends ImmutableSet {
    private static final Object[] EMPTY_ARRAY;
    static final RegularImmutableSet EMPTY;
    final transient Object[] elements;
    private final transient int hashCode;
    final transient Object[] table;
    private final transient int mask;
    private final transient int size;

    @Override
    int copyIntoArray(Object[] objectArray, int n) {
        System.arraycopy(this.elements, 0, objectArray, n, this.size);
        return n + this.size;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    int internalArrayEnd() {
        return this.size;
    }

    @Override
    int internalArrayStart() {
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    ImmutableList createAsList() {
        return ImmutableList.asImmutableList(this.elements, this.size);
    }

    @Override
    public UnmodifiableIterator iterator() {
        return this.asList().iterator();
    }

    static {
        RegularImmutableSet regularImmutableSet;
        EMPTY_ARRAY = new Object[0];
        EMPTY = regularImmutableSet = new RegularImmutableSet(EMPTY_ARRAY, 0, EMPTY_ARRAY, 0, 0);
    }

    RegularImmutableSet(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        this.elements = objectArray;
        this.hashCode = n;
        this.table = objectArray2;
        this.mask = n2;
        this.size = n3;
    }

    @Override
    public boolean contains(Object object) {
        Object[] objectArray = this.table;
        if (object == null || objectArray.length == 0) {
            return false;
        }
        int n = Hashing.smearedHash(object);
        Object object2;
        while ((object2 = objectArray[n &= this.mask]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    Object[] internalArray() {
        return this.elements;
    }
}

