/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Range;
import androidx.test.espresso.core.internal.deps.guava.primitives.Booleans;
import java.io.Serializable;

abstract class Cut
implements Comparable,
Serializable {
    private static final long serialVersionUID = 0L;
    final Comparable endpoint;

    public int compareTo(Cut cut) {
        if (cut == Cut.belowAll()) {
            return 1;
        }
        if (cut == Cut.aboveAll()) {
            return -1;
        }
        int n = Range.compareOrThrow(this.endpoint, cut.endpoint);
        if (n != 0) {
            return n;
        }
        return Booleans.compare(this instanceof AboveValue, cut instanceof AboveValue);
    }

    public abstract int hashCode();

    static Cut aboveAll() {
        return AboveAll.INSTANCE;
    }

    static Cut aboveValue(Comparable comparable) {
        AboveValue aboveValue = new AboveValue(comparable);
        return aboveValue;
    }

    static Cut belowAll() {
        return BelowAll.INSTANCE;
    }

    static Cut belowValue(Comparable comparable) {
        BelowValue belowValue = new BelowValue(comparable);
        return belowValue;
    }

    Cut(Comparable comparable) {
        this.endpoint = comparable;
    }

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Cut cut;
        if (!(cut instanceof Cut)) return false;
        cut = cut;
        try {
            void var0_3;
            int n = this.compareTo(cut);
            if (n != 0) return (boolean)var0_3;
            return (boolean)var0_3;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    abstract boolean isLessThan(Comparable var1);

    private static final class AboveValue
    extends Cut {
        private static final long serialVersionUID = 0L;

        @Override
        public int hashCode() {
            return ~this.endpoint.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append("/").append(this.endpoint).append("\\").toString();
        }

        AboveValue(Comparable comparable) {
            super((Comparable)Preconditions.checkNotNull(comparable));
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            stringBuilder.append('(').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            stringBuilder.append(this.endpoint).append(']');
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean isLessThan(Comparable comparable) {
            if (Range.compareOrThrow(this.endpoint, comparable) >= 0) return false;
            return true;
        }
    }

    private static final class BelowAll
    extends Cut {
        private static final BelowAll INSTANCE;
        private static final long serialVersionUID = 0L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(Cut cut) {
            if (cut != this) return -1;
            return 0;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "-\u221e";
        }

        static {
            BelowAll belowAll;
            INSTANCE = belowAll = new BelowAll();
        }

        private BelowAll() {
            super((Comparable)((Object)""));
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            stringBuilder.append("(-\u221e");
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            Object object = new AssertionError();
            throw object;
        }

        @Override
        boolean isLessThan(Comparable comparable) {
            return true;
        }
    }

    private static final class AboveAll
    extends Cut {
        private static final AboveAll INSTANCE;
        private static final long serialVersionUID = 0L;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(Cut cut) {
            if (cut != this) return 1;
            return 0;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "+\u221e";
        }

        static {
            AboveAll aboveAll;
            INSTANCE = aboveAll = new AboveAll();
        }

        private AboveAll() {
            super((Comparable)((Object)""));
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            Object object = new AssertionError();
            throw object;
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            stringBuilder.append("+\u221e)");
        }

        @Override
        boolean isLessThan(Comparable comparable) {
            return false;
        }
    }

    private static final class BelowValue
    extends Cut {
        private static final long serialVersionUID = 0L;

        @Override
        public int hashCode() {
            return this.endpoint.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append("\\").append(this.endpoint).append("/").toString();
        }

        BelowValue(Comparable comparable) {
            super((Comparable)Preconditions.checkNotNull(comparable));
        }

        @Override
        void describeAsLowerBound(StringBuilder stringBuilder) {
            stringBuilder.append('[').append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder stringBuilder) {
            stringBuilder.append(this.endpoint).append(')');
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean isLessThan(Comparable comparable) {
            if (Range.compareOrThrow(this.endpoint, comparable) > 0) return false;
            return true;
        }
    }
}

