/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.PatternCompiler;
import java.util.Locale;
import java.util.logging.Logger;

final class Platform {
    private static final Logger logger = Logger.getLogger(Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    static long systemNanoTime() {
        return System.nanoTime();
    }

    private static PatternCompiler loadPatternCompiler() {
        JdkPatternCompiler jdkPatternCompiler = new JdkPatternCompiler();
        return jdkPatternCompiler;
    }

    static String emptyToNull(String string) {
        if (Platform.stringIsNullOrEmpty(string)) {
            return null;
        }
        return string;
    }

    static String formatCompact4Digits(double d) {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{d};
        return String.format(locale, "%.4g", objectArray);
    }

    static String nullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private Platform() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean stringIsNullOrEmpty(String string) {
        if (string == null) return true;
        if (!string.isEmpty()) return false;
        return true;
    }

    private static final class JdkPatternCompiler
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }
    }
}

