/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Looper;
import android.view.View;
import android.widget.AdapterView;
import androidx.test.espresso.AmbiguousViewMatcherException;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewFinder;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Predicate;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.TreeIterables;
import java.util.List;
import java.util.Locale;
import javax.inject.Provider;
import org.hamcrest.Matcher;

public final class ViewFinderImpl
implements ViewFinder {
    private final Matcher<View> viewMatcher;
    private final Provider<View> rootViewProvider;

    @Override
    public View getView() throws AmbiguousViewMatcherException, NoMatchingViewException {
        this.checkMainThread();
        Object object = new MatcherPredicateAdapter((Matcher)Preconditions.checkNotNull(this.viewMatcher));
        View view = (View)this.rootViewProvider.get();
        Object object2 = Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), object).iterator();
        object = null;
        while (object2.hasNext()) {
            if (object != null) {
                AmbiguousViewMatcherException.Builder builder = new AmbiguousViewMatcherException.Builder();
                throw builder.withViewMatcher(this.viewMatcher).withRootView(view).withView1((View)object).withView2(object2.next()).withOtherAmbiguousViews((View[])Iterators.toArray(object2, View.class)).build();
            }
            object = object2.next();
        }
        if (object == null) {
            object = new MatcherPredicateAdapter(ViewMatchers.isAssignableFrom(AdapterView.class));
            object = Lists.newArrayList(Iterables.filter(TreeIterables.breadthFirstViewTraversal(view), object).iterator());
            if (object.isEmpty()) {
                object = new NoMatchingViewException.Builder();
                throw ((NoMatchingViewException.Builder)object).withViewMatcher(this.viewMatcher).withRootView(view).build();
            }
            object2 = Locale.ROOT;
            Object object3 = new Object[]{Joiner.on("\n- ").join((Iterable)object)};
            object2 = String.format((Locale)object2, "\nIf the target view is not part of the view hierarchy, you may need to use Espresso.onData to load it from one of the following AdapterViews:%s", (Object[])object3);
            object3 = new NoMatchingViewException.Builder();
            throw ((NoMatchingViewException.Builder)object3).withViewMatcher(this.viewMatcher).withRootView(view).withAdapterViews((List<View>)object).withAdapterViewWarning(EspressoOptional.of(object2)).build();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    ViewFinderImpl(Matcher<View> viewMatcher, Provider<View> rootViewProvider) {
        void var2_2;
        void var1_1;
        this.viewMatcher = var1_1;
        this.rootViewProvider = var2_2;
    }

    private void checkMainThread() {
        Preconditions.checkState(Thread.currentThread().equals(Looper.getMainLooper().getThread()), "Executing a query on the view hierarchy outside of the main thread (on: %s)", Thread.currentThread().getName());
    }

    private static class MatcherPredicateAdapter<T>
    implements Predicate<T> {
        private final Matcher<? super T> matcher;

        /*
         * WARNING - void declaration
         */
        private MatcherPredicateAdapter(Matcher<? super T> matcher) {
            void var1_1;
            this.matcher = (Matcher)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean apply(T input) {
            void var1_1;
            return this.matcher.matches((Object)var1_1);
        }
    }
}

