/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.base.DefaultFailureHandler;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import org.hamcrest.Matcher;

class PerformExceptionHandler
extends DefaultFailureHandler.TypedFailureHandler<PerformException> {
    private final Context appContext;

    private static float getAnimatorDurationScale(ContentResolver resolver) {
        if (PerformExceptionHandler.isJellyBeanMR1OrHigher()) {
            ContentResolver contentResolver;
            return PerformExceptionHandler.getSetting(contentResolver, "animator_duration_scale", "animator_duration_scale");
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private static float getGlobalSetting(ContentResolver resolver, String setting) {
        try {
            void var1_2;
            float f = Settings.Global.getFloat((ContentResolver)resolver, (String)var1_2);
            return f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float getSetting(ContentResolver resolver, String current, String deprecated) {
        void var2_2;
        ContentResolver contentResolver;
        if (PerformExceptionHandler.isJellyBeanMR1OrHigher()) {
            void var1_1;
            return PerformExceptionHandler.getGlobalSetting(contentResolver, (String)var1_1);
        }
        return PerformExceptionHandler.getSystemSetting(contentResolver, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static float getSystemSetting(ContentResolver resolver, String setting) {
        try {
            void var1_2;
            float f = Settings.System.getFloat((ContentResolver)resolver, (String)var1_2);
            return f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    private static float getTransitionAnimationScale(ContentResolver resolver) {
        return PerformExceptionHandler.getSetting(resolver, "transition_animation_scale", "transition_animation_scale");
    }

    private static float getWindowAnimationScale(ContentResolver resolver) {
        return PerformExceptionHandler.getSetting(resolver, "window_animation_scale", "window_animation_scale");
    }

    /*
     * WARNING - void declaration
     */
    public PerformExceptionHandler(Context appContext, Class<PerformException> expectedType) {
        void var1_1;
        void var2_2;
        Class[] classArray = new Class[]{var2_2};
        super(classArray);
        this.appContext = (Context)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void handleSafely(PerformException error, Matcher<View> viewMatcher) {
        void var1_1;
        void var2_2;
        StringBuilder stringBuilder = new StringBuilder();
        if (!PerformExceptionHandler.isAnimationAndTransitionDisabled(((PerformExceptionHandler)object).appContext)) {
            stringBuilder.append("Animations or transitions are enabled on the target device.\nFor more info check: https://developer.android.com/training/testing/espresso/setup#set-up-environment\n\n");
        }
        stringBuilder.append(var2_2);
        Object object = new PerformException.Builder();
        throw ((PerformException.Builder)object).from((PerformException)var1_1).withViewDescription(stringBuilder.toString()).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAnimationAndTransitionDisabled(Context context) {
        Context context2 = context.getContentResolver();
        float f = PerformExceptionHandler.getTransitionAnimationScale((ContentResolver)context2);
        boolean bl = PerformExceptionHandler.isEqualToZero(f);
        boolean bl2 = PerformExceptionHandler.isEqualToZero(PerformExceptionHandler.getWindowAnimationScale((ContentResolver)context2));
        boolean bl3 = PerformExceptionHandler.isEqualToZero(PerformExceptionHandler.getAnimatorDurationScale((ContentResolver)context2));
        if (!bl) return false;
        if (!bl2) return false;
        if (!bl3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEqualToZero(float value) {
        if (Float.compare(Math.abs(value), 0.0f) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isJellyBeanMR1OrHigher() {
        if (Build.VERSION.SDK_INT < 17) return false;
        return true;
    }
}

