/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.SearchView;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class TypeTextAction
implements ViewAction {
    private static final String TAG = TypeTextAction.class.getSimpleName();
    @RemoteMsgField(order=0)
    final String stringToBeTyped;
    @RemoteMsgField(order=1)
    final boolean tapToFocus;
    final GeneralClickAction clickAction;

    private static GeneralClickAction defaultClickAction() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return generalClickAction;
    }

    @Override
    public String getDescription() {
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{this.stringToBeTyped};
        return String.format(locale, "type text(%s)", objectArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Matcher<View> getConstraints() {
        Matcher matcher = new Matcher[]{ViewMatchers.isDisplayed()};
        matcher = Matchers.allOf((Matcher[])matcher);
        TypeTextAction typeTextAction = !typeTextAction.tapToFocus ? Matchers.allOf((Matcher)matcher, ViewMatchers.hasFocus()) : matcher;
        if (Build.VERSION.SDK_INT < 11) {
            return Matchers.allOf((Matcher)typeTextAction, ViewMatchers.supportsInputMethods());
        }
        return Matchers.allOf((Matcher)typeTextAction, (Matcher)Matchers.anyOf(ViewMatchers.supportsInputMethods(), ViewMatchers.isAssignableFrom(SearchView.class)));
    }

    /*
     * WARNING - void declaration
     */
    public TypeTextAction(String stringToBeTyped) {
        this((String)var1_1, true, TypeTextAction.defaultClickAction());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @RemoteMsgConstructor
    public TypeTextAction(String stringToBeTyped, boolean tapToFocus) {
        this((String)var1_1, (boolean)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TypeTextAction(String stringToBeTyped, boolean tapToFocus, GeneralClickAction clickAction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(var1_1);
        this.stringToBeTyped = var1_1;
        this.tapToFocus = var2_2;
        this.clickAction = var3_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController uiController, View view) {
        void var2_5;
        void var1_1;
        if (this.stringToBeTyped.length() == 0) {
            Log.w((String)TAG, (String)"Supplied string is empty resulting in no-op (nothing is typed).");
            return;
        }
        if (this.tapToFocus) {
            if (this.clickAction == null) {
                TypeTextAction.defaultClickAction().perform((UiController)var1_1, (View)var2_5);
            } else {
                this.clickAction.perform((UiController)var1_1, (View)var2_5);
            }
            var1_1.loopMainThreadUntilIdle();
        }
        try {
            boolean bl = var1_1.injectString(this.stringToBeTyped);
            if (!bl) {
                Object object = TAG;
                Object object2 = this.stringToBeTyped;
                StringBuilder stringBuilder = new StringBuilder();
                Log.e((String)object, (String)stringBuilder.append("Failed to type text: ").append((String)object2).toString());
                object = new PerformException.Builder();
                object = ((PerformException.Builder)object).withActionDescription(this.getDescription());
                object2 = HumanReadables.describe((View)var2_5);
                object = ((PerformException.Builder)object).withViewDescription((String)object2);
                String string = this.stringToBeTyped;
                StringBuilder stringBuilder2 = new StringBuilder();
                object2 = new RuntimeException(stringBuilder2.append("Failed to type text: ").append(string).toString());
                throw ((PerformException.Builder)object).withCause((Throwable)object2).build();
            }
            return;
        }
        catch (InjectEventSecurityException injectEventSecurityException) {
            Object object = TAG;
            String string = this.stringToBeTyped;
            StringBuilder stringBuilder = new StringBuilder();
            Log.e((String)object, (String)stringBuilder.append("Failed to type text: ").append(string).toString());
            object = new PerformException.Builder();
            throw ((PerformException.Builder)object).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)var2_5)).withCause((Throwable)((Object)injectEventSecurityException)).build();
        }
    }
}

