/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.NoMatchingViewException-IA;
import androidx.test.espresso.RootViewException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NoMatchingViewException
extends RuntimeException
implements RootViewException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private List<View> adapterViews = Lists.newArrayList();
    private boolean includeViewHierarchy = true;
    private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();

    @Override
    public View getRootView() {
        return this.rootView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getErrorMessage(Builder builder) {
        String string;
        if (builder.includeViewHierarchy) {
            Object object = Locale.ROOT;
            Object object2 = new Object[]{((Builder)((Object)string)).viewMatcher};
            object = String.format((Locale)object, "No views in hierarchy found matching: %s", (Object[])object2);
            if (((Builder)((Object)string)).adapterViewWarning.isPresent()) {
                object2 = ((Builder)((Object)string)).adapterViewWarning;
                object2 = ((EspressoOptional)object2).get();
                object2 = (String)object2;
                StringBuilder stringBuilder = new StringBuilder();
                object = stringBuilder.append((String)object).append((String)object2).toString();
            }
            object = HumanReadables.getViewHierarchyErrorMessage(((Builder)((Object)string)).rootView, null, (String)object, null, ((Builder)((Object)string)).maxMsgLen);
            if (((Builder)((Object)string)).viewHierarchyFile == null) return object;
            object2 = new Object[]{((Builder)((Object)string)).viewHierarchyFile};
            string = String.format("\nThe complete view hierarchy is available in artifact file '%s'.", (Object[])object2);
            object2 = new StringBuilder();
            return ((StringBuilder)object2).append((String)object).append(string).toString();
        }
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((Builder)((Object)string)).viewMatcher};
        return String.format(locale, "Could not find a view that matches %s", objectArray);
    }

    public String getViewMatcherDescription() {
        if (this.viewMatcher != null) {
            return this.viewMatcher.toString();
        }
        return "unknown";
    }

    /*
     * WARNING - void declaration
     */
    private NoMatchingViewException(Builder builder) {
        super(NoMatchingViewException.getErrorMessage((Builder)var1_1), ((Builder)var1_1).cause);
        void var1_1;
        this.viewMatcher = ((Builder)var1_1).viewMatcher;
        this.rootView = ((Builder)var1_1).rootView;
        this.adapterViews = ((Builder)var1_1).adapterViews;
        this.adapterViewWarning = ((Builder)var1_1).adapterViewWarning;
        this.includeViewHierarchy = ((Builder)var1_1).includeViewHierarchy;
    }

    /*
     * WARNING - void declaration
     */
    private NoMatchingViewException(String description) {
        super((String)var1_1);
        void var1_1;
    }

    /* synthetic */ NoMatchingViewException(Builder builder, NoMatchingViewException-IA noMatchingViewException-IA) {
        this(builder);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private List<View> adapterViews = Lists.newArrayList();
        private boolean includeViewHierarchy = true;
        private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();
        private Throwable cause;
        private int maxMsgLen = Integer.MAX_VALUE;
        private String viewHierarchyFile = null;

        /*
         * WARNING - void declaration
         */
        public Builder from(NoMatchingViewException exception) {
            void var1_1;
            this.viewMatcher = ((NoMatchingViewException)var1_1).viewMatcher;
            this.rootView = ((NoMatchingViewException)var1_1).rootView;
            this.adapterViews = ((NoMatchingViewException)var1_1).adapterViews;
            this.adapterViewWarning = ((NoMatchingViewException)var1_1).adapterViewWarning;
            this.includeViewHierarchy = ((NoMatchingViewException)var1_1).includeViewHierarchy;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder includeViewHierarchy(boolean includeViewHierarchy) {
            void var1_1;
            this.includeViewHierarchy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withAdapterViewWarning(EspressoOptional<String> adapterViewWarning) {
            void var1_1;
            this.adapterViewWarning = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withAdapterViews(List<View> adapterViews) {
            void var1_1;
            this.adapterViews = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withCause(Throwable cause) {
            void var1_1;
            this.cause = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withMaxMsgLen(int maxMsgLen) {
            void var1_1;
            this.maxMsgLen = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withRootView(View rootView) {
            void var1_1;
            this.rootView = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewHierarchyFile(String viewHierarchyFile) {
            void var1_1;
            this.viewHierarchyFile = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewMatcher(Matcher<? super View> viewMatcher) {
            void var1_1;
            this.viewMatcher = var1_1;
            return this;
        }

        public NoMatchingViewException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.adapterViews);
            Preconditions.checkNotNull(this.adapterViewWarning);
            NoMatchingViewException noMatchingViewException = new NoMatchingViewException(this, null);
            return noMatchingViewException;
        }
    }
}

