/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.webkit.WebView;
import android.widget.Checkable;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import androidx.test.annotation.Beta;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.matcher.BoundedDiagnosingMatcher;
import androidx.test.espresso.matcher.HasBackgroundMatcher;
import androidx.test.espresso.matcher.ViewMatchers$HasDescendantMatcher$$Lambda$0;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.espresso.util.TreeIterables;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class ViewMatchers {
    private static final Pattern RESOURCE_ID_PATTERN = Pattern.compile("\\d+");

    private ViewMatchers() {
    }

    public static org.hamcrest.Matcher<View> isAssignableFrom(Class<? extends View> clazz) {
        Class<? extends View> clazz2;
        IsAssignableFromMatcher isAssignableFromMatcher = new IsAssignableFromMatcher(clazz2);
        return isAssignableFromMatcher;
    }

    public static org.hamcrest.Matcher<View> withClassName(org.hamcrest.Matcher<String> classNameMatcher) {
        org.hamcrest.Matcher<String> matcher;
        WithClassNameMatcher withClassNameMatcher = new WithClassNameMatcher(Preconditions.checkNotNull(matcher));
        return withClassNameMatcher;
    }

    public static org.hamcrest.Matcher<View> isDisplayed() {
        IsDisplayedMatcher isDisplayedMatcher = new IsDisplayedMatcher();
        return isDisplayedMatcher;
    }

    public static org.hamcrest.Matcher<View> isCompletelyDisplayed() {
        return ViewMatchers.isDisplayingAtLeast(100);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static org.hamcrest.Matcher<View> isDisplayingAtLeast(int areaPercentage) {
        int n;
        boolean bl = areaPercentage <= 100;
        Preconditions.checkArgument(bl, "Cannot have over 100 percent: %s", n);
        bl = n > 0;
        Preconditions.checkArgument(bl, "Must have a positive, non-zero value: %s", n);
        return new IsDisplayingAtLeastMatcher(n);
    }

    public static org.hamcrest.Matcher<View> isEnabled() {
        IsEnabledMatcher isEnabledMatcher = new IsEnabledMatcher(true);
        return isEnabledMatcher;
    }

    public static org.hamcrest.Matcher<View> isNotEnabled() {
        IsEnabledMatcher isEnabledMatcher = new IsEnabledMatcher(false);
        return isEnabledMatcher;
    }

    public static org.hamcrest.Matcher<View> isFocusable() {
        IsFocusableMatcher isFocusableMatcher = new IsFocusableMatcher(true);
        return isFocusableMatcher;
    }

    public static org.hamcrest.Matcher<View> isNotFocusable() {
        IsFocusableMatcher isFocusableMatcher = new IsFocusableMatcher(false);
        return isFocusableMatcher;
    }

    public static org.hamcrest.Matcher<View> isFocused() {
        IsFocusedMatcher isFocusedMatcher = new IsFocusedMatcher(true);
        return isFocusedMatcher;
    }

    public static org.hamcrest.Matcher<View> isNotFocused() {
        IsFocusedMatcher isFocusedMatcher = new IsFocusedMatcher(false);
        return isFocusedMatcher;
    }

    public static org.hamcrest.Matcher<View> hasFocus() {
        HasFocusMatcher hasFocusMatcher = new HasFocusMatcher(true);
        return hasFocusMatcher;
    }

    public static org.hamcrest.Matcher<View> doesNotHaveFocus() {
        HasFocusMatcher hasFocusMatcher = new HasFocusMatcher(false);
        return hasFocusMatcher;
    }

    public static org.hamcrest.Matcher<View> isSelected() {
        IsSelectedMatcher isSelectedMatcher = new IsSelectedMatcher(true);
        return isSelectedMatcher;
    }

    public static org.hamcrest.Matcher<View> isNotSelected() {
        IsSelectedMatcher isSelectedMatcher = new IsSelectedMatcher(false);
        return isSelectedMatcher;
    }

    public static org.hamcrest.Matcher<View> hasSibling(org.hamcrest.Matcher<View> siblingMatcher) {
        org.hamcrest.Matcher<View> matcher;
        HasSiblingMatcher hasSiblingMatcher = new HasSiblingMatcher(Preconditions.checkNotNull(matcher));
        return hasSiblingMatcher;
    }

    public static org.hamcrest.Matcher<View> withContentDescription(int resourceId) {
        int n;
        WithContentDescriptionFromIdMatcher withContentDescriptionFromIdMatcher = new WithContentDescriptionFromIdMatcher(n);
        return withContentDescriptionFromIdMatcher;
    }

    public static org.hamcrest.Matcher<View> withContentDescription(String text) {
        String string;
        WithContentDescriptionTextMatcher withContentDescriptionTextMatcher = new WithContentDescriptionTextMatcher(Matchers.is((Object)string));
        return withContentDescriptionTextMatcher;
    }

    public static org.hamcrest.Matcher<View> withContentDescription(org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher) {
        org.hamcrest.Matcher<? extends CharSequence> matcher;
        WithContentDescriptionMatcher withContentDescriptionMatcher = new WithContentDescriptionMatcher(Preconditions.checkNotNull(matcher));
        return withContentDescriptionMatcher;
    }

    public static org.hamcrest.Matcher<View> withId(int id) {
        return ViewMatchers.withId((org.hamcrest.Matcher<Integer>)Matchers.is((Object)id));
    }

    public static org.hamcrest.Matcher<View> withId(org.hamcrest.Matcher<Integer> integerMatcher) {
        org.hamcrest.Matcher<Integer> matcher;
        WithIdMatcher withIdMatcher = new WithIdMatcher(Preconditions.checkNotNull(matcher));
        return withIdMatcher;
    }

    public static org.hamcrest.Matcher<View> withResourceName(String name) {
        return ViewMatchers.withResourceName((org.hamcrest.Matcher<String>)Matchers.is((Object)name));
    }

    public static org.hamcrest.Matcher<View> withResourceName(org.hamcrest.Matcher<String> stringMatcher) {
        org.hamcrest.Matcher<String> matcher;
        WithResourceNameMatcher withResourceNameMatcher = new WithResourceNameMatcher(Preconditions.checkNotNull(matcher));
        return withResourceNameMatcher;
    }

    public static org.hamcrest.Matcher<View> withTagKey(int key) {
        return ViewMatchers.withTagKey(key, Matchers.notNullValue());
    }

    /*
     * WARNING - void declaration
     */
    public static org.hamcrest.Matcher<View> withTagKey(int key, org.hamcrest.Matcher<?> objectMatcher) {
        void var1_1;
        int n;
        WithTagKeyMatcher withTagKeyMatcher = new WithTagKeyMatcher(n, (org.hamcrest.Matcher)Preconditions.checkNotNull(var1_1));
        return withTagKeyMatcher;
    }

    public static org.hamcrest.Matcher<View> withTagValue(org.hamcrest.Matcher<Object> tagValueMatcher) {
        org.hamcrest.Matcher<Object> matcher;
        WithTagValueMatcher withTagValueMatcher = new WithTagValueMatcher(Preconditions.checkNotNull(matcher));
        return withTagValueMatcher;
    }

    public static org.hamcrest.Matcher<View> withText(String text) {
        return ViewMatchers.withText((org.hamcrest.Matcher<String>)Matchers.is((Object)text));
    }

    public static org.hamcrest.Matcher<View> withText(org.hamcrest.Matcher<String> stringMatcher) {
        org.hamcrest.Matcher<String> matcher;
        WithTextMatcher withTextMatcher = new WithTextMatcher(Preconditions.checkNotNull(matcher));
        return withTextMatcher;
    }

    public static org.hamcrest.Matcher<View> withText(int resourceId) {
        int n;
        WithCharSequenceMatcher withCharSequenceMatcher = new WithCharSequenceMatcher(n, WithCharSequenceMatcher.TextViewMethod.GET_TEXT);
        return withCharSequenceMatcher;
    }

    public static org.hamcrest.Matcher<View> withSubstring(String substring) {
        return ViewMatchers.withText((org.hamcrest.Matcher<String>)Matchers.containsString((String)substring));
    }

    public static org.hamcrest.Matcher<View> withHint(String hintText) {
        return ViewMatchers.withHint((org.hamcrest.Matcher<String>)Matchers.is((Object)Preconditions.checkNotNull(hintText)));
    }

    public static org.hamcrest.Matcher<View> withHint(org.hamcrest.Matcher<String> stringMatcher) {
        org.hamcrest.Matcher<String> matcher;
        WithHintMatcher withHintMatcher = new WithHintMatcher(Preconditions.checkNotNull(matcher));
        return withHintMatcher;
    }

    public static org.hamcrest.Matcher<View> withHint(int resourceId) {
        int n;
        WithCharSequenceMatcher withCharSequenceMatcher = new WithCharSequenceMatcher(n, WithCharSequenceMatcher.TextViewMethod.GET_HINT);
        return withCharSequenceMatcher;
    }

    public static org.hamcrest.Matcher<View> isChecked() {
        return ViewMatchers.withCheckBoxState((org.hamcrest.Matcher<Boolean>)Matchers.is((Object)true));
    }

    public static org.hamcrest.Matcher<View> isNotChecked() {
        return ViewMatchers.withCheckBoxState((org.hamcrest.Matcher<Boolean>)Matchers.is((Object)false));
    }

    private static <E extends View> org.hamcrest.Matcher<View> withCheckBoxState(org.hamcrest.Matcher<Boolean> checkStateMatcher) {
        org.hamcrest.Matcher<Boolean> matcher;
        WithCheckBoxStateMatcher withCheckBoxStateMatcher = new WithCheckBoxStateMatcher(matcher);
        return withCheckBoxStateMatcher;
    }

    public static org.hamcrest.Matcher<View> hasContentDescription() {
        HasContentDescriptionMatcher hasContentDescriptionMatcher = new HasContentDescriptionMatcher();
        return hasContentDescriptionMatcher;
    }

    public static org.hamcrest.Matcher<View> hasDescendant(org.hamcrest.Matcher<View> descendantMatcher) {
        org.hamcrest.Matcher<View> matcher;
        HasDescendantMatcher hasDescendantMatcher = new HasDescendantMatcher(Preconditions.checkNotNull(matcher));
        return hasDescendantMatcher;
    }

    public static org.hamcrest.Matcher<View> isClickable() {
        IsClickableMatcher isClickableMatcher = new IsClickableMatcher(true);
        return isClickableMatcher;
    }

    public static org.hamcrest.Matcher<View> isNotClickable() {
        IsClickableMatcher isClickableMatcher = new IsClickableMatcher(false);
        return isClickableMatcher;
    }

    public static org.hamcrest.Matcher<View> isDescendantOfA(org.hamcrest.Matcher<View> ancestorMatcher) {
        org.hamcrest.Matcher<View> matcher;
        IsDescendantOfAMatcher isDescendantOfAMatcher = new IsDescendantOfAMatcher(Preconditions.checkNotNull(matcher));
        return isDescendantOfAMatcher;
    }

    public static org.hamcrest.Matcher<View> withEffectiveVisibility(Visibility visibility) {
        Visibility visibility2;
        WithEffectiveVisibilityMatcher withEffectiveVisibilityMatcher = new WithEffectiveVisibilityMatcher(visibility2);
        return withEffectiveVisibilityMatcher;
    }

    public static org.hamcrest.Matcher<View> withAlpha(float alpha) {
        float f;
        WithAlphaMatcher withAlphaMatcher = new WithAlphaMatcher(f);
        return withAlphaMatcher;
    }

    public static org.hamcrest.Matcher<View> withParent(org.hamcrest.Matcher<View> parentMatcher) {
        org.hamcrest.Matcher<View> matcher;
        WithParentMatcher withParentMatcher = new WithParentMatcher(Preconditions.checkNotNull(matcher));
        return withParentMatcher;
    }

    public static org.hamcrest.Matcher<View> withChild(org.hamcrest.Matcher<View> childMatcher) {
        org.hamcrest.Matcher<View> matcher;
        WithChildMatcher withChildMatcher = new WithChildMatcher(Preconditions.checkNotNull(matcher));
        return withChildMatcher;
    }

    public static org.hamcrest.Matcher<View> hasChildCount(int childCount) {
        int n;
        HasChildCountMatcher hasChildCountMatcher = new HasChildCountMatcher(n);
        return hasChildCountMatcher;
    }

    public static org.hamcrest.Matcher<View> hasMinimumChildCount(int minChildCount) {
        int n;
        HasMinimumChildCountMatcher hasMinimumChildCountMatcher = new HasMinimumChildCountMatcher(n);
        return hasMinimumChildCountMatcher;
    }

    public static org.hamcrest.Matcher<View> isRoot() {
        IsRootMatcher isRootMatcher = new IsRootMatcher();
        return isRootMatcher;
    }

    public static org.hamcrest.Matcher<View> supportsInputMethods() {
        SupportsInputMethodsMatcher supportsInputMethodsMatcher = new SupportsInputMethodsMatcher();
        return supportsInputMethodsMatcher;
    }

    public static org.hamcrest.Matcher<View> hasImeAction(int imeAction) {
        return ViewMatchers.hasImeAction((org.hamcrest.Matcher<Integer>)Matchers.is((Object)imeAction));
    }

    public static org.hamcrest.Matcher<View> hasImeAction(org.hamcrest.Matcher<Integer> imeActionMatcher) {
        org.hamcrest.Matcher<Integer> matcher;
        HasImeActionMatcher hasImeActionMatcher = new HasImeActionMatcher(matcher);
        return hasImeActionMatcher;
    }

    public static org.hamcrest.Matcher<View> hasLinks() {
        HasLinksMatcher hasLinksMatcher = new HasLinksMatcher();
        return hasLinksMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void assertThat(T actual, org.hamcrest.Matcher<T> matcher) {
        void var1_1;
        T t;
        ViewMatchers.assertThat("", t, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void assertThat(String message, T actual, org.hamcrest.Matcher<T> matcher) {
        void var1_1;
        if (!matcher.matches((Object)var1_1)) {
            String string;
            void var2_2;
            StringDescription stringDescription = new StringDescription();
            String string2 = ViewMatchers.getMismatchDescriptionString(var1_1, var2_2);
            stringDescription.appendText(string).appendText("\nExpected: ").appendDescriptionOf((SelfDescribing)var2_2).appendText("\n     Got: ").appendText(string2);
            if (var1_1 instanceof View) {
                stringDescription.appendText("\nView Details: ").appendText(HumanReadables.describe((View)var1_1));
            }
            stringDescription.appendText("\n");
            string = new AssertionFailedError(stringDescription.toString());
            throw string;
        }
    }

    private static <T> String getMismatchDescriptionString(T actual, org.hamcrest.Matcher<T> matcher) {
        T t;
        String string;
        StringDescription stringDescription = new StringDescription();
        string.describeMismatch(t, (Description)stringDescription);
        string = stringDescription.toString().trim();
        if (string.isEmpty()) {
            return t.toString();
        }
        return string;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(int resourceId) {
        int n;
        WithSpinnerTextIdMatcher withSpinnerTextIdMatcher = new WithSpinnerTextIdMatcher(n);
        return withSpinnerTextIdMatcher;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(org.hamcrest.Matcher<String> stringMatcher) {
        org.hamcrest.Matcher<String> matcher;
        WithSpinnerTextMatcher withSpinnerTextMatcher = new WithSpinnerTextMatcher(Preconditions.checkNotNull(matcher));
        return withSpinnerTextMatcher;
    }

    public static org.hamcrest.Matcher<View> withSpinnerText(String text) {
        return ViewMatchers.withSpinnerText((org.hamcrest.Matcher<String>)Matchers.is((Object)text));
    }

    public static org.hamcrest.Matcher<View> isJavascriptEnabled() {
        IsJavascriptEnabledMatcher isJavascriptEnabledMatcher = new IsJavascriptEnabledMatcher();
        return isJavascriptEnabledMatcher;
    }

    public static org.hamcrest.Matcher<View> hasErrorText(org.hamcrest.Matcher<String> stringMatcher) {
        org.hamcrest.Matcher<String> matcher;
        HasErrorTextMatcher hasErrorTextMatcher = new HasErrorTextMatcher(Preconditions.checkNotNull(matcher));
        return hasErrorTextMatcher;
    }

    public static org.hamcrest.Matcher<View> hasErrorText(String expectedError) {
        return ViewMatchers.hasErrorText((org.hamcrest.Matcher<String>)Matchers.is((Object)expectedError));
    }

    public static org.hamcrest.Matcher<View> withInputType(int inputType) {
        int n;
        WithInputTypeMatcher withInputTypeMatcher = new WithInputTypeMatcher(n);
        return withInputTypeMatcher;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static org.hamcrest.Matcher<View> withParentIndex(int index) {
        int n;
        boolean bl = index >= 0;
        Preconditions.checkArgument(bl, "Index %s must be >= 0", n);
        return new WithParentIndexMatcher(n);
    }

    @Beta
    public static org.hamcrest.Matcher<View> hasBackground(int drawableId) {
        int n;
        HasBackgroundMatcher hasBackgroundMatcher = new HasBackgroundMatcher(n);
        return hasBackgroundMatcher;
    }

    @Beta
    public static org.hamcrest.Matcher<View> hasTextColor(int colorResId) {
        int n;
        BoundedDiagnosingMatcher<View, TextView> boundedDiagnosingMatcher = new BoundedDiagnosingMatcher<View, TextView>(TextView.class){
            private Context context;
            {
                void var1_1;
                super(var1_1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
                void var2_4;
                void var1_2;
                this.context = var1_2.getContext();
                int n3 = var1_2.getCurrentTextColor();
                int n2 = Build.VERSION.SDK_INT <= 22 ? this.context.getResources().getColor(n) : this.context.getColor(n);
                var2_4.appendText("textView.getCurrentTextColor() was ").appendText(this.getColorHex(n3));
                if (n3 != n2) return false;
                return true;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            protected void describeMoreTo(Description description) {
                void var1_1;
                description.appendText("textView.getCurrentTextColor() is color with ");
                if (object.context == null) {
                    var1_1.appendText("ID ").appendValue((Object)object.n);
                    return;
                }
                int n2 = Build.VERSION.SDK_INT <= 22 ? object.context.getResources().getColor(object.n) : object.context.getColor(object.n);
                Object object = String.valueOf(object.getColorHex(n2));
                String string = "value ";
                object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
                var1_1.appendText((String)object);
            }

            /*
             * WARNING - void declaration
             */
            private String getColorHex(int color) {
                void var1_1;
                Object object = Locale.ROOT;
                Object[] objectArray = new Object[]{Color.alpha((int)var1_1) & 0xFF, var1_1 & 0xFFFFFF};
                return String.format((Locale)object, "#%02X%06X", objectArray);
            }
        };
        return boundedDiagnosingMatcher;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String safeGetResourceName(Resources res, int id) {
        void var1_4;
        Resources resources;
        void var0_2;
        block4: {
            try {
                boolean bl = ViewMatchers.isViewIdGenerated((int)id);
                if (!bl) break block4;
                return var0_2;
            }
            catch (Resources.NotFoundException notFoundException) {
                return null;
            }
        }
        String string = resources.getResourceName((int)var1_4);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String safeGetResourceEntryName(Resources res, int id) {
        void var1_4;
        Resources resources;
        void var0_2;
        block4: {
            try {
                boolean bl = ViewMatchers.isViewIdGenerated((int)id);
                if (!bl) break block4;
                return var0_2;
            }
            catch (Resources.NotFoundException notFoundException) {
                return null;
            }
        }
        String string = resources.getResourceEntryName((int)var1_4);
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isViewIdGenerated(int id) {
        int n;
        if ((id & 0xFF000000) != 0) return 0 != 0;
        if ((n & 0xFFFFFF) == 0) return 0 != 0;
        return 1 != 0;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$4200(Resources x0, int x1) {
        void var1_1;
        return ViewMatchers.safeGetResourceName(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$4400(Resources x0, int x1) {
        void var1_1;
        return ViewMatchers.safeGetResourceEntryName(x0, (int)var1_1);
    }

    static final class WithParentIndexMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final int index;
        private final org.hamcrest.Matcher<ViewGroup> parentViewGroupMatcher = Matchers.isA(ViewGroup.class);

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithParentIndexMatcher(int index) {
            void var1_1;
            this.index = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("(view.getParent() ").appendDescriptionOf(this.parentViewGroupMatcher).appendText(" and is at child index ").appendValue((Object)this.index).appendText(")");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var1_1;
            void var2_2;
            ViewParent viewParent = view.getParent();
            if (!this.parentViewGroupMatcher.matches((Object)viewParent)) {
                var2_2.appendText("view.getParent() ");
                this.parentViewGroupMatcher.describeMismatch((Object)viewParent, (Description)var2_2);
                return false;
            }
            if (((ViewGroup)viewParent).getChildCount() <= this.index) {
                var2_2.appendText("parent only has ").appendValue((Object)((ViewGroup)viewParent).getChildCount()).appendText(" children");
                return false;
            }
            if ((viewParent = ((ViewGroup)viewParent).getChildAt(this.index)) != var1_1) {
                var2_2.appendText("child view at index ").appendValue((Object)this.index).appendText(" was ").appendValue((Object)viewParent);
                return false;
            }
            return true;
        }
    }

    static final class WithInputTypeMatcher
    extends BoundedDiagnosingMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private final int inputType;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithInputTypeMatcher(int inputType) {
            super(EditText.class);
            void var1_1;
            this.inputType = var1_1;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("editText.getInputType() is ").appendValue((Object)this.inputType);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchesSafely(EditText view, Description mismatchDescription) {
            void var1_2;
            mismatchDescription.appendText("editText.getInputType() was ").appendValue((Object)var1_2.getInputType());
            if (var1_2.getInputType() != this.inputType) return false;
            return true;
        }
    }

    static final class HasErrorTextMatcher
    extends BoundedDiagnosingMatcher<View, EditText> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasErrorTextMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(EditText.class);
            void var1_1;
            this.stringMatcher = var1_1;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("editText.getError() to match ").appendDescriptionOf(this.stringMatcher);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean matchesSafely(EditText view, Description mismatchDescription) {
            void var1_1;
            mismatchDescription.appendText("editText.getError() was ").appendValue((Object)var1_1.getError());
            return this.stringMatcher.matches((Object)var1_1.getError());
        }
    }

    static final class IsJavascriptEnabledMatcher
    extends BoundedDiagnosingMatcher<View, WebView> {
        @RemoteMsgConstructor
        private IsJavascriptEnabledMatcher() {
            super(WebView.class);
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("webView.getSettings().getJavaScriptEnabled() is ").appendValue((Object)true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean matchesSafely(WebView webView, Description mismatchDescription) {
            void var1_1;
            mismatchDescription.appendText("webView.getSettings().getJavaScriptEnabled() was ").appendValue((Object)var1_1.getSettings().getJavaScriptEnabled());
            return var1_1.getSettings().getJavaScriptEnabled();
        }
    }

    static final class WithSpinnerTextMatcher
    extends BoundedDiagnosingMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithSpinnerTextMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(Spinner.class);
            void var1_1;
            this.stringMatcher = var1_1;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("spinner.getSelectedItem().toString() to match ").appendDescriptionOf(this.stringMatcher);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean matchesSafely(Spinner spinner, Description mismatchDescription) {
            void var1_1;
            void var2_2;
            Object object = spinner.getSelectedItem();
            if (object == null) {
                var2_2.appendText("spinner.getSelectedItem() was null");
                return false;
            }
            var2_2.appendText("spinner.getSelectedItem().toString() was ").appendValue((Object)object.toString());
            return this.stringMatcher.matches((Object)var1_1.getSelectedItem().toString());
        }
    }

    static final class WithSpinnerTextIdMatcher
    extends BoundedDiagnosingMatcher<View, Spinner> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithSpinnerTextIdMatcher(int resourceId) {
            super(Spinner.class);
            void var1_1;
            this.resourceId = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void describeMoreTo(Description description) {
            void var1_1;
            description.appendText("spinner.getSelectedItem().toString() to match string from resource id: ").appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                var1_1.appendText(" [").appendText(this.resourceName).appendText("]");
            }
            if (this.expectedText != null) {
                var1_1.appendText(" value: ").appendText(this.expectedText);
                return;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean matchesSafely(Spinner spinner, Description mismatchDescription) {
            void var2_2;
            Object object;
            if (this.expectedText == null) {
                try {
                    this.expectedText = object.getResources().getString(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {}
                this.resourceName = ViewMatchers.access$4400(object.getResources(), this.resourceId);
            }
            if (this.expectedText == null) {
                var2_2.appendText("failure to resolve resourceId ").appendValue((Object)this.resourceId);
                return false;
            }
            if ((object = object.getSelectedItem()) == null) {
                var2_2.appendText("spinner.getSelectedItem() was null");
                return false;
            }
            var2_2.appendText("spinner.getSelectedItem().toString() was ").appendValue((Object)object.toString());
            return this.expectedText.equals(object.toString());
        }
    }

    static final class HasLinksMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgConstructor
        private HasLinksMatcher() {
            super(TextView.class);
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("textView.getUrls().length > 0");
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            void var1_2;
            mismatchDescription.appendText("textView.getUrls().length was ").appendValue((Object)var1_2.getUrls().length);
            if (var1_2.getUrls().length <= 0) return false;
            return true;
        }
    }

    static final class HasImeActionMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Integer> imeActionMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasImeActionMatcher(org.hamcrest.Matcher<Integer> imeActionMatcher) {
            void var1_1;
            this.imeActionMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("(view.onCreateInputConnection() is not null and editorInfo.actionId ").appendDescriptionOf(this.imeActionMatcher).appendText(")");
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_3;
            void var1_1;
            EditorInfo editorInfo = new EditorInfo();
            if (var1_1.onCreateInputConnection(editorInfo) == null) {
                var2_3.appendText("view.onCreateInputConnection() was null");
                return false;
            }
            int n = editorInfo.actionId != 0 ? editorInfo.actionId : editorInfo.imeOptions & 0xFF;
            if (!this.imeActionMatcher.matches((Object)n)) {
                var2_3.appendText("editorInfo.actionId ");
                this.imeActionMatcher.describeMismatch((Object)n, (Description)var2_3);
                return false;
            }
            return true;
        }
    }

    static final class SupportsInputMethodsMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgConstructor
        private SupportsInputMethodsMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("view.onCreateInputConnection() is not null");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var1_1;
            SupportsInputMethodsMatcher supportsInputMethodsMatcher = new EditorInfo();
            if (var1_1.onCreateInputConnection((EditorInfo)supportsInputMethodsMatcher) == null) {
                void var2_2;
                var2_2.appendText("view.onCreateInputConnection() was null");
                return false;
            }
            return true;
        }
    }

    static final class IsRootMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgConstructor
        private IsRootMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("view.getRootView() to equal view");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var1_1;
            IsRootMatcher isRootMatcher = view.getRootView();
            if (isRootMatcher != var1_1) {
                void var2_2;
                var2_2.appendText("view.getRootView() was ").appendValue((Object)isRootMatcher);
                return false;
            }
            return true;
        }
    }

    static final class HasMinimumChildCountMatcher
    extends BoundedDiagnosingMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int minChildCount;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasMinimumChildCountMatcher(int minChildCount) {
            super(ViewGroup.class);
            void var1_1;
            this.minChildCount = var1_1;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("viewGroup.getChildCount() to be at least ").appendValue((Object)this.minChildCount);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchesSafely(ViewGroup viewGroup, Description mismatchDescription) {
            void var1_2;
            mismatchDescription.appendText("viewGroup.getChildCount() was ").appendValue((Object)var1_2.getChildCount());
            if (var1_2.getChildCount() < this.minChildCount) return false;
            return true;
        }
    }

    static final class HasChildCountMatcher
    extends BoundedDiagnosingMatcher<View, ViewGroup> {
        @RemoteMsgField(order=0)
        private final int childCount;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasChildCountMatcher(int childCount) {
            super(ViewGroup.class);
            void var1_1;
            this.childCount = var1_1;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("viewGroup.getChildCount() to be ").appendValue((Object)this.childCount);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean matchesSafely(ViewGroup viewGroup, Description mismatchDescription) {
            void var1_2;
            mismatchDescription.appendText("viewGroup.getChildCount() was ").appendValue((Object)var1_2.getChildCount());
            if (var1_2.getChildCount() != this.childCount) return false;
            return true;
        }
    }

    static final class WithChildMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> childMatcher;
        private final org.hamcrest.Matcher<ViewGroup> viewGroupMatcher = Matchers.isA(ViewGroup.class);

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithChildMatcher(org.hamcrest.Matcher<View> childMatcher) {
            void var1_1;
            this.childMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("(view ").appendDescriptionOf(this.viewGroupMatcher).appendText(" and has child matching: ").appendDescriptionOf(this.childMatcher).appendText(")");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_3;
            void var1_1;
            if (!this.viewGroupMatcher.matches((Object)var1_1)) {
                var2_3.appendText("view ");
                this.viewGroupMatcher.describeMismatch((Object)var1_1, (Description)var2_3);
                return false;
            }
            ViewGroup viewGroup = (ViewGroup)var1_1;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (!this.childMatcher.matches((Object)viewGroup.getChildAt(i))) continue;
                return true;
            }
            var2_3.appendText("All ").appendValue((Object)viewGroup.getChildCount()).appendText(" children did not match");
            return false;
        }
    }

    static final class WithParentMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> parentMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithParentMatcher(org.hamcrest.Matcher<View> parentMatcher) {
            void var1_1;
            this.parentMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getParent() ").appendDescriptionOf(this.parentMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            ViewParent viewParent = view.getParent();
            if (!this.parentMatcher.matches((Object)viewParent)) {
                void var2_2;
                var2_2.appendText("view.getParent() ");
                this.parentMatcher.describeMismatch((Object)viewParent, (Description)var2_2);
                return false;
            }
            return true;
        }
    }

    static final class WithAlphaMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final float alpha;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithAlphaMatcher(float alpha) {
            void var1_1;
            this.alpha = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getAlpha() is ").appendValue((Object)Float.valueOf(this.alpha));
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            float f = view.getAlpha();
            if (f != this.alpha) {
                void var2_3;
                var2_3.appendText("view.getAlpha() was ").appendValue((Object)Float.valueOf(f));
                return false;
            }
            return true;
        }
    }

    static final class WithEffectiveVisibilityMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final Visibility visibility;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithEffectiveVisibilityMatcher(Visibility visibility) {
            void var1_1;
            this.visibility = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view has effective visibility ").appendValue((Object)this.visibility);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_2;
            View view2;
            if (this.visibility.getValue() == 0) {
                if (view2.getVisibility() == this.visibility.getValue()) {
                    while (view2.getParent() instanceof View) {
                        if ((view2 = (View)view2.getParent()).getVisibility() == this.visibility.getValue()) continue;
                        var2_2.appendText("ancestor ").appendValue((Object)view2).appendText("'s getVisibility() was ").appendValue((Object)Visibility.forViewVisibility(view2));
                        return false;
                    }
                    return true;
                }
                var2_2.appendText("view.getVisibility() was ").appendValue((Object)Visibility.forViewVisibility(view2));
                return false;
            }
            if (view2.getVisibility() != this.visibility.getValue()) {
                while (view2.getParent() instanceof View) {
                    if ((view2 = (View)view2.getParent()).getVisibility() != this.visibility.getValue()) continue;
                    return true;
                }
                var2_2.appendText("neither view nor its ancestors have getVisibility() set to ").appendValue((Object)this.visibility);
                return false;
            }
            return true;
        }
    }

    static final class IsDescendantOfAMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> ancestorMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsDescendantOfAMatcher(org.hamcrest.Matcher<View> ancestorMatcher) {
            void var1_1;
            this.ancestorMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("is descendant of a view matching ").appendDescriptionOf(this.ancestorMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var1_1;
            boolean bl = this.checkAncestors(var1_1.getParent());
            if (!bl) {
                void var2_3;
                var2_3.appendText("none of the ancestors match ").appendDescriptionOf(this.ancestorMatcher);
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private boolean checkAncestors(ViewParent viewParent) {
            void var1_1;
            if (!(viewParent instanceof View)) {
                return false;
            }
            if (this.ancestorMatcher.matches((Object)var1_1)) {
                return true;
            }
            return this.checkAncestors(var1_1.getParent());
        }
    }

    static final class IsClickableMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isClickable;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsClickableMatcher(boolean isClickable) {
            void var1_1;
            this.isClickable = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.isClickable() is ").appendValue((Object)this.isClickable);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean bl = view.isClickable();
            if (bl != this.isClickable) {
                void var2_3;
                var2_3.appendText("view.isClickable() was ").appendValue((Object)bl);
                return false;
            }
            return true;
        }
    }

    static final class HasDescendantMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> descendantMatcher;
        private final org.hamcrest.Matcher<ViewGroup> isViewGroupMatcher = Matchers.isA(ViewGroup.class);

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasDescendantMatcher(org.hamcrest.Matcher<View> descendantMatcher) {
            void var1_1;
            this.descendantMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("(view ").appendDescriptionOf(this.isViewGroupMatcher).appendText(" and has descendant matching ").appendDescriptionOf(this.descendantMatcher).appendText(")");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_2;
            void var1_1;
            if (!this.isViewGroupMatcher.matches((Object)var1_1)) {
                var2_2.appendText("view ");
                this.isViewGroupMatcher.describeMismatch((Object)var1_1, (Description)var2_2);
                return false;
            }
            ViewMatchers$HasDescendantMatcher$$Lambda$0 viewMatchers$HasDescendantMatcher$$Lambda$0 = new ViewMatchers$HasDescendantMatcher$$Lambda$0(this, (View)var1_1);
            if (!Iterables.filter(TreeIterables.breadthFirstViewTraversal((View)var1_1), viewMatchers$HasDescendantMatcher$$Lambda$0).iterator().hasNext()) {
                var2_2.appendText("no descendant matching ").appendDescriptionOf(this.descendantMatcher).appendText(" was found");
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final /* synthetic */ boolean lambda$matchesSafely$0$ViewMatchers$HasDescendantMatcher(View view, View input) {
            void var2_3;
            void var1_2;
            if (input == var1_2) return false;
            if (!this.descendantMatcher.matches((Object)var2_3)) return false;
            return true;
        }
    }

    static final class HasContentDescriptionMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgConstructor
        private HasContentDescriptionMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() is not null");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            if (view.getContentDescription() == null) {
                void var2_2;
                var2_2.appendText("view.getContentDescription() was null");
                return false;
            }
            return true;
        }
    }

    static final class WithCheckBoxStateMatcher<E extends View>
    extends BoundedDiagnosingMatcher<View, E> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Boolean> checkStateMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithCheckBoxStateMatcher(org.hamcrest.Matcher<Boolean> checkStateMatcher) {
            super(View.class, Checkable.class, new Class[0]);
            void var1_1;
            this.checkStateMatcher = var1_1;
        }

        @Override
        protected void describeMoreTo(Description description) {
            description.appendText("view.isChecked() matching: ").appendDescriptionOf(this.checkStateMatcher);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean matchesSafely(E checkable, Description mismatchDescription) {
            void var2_3;
            boolean bl = ((Checkable)checkable).isChecked();
            var2_3.appendText("view.isChecked() was ").appendValue((Object)bl);
            return this.checkStateMatcher.matches((Object)bl);
        }
    }

    static final class WithHintMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithHintMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(TextView.class);
            void var1_1;
            this.stringMatcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void describeMoreTo(Description description) {
            void var1_1;
            description.appendText("view.getHint() matching: ");
            this.stringMatcher.describeTo((Description)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            void var2_2;
            CharSequence charSequence = textView.getHint();
            var2_2.appendText("view.getHint() was ").appendValue((Object)charSequence);
            return this.stringMatcher.matches((Object)charSequence);
        }
    }

    static final class WithCharSequenceMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        @RemoteMsgField(order=1)
        private final TextViewMethod method;
        private String resourceName;
        private String expectedText;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithCharSequenceMatcher(int resourceId, TextViewMethod method) {
            super(TextView.class);
            void var2_2;
            void var1_1;
            this.resourceId = var1_1;
            this.method = var2_2;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        protected void describeMoreTo(Description description) {
            void var1_1;
            switch (2.$SwitchMap$androidx$test$espresso$matcher$ViewMatchers$WithCharSequenceMatcher$TextViewMethod[this.method.ordinal()]) {
                case 2: {
                    var1_1.appendText("view.getHint()");
                }
                default: {
                    break;
                }
                case 1: {
                    var1_1.appendText("view.getText()");
                }
            }
            var1_1.appendText(" equals string from resource id: ").appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                var1_1.appendText(" [").appendText(this.resourceName).appendText("]");
            }
            if (this.expectedText != null) {
                var1_1.appendText(" value: ").appendText(this.expectedText);
                return;
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            if (this /* !! */ .expectedText != null) ** GOTO lbl6
            try {
                this /* !! */ .expectedText = var1_2.getResources().getString(this /* !! */ .resourceId);
            }
            catch (Resources.NotFoundException v0) {
                ** continue;
            }
lbl4:
            // 2 sources

            while (true) {
                this /* !! */ .resourceName = ViewMatchers.access$4400(var1_2.getResources(), this /* !! */ .resourceId);
lbl6:
                // 2 sources

                switch (2.$SwitchMap$androidx$test$espresso$matcher$ViewMatchers$WithCharSequenceMatcher$TextViewMethod[this /* !! */ .method.ordinal()]) {
                    case 2: {
                        var1_2 = var1_2.getHint();
                        var2_3.appendText("view.getHint() was ");
lbl11:
                        // 2 sources

                        while (true) {
                            var2_3.appendValue(var1_2);
                            if (this /* !! */ .expectedText != null && var1_2 != null && this /* !! */ .expectedText.contentEquals((CharSequence)var1_2)) {
                                var0_1 = true;
lbl16:
                                // 2 sources

                                return var0_1;
                            }
                            var0_1 = false;
                            ** continue;
                            break;
                        }
                    }
                    case 1: {
                        var1_2 = var1_2.getText();
                        var2_3.appendText("view.getText() was ");
                        ** continue;
                    }
                }
                this /* !! */  = String.valueOf((Object)this /* !! */ .method);
                var2_3 = String.valueOf((Object)this /* !! */ );
                var2_4 = var2_3.length();
                var3_5 = new StringBuilder(var2_4 + 28);
                var1_2 = new IllegalStateException(var3_5.append("Unexpected TextView method: ").append((String)this /* !! */ ).toString());
                throw var1_2;
            }
        }

        private static final class TextViewMethod
        extends Enum<TextViewMethod> {
            public static final /* enum */ TextViewMethod GET_TEXT;
            public static final /* enum */ TextViewMethod GET_HINT;
            private static final /* synthetic */ TextViewMethod[] $VALUES;

            public static TextViewMethod[] values() {
                return (TextViewMethod[])$VALUES.clone();
            }

            public static TextViewMethod valueOf(String name) {
                String string;
                return Enum.valueOf(TextViewMethod.class, string);
            }

            static {
                TextViewMethod textViewMethod;
                GET_TEXT = textViewMethod = new TextViewMethod();
                GET_HINT = textViewMethod = new TextViewMethod();
                $VALUES = textViewMethodArray = new TextViewMethod[]{TextViewMethod.GET_TEXT, TextViewMethod.GET_HINT};
            }
        }
    }

    static final class WithTagValueMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<Object> tagValueMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithTagValueMatcher(org.hamcrest.Matcher<Object> tagValueMatcher) {
            void var1_1;
            this.tagValueMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getTag() ").appendDescriptionOf(this.tagValueMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            Object object = view.getTag();
            if (!this.tagValueMatcher.matches(object)) {
                void var2_2;
                var2_2.appendText("view.getTag() ");
                this.tagValueMatcher.describeMismatch(object, (Description)var2_2);
                return false;
            }
            return true;
        }
    }

    static final class WithContentDescriptionTextMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> textMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithContentDescriptionTextMatcher(org.hamcrest.Matcher<String> textMatcher) {
            void var1_1;
            this.textMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() ").appendDescriptionOf(this.textMatcher);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            String string;
            string = view.getContentDescription() != null ? string.getContentDescription().toString() : null;
            if (!this.textMatcher.matches((Object)string)) {
                void var2_2;
                var2_2.appendText("view.getContentDescription() ");
                this.textMatcher.describeMismatch((Object)string, (Description)var2_2);
                return false;
            }
            return true;
        }
    }

    static final class WithContentDescriptionMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithContentDescriptionMatcher(org.hamcrest.Matcher<? extends CharSequence> charSequenceMatcher) {
            void var1_1;
            this.charSequenceMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getContentDescription() ").appendDescriptionOf(this.charSequenceMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            CharSequence charSequence = view.getContentDescription();
            if (!this.charSequenceMatcher.matches((Object)charSequence)) {
                void var2_2;
                var2_2.appendText("view.getContentDescription() ");
                this.charSequenceMatcher.describeMismatch((Object)charSequence, (Description)var2_2);
                return false;
            }
            return true;
        }
    }

    static final class WithContentDescriptionFromIdMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final int resourceId;
        private String resourceName = null;
        private String expectedText = null;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithContentDescriptionFromIdMatcher(int resourceId) {
            void var1_1;
            this.resourceId = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            description.appendText("view.getContentDescription() to match resource id ").appendValue((Object)this.resourceId);
            if (this.resourceName != null) {
                var1_1.appendText("[").appendText(this.resourceName).appendText("]");
            }
            if (this.expectedText != null) {
                var1_1.appendText(" with value ").appendValue((Object)this.expectedText);
                return;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_2;
            CharSequence charSequence;
            if (this.expectedText == null) {
                try {
                    this.expectedText = charSequence.getResources().getString(this.resourceId);
                }
                catch (Resources.NotFoundException notFoundException) {}
                this.resourceName = ViewMatchers.access$4400(charSequence.getResources(), this.resourceId);
            }
            if (this.expectedText == null) {
                var2_2.appendText("Failed to resolve resource id ").appendValue((Object)this.resourceId);
                return false;
            }
            if ((charSequence = charSequence.getContentDescription()) != null && this.expectedText.contentEquals(charSequence)) {
                return true;
            }
            var2_2.appendText("view.getContentDescription() was ").appendValue((Object)charSequence);
            return false;
        }
    }

    static final class HasSiblingMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<View> siblingMatcher;
        private final org.hamcrest.Matcher<ViewGroup> parentMatcher = Matchers.isA(ViewGroup.class);

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasSiblingMatcher(org.hamcrest.Matcher<View> siblingMatcher) {
            void var1_1;
            this.siblingMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("(view.getParent() ").appendDescriptionOf(this.parentMatcher).appendText(" and has a sibling matching ").appendDescriptionOf(this.siblingMatcher).appendText(")");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_2;
            ViewParent viewParent = view.getParent();
            if (!this.parentMatcher.matches((Object)viewParent)) {
                var2_2.appendText("view.getParent() ");
                this.parentMatcher.describeMismatch((Object)viewParent, (Description)var2_2);
                return false;
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            if (viewGroup.getChildCount() == 1) {
                var2_2.appendText("no siblings found");
                return false;
            }
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                void var1_1;
                View view2 = viewGroup.getChildAt(i);
                if (var1_1 == view2 || !this.siblingMatcher.matches((Object)view2)) continue;
                return true;
            }
            var2_2.appendText("none of the ").appendValue((Object)(viewGroup.getChildCount() + -1)).appendText(" siblings match");
            return false;
        }
    }

    static final class IsSelectedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isSelected;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsSelectedMatcher(boolean isSelected) {
            void var1_1;
            this.isSelected = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.isSelected() is ").appendValue((Object)this.isSelected);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean bl = view.isSelected();
            if (bl != this.isSelected) {
                void var2_3;
                var2_3.appendText("view.isSelected() was ").appendValue((Object)bl);
                return false;
            }
            return true;
        }
    }

    static final class HasFocusMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean hasFocus;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private HasFocusMatcher(boolean hasFocus) {
            void var1_1;
            this.hasFocus = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.hasFocus() is ").appendValue((Object)this.hasFocus);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean bl = view.hasFocus();
            if (bl != this.hasFocus) {
                void var2_3;
                var2_3.appendText("view.hasFocus() is ").appendValue((Object)bl);
                return false;
            }
            return true;
        }
    }

    static final class IsFocusedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isFocused;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsFocusedMatcher(boolean isFocused) {
            void var1_1;
            this.isFocused = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.isFocused() is ").appendValue((Object)this.isFocused);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean bl = view.isFocused();
            if (bl != this.isFocused) {
                void var2_3;
                var2_3.appendText("view.isFocused() was ").appendValue((Object)bl);
                return false;
            }
            return true;
        }
    }

    static final class IsFocusableMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isFocusable;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsFocusableMatcher(boolean isFocusable) {
            void var1_1;
            this.isFocusable = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.isFocusable() is ").appendValue((Object)this.isFocusable);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean bl = view.isFocusable();
            if (bl != this.isFocusable) {
                void var2_3;
                var2_3.appendText("view.isFocusable() was ").appendValue((Object)bl);
                return false;
            }
            return true;
        }
    }

    static final class IsEnabledMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final boolean isEnabled;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsEnabledMatcher(boolean isEnabled) {
            void var1_1;
            this.isEnabled = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.isEnabled() is ").appendValue((Object)this.isEnabled);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            boolean bl = view.isEnabled();
            if (bl != this.isEnabled) {
                void var2_3;
                var2_3.appendText("view.isEnabled() was ").appendValue((Object)bl);
                return false;
            }
            return true;
        }
    }

    static final class IsDisplayingAtLeastMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        final int areaPercentage;
        private final org.hamcrest.Matcher<View> visibilityMatchers = ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE);

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsDisplayingAtLeastMatcher(int areaPercentage) {
            void var1_1;
            this.areaPercentage = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("(").appendDescriptionOf(this.visibilityMatchers).appendText(" and view.getGlobalVisibleRect() covers at least ").appendValue((Object)this.areaPercentage).appendText(" percent of the view's area)");
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            int n;
            float f;
            void var2_4;
            void var1_1;
            if (!this.visibilityMatchers.matches((Object)var1_1)) {
                this.visibilityMatchers.describeMismatch((Object)var1_1, (Description)var2_4);
                return false;
            }
            Rect rect = new Rect();
            if (!var1_1.getGlobalVisibleRect(rect)) {
                var2_4.appendText("view was ").appendValue((Object)0).appendText(" percent visible to the user");
                return false;
            }
            Rect rect2 = this.getScreenWithoutStatusBarActionBar((View)var1_1);
            float f2 = var1_1.getHeight() > rect2.height() ? (float)rect2.height() : (float)var1_1.getHeight();
            float f3 = var1_1.getWidth() > rect2.width() ? (float)rect2.width() : (float)var1_1.getWidth();
            if (Build.VERSION.SDK_INT >= 11) {
                f2 = Math.min((float)var1_1.getHeight() * Math.abs(var1_1.getScaleY()), (float)rect2.height());
                f3 = Math.min((float)var1_1.getWidth() * Math.abs(var1_1.getScaleX()), (float)rect2.width());
                f = f2;
                f2 = f3;
            } else {
                f = f2;
                f2 = f3;
            }
            if ((n = (int)((double)(rect.height() * rect.width()) / (double)(f * f2) * 100.0)) < this.areaPercentage) {
                var2_4.appendText("view was ").appendValue((Object)n).appendText(" percent visible to the user");
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private Rect getScreenWithoutStatusBarActionBar(View view) {
            void var1_2;
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)var1_2.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            int n = var1_2.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
            n = n > 0 ? var1_2.getContext().getResources().getDimensionPixelSize(n) : 0;
            TypedValue typedValue = new TypedValue();
            int n2 = var1_2.getContext().getTheme().resolveAttribute(16843499, typedValue, true) ? TypedValue.complexToDimensionPixelSize((int)typedValue.data, (DisplayMetrics)var1_2.getContext().getResources().getDisplayMetrics()) : 0;
            return new Rect(0, 0, displayMetrics.widthPixels, displayMetrics.heightPixels - (n + n2));
        }
    }

    static final class IsDisplayedMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        private final org.hamcrest.Matcher<View> visibilityMatcher = ViewMatchers.withEffectiveVisibility(Visibility.VISIBLE);

        @RemoteMsgConstructor
        private IsDisplayedMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("(").appendDescriptionOf(this.visibilityMatcher).appendText(" and view.getGlobalVisibleRect() to return non-empty rectangle)");
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var2_2;
            void var1_1;
            if (!this_.visibilityMatcher.matches((Object)var1_1)) {
                this_.visibilityMatcher.describeMismatch((Object)var1_1, (Description)var2_2);
                return false;
            }
            IsDisplayedMatcher this_ = new Rect();
            if (!var1_1.getGlobalVisibleRect((Rect)this_)) {
                var2_2.appendText("view.getGlobalVisibleRect() returned empty rectangle");
                return false;
            }
            return true;
        }
    }

    static final class WithClassNameMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        final org.hamcrest.Matcher<String> classNameMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithClassNameMatcher(org.hamcrest.Matcher<String> classNameMatcher) {
            void var1_1;
            this.classNameMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getClass().getName() matches: ").appendDescriptionOf(this.classNameMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            String string = view.getClass().getName();
            if (!this.classNameMatcher.matches((Object)string)) {
                void var2_2;
                var2_2.appendText("view.getClass().getName() ");
                this.classNameMatcher.describeMismatch((Object)string, (Description)var2_2);
                return false;
            }
            return true;
        }
    }

    static final class IsAssignableFromMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final Class<?> clazz;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private IsAssignableFromMatcher(Class<?> clazz) {
            void var1_1;
            this.clazz = (Class)Preconditions.checkNotNull(var1_1);
        }

        public void describeTo(Description description) {
            description.appendText("is assignable from class ").appendValue(this.clazz);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            void var1_1;
            if (!this.clazz.isAssignableFrom(var1_1.getClass())) {
                void var2_2;
                var2_2.appendText("view.getClass() was ").appendValue(var1_1.getClass());
                return false;
            }
            return true;
        }
    }

    static final class WithTagKeyMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final int key;
        @RemoteMsgField(order=1)
        private final org.hamcrest.Matcher<?> objectMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithTagKeyMatcher(int key, org.hamcrest.Matcher<?> objectMatcher) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.objectMatcher = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            int n = this.key;
            StringBuilder stringBuilder = new StringBuilder(25);
            var1_1.appendText(stringBuilder.append("view.getTag(").append(n).append(") ").toString()).appendDescriptionOf(this.objectMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            Object object = view.getTag(this.key);
            if (!this.objectMatcher.matches(object)) {
                void var2_2;
                int n = this.key;
                StringBuilder stringBuilder = new StringBuilder(25);
                var2_2.appendText(stringBuilder.append("view.getTag(").append(n).append(") ").toString());
                this.objectMatcher.describeMismatch(object, (Description)var2_2);
                return false;
            }
            return true;
        }
    }

    static final class WithResourceNameMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithResourceNameMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            void var1_1;
            this.stringMatcher = var1_1;
        }

        public void describeTo(Description description) {
            description.appendText("view.getId()'s resource name should match ").appendDescriptionOf(this.stringMatcher);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            String string;
            void var2_2;
            int n = view.getId();
            if (n == -1) {
                var2_2.appendText("view.getId() was View.NO_ID");
                return false;
            }
            if (string.getResources() == null) {
                var2_2.appendText("view.getResources() was null, can't resolve resource name");
                return false;
            }
            if (ViewMatchers.isViewIdGenerated(n)) {
                var2_2.appendText("view.getId() was generated by a call to View.generateViewId()");
                return false;
            }
            if ((string = ViewMatchers.access$4400(string.getResources(), string.getId())) == null) {
                var2_2.appendText("view.getId() was ").appendValue((Object)n).appendText(" which fails to resolve resource name");
                return false;
            }
            if (!this.stringMatcher.matches((Object)string)) {
                var2_2.appendText("view.getId() was <").appendText(string).appendText(">");
                return false;
            }
            return true;
        }
    }

    static final class WithTextMatcher
    extends BoundedDiagnosingMatcher<View, TextView> {
        @RemoteMsgField(order=0)
        private final org.hamcrest.Matcher<String> stringMatcher;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithTextMatcher(org.hamcrest.Matcher<String> stringMatcher) {
            super(TextView.class);
            void var1_1;
            this.stringMatcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void describeMoreTo(Description description) {
            void var1_1;
            description.appendText("view.getText() with or without transformation to match: ");
            this.stringMatcher.describeTo((Description)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean matchesSafely(TextView textView, Description mismatchDescription) {
            CharSequence charSequence;
            void var2_2;
            String string = textView.getText().toString();
            if (this.stringMatcher.matches((Object)string)) {
                return true;
            }
            var2_2.appendText("view.getText() was ").appendValue((Object)string);
            if (charSequence.getTransformationMethod() != null) {
                charSequence = charSequence.getTransformationMethod().getTransformation((CharSequence)string, (View)charSequence);
                var2_2.appendText(" transformed text was ").appendValue((Object)charSequence);
                if (charSequence != null) {
                    return this.stringMatcher.matches((Object)charSequence.toString());
                }
            }
            return false;
        }
    }

    static final class WithIdMatcher
    extends TypeSafeDiagnosingMatcher<View> {
        @RemoteMsgField(order=0)
        org.hamcrest.Matcher<Integer> viewIdMatcher;
        private Resources resources;

        /*
         * WARNING - void declaration
         */
        @RemoteMsgConstructor
        private WithIdMatcher(org.hamcrest.Matcher<Integer> integerMatcher) {
            void var1_1;
            this.viewIdMatcher = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void describeTo(Description description) {
            void var1_1;
            Object object = this_.viewIdMatcher;
            object = object.toString();
            Object this_ = this_.getViewIdString((String)object);
            var1_1.appendText("view.getId() ").appendText((String)this_);
        }

        /*
         * WARNING - void declaration
         */
        protected boolean matchesSafely(View view, Description mismatchDescription) {
            Description description;
            void var1_1;
            this.resources = var1_1.getResources();
            boolean bl = this.viewIdMatcher.matches((Object)var1_1.getId());
            if (!bl && !(description instanceof Description.NullDescription)) {
                description = description.appendText("view.getId() was ");
                int n = var1_1.getId();
                StringBuilder stringBuilder = new StringBuilder(13);
                description.appendText(this.getViewIdString(stringBuilder.append("<").append(n).append(">").toString()));
            }
            return bl;
        }

        private String getViewIdString(String idDescription) {
            String string;
            Matcher matcher = RESOURCE_ID_PATTERN.matcher(string);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            while (matcher.find()) {
                if (this.resources == null) continue;
                string = matcher.group();
                int n = Integer.parseInt(string);
                Object object = ViewMatchers.access$4200(this.resources, n);
                if (object != null) {
                    String string2 = String.valueOf(string);
                    int n2 = string2.length();
                    String string3 = String.valueOf(object);
                    int n3 = string3.length();
                    StringBuilder stringBuilder = new StringBuilder(n2 + 1 + n3);
                    matcher.appendReplacement(stringBuffer, stringBuilder.append(string).append("/").append((String)object).toString());
                    continue;
                }
                object = Locale.ROOT;
                Object[] objectArray = new Object[]{string};
                matcher.appendReplacement(stringBuffer, String.format((Locale)object, "%s (resource name not found)", objectArray));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
    }

    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility VISIBLE;
        public static final /* enum */ Visibility INVISIBLE;
        public static final /* enum */ Visibility GONE;
        private final int value;
        private static final /* synthetic */ Visibility[] $VALUES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String name) {
            String string;
            return Enum.valueOf(Visibility.class, string);
        }

        /*
         * WARNING - void declaration
         */
        private Visibility(int value) {
            void var3_3;
            this.value = var3_3;
        }

        public static Visibility forViewVisibility(View view) {
            return Visibility.forViewVisibility(view.getVisibility());
        }

        public static Visibility forViewVisibility(int visibility) {
            switch (visibility) {
                default: {
                    int n;
                    StringBuilder stringBuilder = new StringBuilder(38);
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("Invalid visibility value <").append(n).append(">").toString());
                    throw illegalArgumentException;
                }
                case 8: {
                    return GONE;
                }
                case 4: {
                    return INVISIBLE;
                }
                case 0: 
            }
            return VISIBLE;
        }

        public int getValue() {
            return this.value;
        }

        static {
            Visibility visibility;
            VISIBLE = visibility = new Visibility(0);
            INVISIBLE = visibility = new Visibility(4);
            GONE = visibility = new Visibility(8);
            $VALUES = visibilityArray = new Visibility[]{Visibility.VISIBLE, Visibility.INVISIBLE, Visibility.GONE};
        }
    }
}

