/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.matcher;

import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.matcher.BoundedMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;

public final class CursorMatchers {
    private static final int COLUMN_NOT_FOUND = -1;
    private static final int MULTIPLE_COLUMNS_FOUND = -2;
    private static final int USE_COLUMN_PICKER = -3;
    private static final CursorDataRetriever<byte[]> BLOB_MATCHER_APPLIER;
    private static final CursorDataRetriever<Long> LONG_MATCHER_APPLIER;
    private static final CursorDataRetriever<Short> SHORT_MATCHER_APPLIER;
    private static final CursorDataRetriever<Integer> INT_MATCHER_APPLIER;
    private static final CursorDataRetriever<Float> FLOAT_MATCHER_APPLIER;
    private static final CursorDataRetriever<Double> DOUBLE_MATCHER_APPLIER;
    private static final CursorDataRetriever<String> STRING_MATCHER_APPLIER;

    private CursorMatchers() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findColumnIndex(Matcher<String> nameMatcher, Cursor cursor) {
        String[] stringArray = cursor.getColumnNames();
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            Matcher<String> matcher;
            if (matcher.matches((Object)stringArray[n2])) {
                if (n != -1) return -2;
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowShort(int columnIndex, short value) {
        void var1_1;
        return CursorMatchers.withRowShort(columnIndex, (Matcher<Short>)Matchers.is((Object)((short)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowShort(int columnIndex, Matcher<Short> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, SHORT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowShort(String columnName, short value) {
        void var1_1;
        return CursorMatchers.withRowShort(columnName, (Matcher<Short>)Matchers.is((Object)((short)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowShort(String columnName, Matcher<Short> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowShort((Matcher<String>)Matchers.is((Object)columnName), (Matcher<Short>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowShort(Matcher<String> columnNameMatcher, Matcher<Short> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, SHORT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowInt(int columnIndex, int value) {
        void var1_1;
        return CursorMatchers.withRowInt(columnIndex, (Matcher<Integer>)Matchers.is((Object)((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowInt(int columnIndex, Matcher<Integer> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, INT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowInt(String columnName, int value) {
        void var1_1;
        return CursorMatchers.withRowInt(columnName, (Matcher<Integer>)Matchers.is((Object)((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowInt(String columnName, Matcher<Integer> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowInt((Matcher<String>)Matchers.is((Object)columnName), (Matcher<Integer>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowInt(Matcher<String> columnNameMatcher, Matcher<Integer> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, INT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowLong(int columnIndex, long value) {
        void var1_1;
        return CursorMatchers.withRowLong(columnIndex, (Matcher<Long>)Matchers.is((Object)((long)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowLong(int columnIndex, Matcher<Long> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, LONG_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowLong(String columnName, long value) {
        void var1_1;
        return CursorMatchers.withRowLong(columnName, (Matcher<Long>)Matchers.is((Object)((long)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowLong(String columnName, Matcher<Long> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowLong((Matcher<String>)Matchers.is((Object)columnName), (Matcher<Long>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowLong(Matcher<String> columnNameMatcher, Matcher<Long> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, LONG_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowFloat(int columnIndex, float value) {
        void var1_1;
        return CursorMatchers.withRowFloat(columnIndex, (Matcher<Float>)Matchers.is((Object)Float.valueOf((float)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowFloat(int columnIndex, Matcher<Float> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, FLOAT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowFloat(String columnName, float value) {
        void var1_1;
        return CursorMatchers.withRowFloat(columnName, (Matcher<Float>)Matchers.is((Object)Float.valueOf((float)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowFloat(String columnName, Matcher<Float> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowFloat((Matcher<String>)Matchers.is((Object)columnName), (Matcher<Float>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowFloat(Matcher<String> columnNameMatcher, Matcher<Float> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, FLOAT_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowDouble(int columnIndex, double value) {
        void var1_1;
        return CursorMatchers.withRowDouble(columnIndex, (Matcher<Double>)Matchers.is((Object)((double)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowDouble(int columnIndex, Matcher<Double> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, DOUBLE_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowDouble(String columnName, double value) {
        void var1_1;
        return CursorMatchers.withRowDouble(columnName, (Matcher<Double>)Matchers.is((Object)((double)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowDouble(String columnName, Matcher<Double> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowDouble((Matcher<String>)Matchers.is((Object)columnName), (Matcher<Double>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowDouble(Matcher<String> columnNameMatcher, Matcher<Double> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, DOUBLE_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowString(int columnIndex, String value) {
        void var1_1;
        return CursorMatchers.withRowString(columnIndex, (Matcher<String>)Matchers.is((Object)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowString(int columnIndex, Matcher<String> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, STRING_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowString(String columnName, String value) {
        void var1_1;
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)columnName), (Matcher<String>)Matchers.is((Object)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowString(String columnName, Matcher<String> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowString((Matcher<String>)Matchers.is((Object)columnName), (Matcher<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowString(Matcher<String> columnPicker, Matcher<String> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, STRING_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowBlob(int columnIndex, byte[] value) {
        void var1_1;
        return CursorMatchers.withRowBlob(columnIndex, (Matcher<byte[]>)Matchers.is((Object)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowBlob(int columnIndex, Matcher<byte[]> valueMatcher) {
        void var1_1;
        int n;
        CursorMatcher cursorMatcher = new CursorMatcher(n, (Matcher)var1_1, BLOB_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowBlob(String columnName, byte[] value) {
        void var1_1;
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)columnName), (Matcher<byte[]>)Matchers.is((Object)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowBlob(String columnName, Matcher<byte[]> valueMatcher) {
        void var1_1;
        return CursorMatchers.withRowBlob((Matcher<String>)Matchers.is((Object)columnName), (Matcher<byte[]>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static CursorMatcher withRowBlob(Matcher<String> columnPicker, Matcher<byte[]> valueMatcher) {
        void var1_1;
        Matcher<String> matcher;
        CursorMatcher cursorMatcher = new CursorMatcher(matcher, (Matcher)var1_1, BLOB_MATCHER_APPLIER);
        return cursorMatcher;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(Matcher x0, Cursor x1) {
        void var1_1;
        return CursorMatchers.findColumnIndex((Matcher<String>)x0, (Cursor)var1_1);
    }

    static {
        CursorDataRetriever<byte[]> cursorDataRetriever;
        BLOB_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<byte[]>(){

            public void describeTo(Description description) {
                description.appendText("with Blob");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public byte[] getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return cursor.getBlob((int)var2_2);
            }
        };
        LONG_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<Long>(){

            public void describeTo(Description description) {
                description.appendText("with Long");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Long getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return cursor.getLong((int)var2_2);
            }
        };
        SHORT_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<Short>(){

            public void describeTo(Description description) {
                description.appendText("with Short");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Short getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return cursor.getShort((int)var2_2);
            }
        };
        INT_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<Integer>(){

            public void describeTo(Description description) {
                description.appendText("with Int");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Integer getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return cursor.getInt((int)var2_2);
            }
        };
        FLOAT_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<Float>(){

            public void describeTo(Description description) {
                description.appendText("with Float");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Float getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return Float.valueOf(cursor.getFloat((int)var2_2));
            }
        };
        DOUBLE_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<Double>(){

            public void describeTo(Description description) {
                description.appendText("with Double");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Double getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return cursor.getDouble((int)var2_2);
            }
        };
        STRING_MATCHER_APPLIER = cursorDataRetriever = new CursorDataRetriever<String>(){

            public void describeTo(Description description) {
                description.appendText("with String");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public String getData(Cursor cursor, int chosenColumn) {
                void var2_2;
                return cursor.getString((int)var2_2);
            }
        };
    }

    private static interface CursorDataRetriever<T>
    extends SelfDescribing {
        public T getData(Cursor var1, int var2);
    }

    public static class CursorMatcher
    extends BoundedMatcher<Object, Cursor> {
        private final int columnIndex;
        private final Matcher<String> columnNameMatcher;
        private final Matcher<?> valueMatcher;
        private final CursorDataRetriever<?> cursorDataRetriever;
        private boolean checkColumns = false;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private CursorMatcher(int columnIndex, Matcher<?> valueMatcher, CursorDataRetriever<?> cursorDataRetriever) {
            super(Cursor.class);
            void var3_3;
            void var2_2;
            void var1_1;
            boolean bl = var1_1 >= 0;
            Preconditions.checkArgument(bl);
            this.columnIndex = var1_1;
            this.valueMatcher = (Matcher)Preconditions.checkNotNull(var2_2);
            this.cursorDataRetriever = (CursorDataRetriever)Preconditions.checkNotNull(var3_3);
            this.columnNameMatcher = null;
        }

        /*
         * WARNING - void declaration
         */
        private CursorMatcher(Matcher<String> columnPicker, Matcher<?> valueMatcher, CursorDataRetriever<?> cursorDataRetriever) {
            super(Cursor.class);
            void var3_3;
            void var2_2;
            void var1_1;
            this.columnNameMatcher = (Matcher)Preconditions.checkNotNull(var1_1);
            this.valueMatcher = (Matcher)Preconditions.checkNotNull(var2_2);
            this.cursorDataRetriever = (CursorDataRetriever)Preconditions.checkNotNull(var3_3);
            this.columnIndex = -3;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matchesSafely(Cursor cursor) {
            Object obj;
            int n = this.columnIndex;
            StringDescription stringDescription = new StringDescription();
            if (n < 0 && (n = CursorMatchers.access$000(this.columnNameMatcher, (Cursor)obj)) < 0) {
                if (n == -2) {
                    stringDescription.appendText("Multiple columns in ").appendValue((Object)obj.getColumnNames()).appendText(" match ").appendDescriptionOf(this.columnNameMatcher);
                } else {
                    stringDescription.appendText("Couldn't find column in ").appendValue((Object)obj.getColumnNames()).appendText(" matching ").appendDescriptionOf(this.columnNameMatcher);
                }
                if (this.checkColumns) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringDescription.toString());
                    throw illegalArgumentException;
                }
                return false;
            }
            try {
                obj = this.cursorDataRetriever.getData((Cursor)obj, n);
                boolean bl = this.valueMatcher.matches(obj);
                if (!bl) {
                    stringDescription.appendText("value at column ").appendValue((Object)n).appendText(" ");
                    this.valueMatcher.describeMismatch(obj, (Description)stringDescription);
                }
                return bl;
            }
            catch (CursorIndexOutOfBoundsException cursorIndexOutOfBoundsException) {
                stringDescription.appendText("Column index ").appendValue((Object)n).appendText(" is invalid");
                if (this.checkColumns) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringDescription.toString(), cursorIndexOutOfBoundsException);
                    throw illegalArgumentException;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public void describeTo(Description description) {
            void var1_1;
            description.appendText("an instance of android.database.Cursor and Rows with column: ");
            if (this.columnIndex < 0) {
                this.columnNameMatcher.describeTo((Description)var1_1);
            } else {
                int n = this.columnIndex;
                StringBuilder stringBuilder = new StringBuilder(19);
                var1_1.appendText(stringBuilder.append("index = ").append(n).toString());
            }
            var1_1.appendText(" ").appendDescriptionOf(this.cursorDataRetriever).appendText(" matching ").appendDescriptionOf(this.valueMatcher);
        }

        /*
         * WARNING - void declaration
         */
        public CursorMatcher withStrictColumnChecks(boolean checkColumns) {
            void var1_1;
            this.checkColumns = var1_1;
            return this;
        }
    }
}

