/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.util.concurrent.NullnessCasts;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.LockSupport;

abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable PARKED;

    InterruptibleTask() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        Object t;
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = !this.isDone();
        if (bl) {
            t = this.runInterruptibly();
        } else {
            t = null;
        }
        if (!this.compareAndSet(thread, DONE)) {
            this.waitForInterrupt(thread);
        }
        if (!bl) return;
        this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(t));
        return;
        catch (Throwable throwable) {
            if (!this.compareAndSet(thread, DONE)) {
                this.waitForInterrupt(thread);
            }
            if (!bl) {
                return;
            }
            this.afterRanInterruptiblyFailure(throwable);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void waitForInterrupt(Thread thread) {
        Runnable runnable = (Runnable)this.get();
        boolean bl = false;
        int n = 0;
        Blocker blocker = null;
        while (runnable instanceof Blocker || runnable == PARKED) {
            if (runnable instanceof Blocker) {
                blocker = (Blocker)runnable;
            }
            if (++n > 1000) {
                if (runnable == PARKED || this.compareAndSet(runnable, PARKED)) {
                    bl = Thread.interrupted() || bl;
                    LockSupport.park(blocker);
                }
            } else {
                Thread.yield();
            }
            runnable = (Runnable)this.get();
        }
        if (bl) {
            thread.interrupt();
            return;
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptiblySuccess(T var1);

    abstract void afterRanInterruptiblyFailure(Throwable var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (!(runnable instanceof Thread)) return;
        Blocker blocker = new Blocker(this);
        blocker.setOwner(Thread.currentThread());
        if (!this.compareAndSet(runnable, blocker)) return;
        try {
            ((Thread)runnable).interrupt();
        }
        catch (Throwable throwable) {
            if (this.getAndSet(DONE) != PARKED) {
                throw throwable;
            }
            LockSupport.unpark((Thread)runnable);
            throw throwable;
        }
        if (this.getAndSet(DONE) != PARKED) return;
        LockSupport.unpark((Thread)runnable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String toString() {
        CharSequence charSequence;
        Object object = (Runnable)((AtomicReference)((Object)string)).get();
        if (object == DONE) {
            object = "running=[DONE]";
        } else if (object instanceof Blocker) {
            object = "running=[INTERRUPTED]";
        } else if (object instanceof Thread) {
            object = ((Thread)object).getName();
            String string = String.valueOf(object);
            int n = string.length();
            charSequence = new StringBuilder(n + 21);
            object = ((StringBuilder)charSequence).append("running=[RUNNING ON ").append((String)object).append("]").toString();
        } else {
            object = "running=[NOT STARTED YET]";
        }
        String string = ((InterruptibleTask)((Object)string)).toPendingString();
        String string2 = String.valueOf(object);
        int n = string2.length();
        charSequence = String.valueOf(string);
        int n2 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n + 2 + n2);
        return stringBuilder.append((String)object).append(", ").append(string).toString();
    }

    abstract String toPendingString();

    static {
        DoNothingRunnable doNothingRunnable = new DoNothingRunnable();
        DONE = doNothingRunnable;
        doNothingRunnable = new DoNothingRunnable();
        PARKED = doNothingRunnable;
    }

    static final class Blocker
    extends AbstractOwnableSynchronizer
    implements Runnable {
        private final InterruptibleTask<?> task;

        private Blocker(InterruptibleTask<?> interruptibleTask) {
            this.task = interruptibleTask;
        }

        @Override
        public void run() {
        }

        private void setOwner(Thread thread) {
            super.setExclusiveOwnerThread(thread);
        }

        public String toString() {
            return this.task.toString();
        }
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

