/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.util.concurrent;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class ImmediateFuture<V>
implements ListenableFuture<V> {
    static final ListenableFuture<?> NULL;
    private static final Logger log;
    private final V value;

    ImmediateFuture(V v) {
        this.value = v;
    }

    @Override
    public void addListener(Runnable object, Executor object2) {
        Preconditions.checkNotNull(object, "Runnable was null.");
        Preconditions.checkNotNull(object2, "Executor was null.");
        try {
            object2.execute((Runnable)object);
            return;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = log;
            Level level = Level.SEVERE;
            object = String.valueOf(object);
            object2 = String.valueOf(object2);
            String string = String.valueOf(object);
            int n = string.length();
            String string2 = String.valueOf(object2);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 57 + n2);
            logger.logp(level, "androidx.test.espresso.core.internal.deps.guava.util.concurrent.ImmediateFuture", "addListener", stringBuilder.append("RuntimeException while executing runnable ").append((String)object).append(" with executor ").append((String)object2).toString(), runtimeException);
            return;
        }
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException {
        Preconditions.checkNotNull(timeUnit);
        return this.get();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    public String toString() {
        String string = super.toString();
        String string2 = String.valueOf(((ImmediateFuture)((Object)string2)).value);
        String string3 = String.valueOf(string);
        int n = string3.length();
        String string4 = String.valueOf(string2);
        int n2 = string4.length();
        StringBuilder stringBuilder = new StringBuilder(n + 27 + n2);
        return stringBuilder.append(string).append("[status=SUCCESS, result=[").append(string2).append("]]").toString();
    }

    static {
        ImmediateFuture<Object> immediateFuture = new ImmediateFuture<Object>(null);
        NULL = immediateFuture;
        log = Logger.getLogger(ImmediateFuture.class.getName());
    }

    static final class ImmediateFailedFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        ImmediateFailedFuture(Throwable throwable) {
            this.setException(throwable);
        }
    }
}

