/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.collect.ByFunctionOrdering;
import androidx.test.espresso.core.internal.deps.guava.collect.ComparatorOrdering;
import java.util.Comparator;

public abstract class Ordering<T>
implements Comparator<T> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Ordering<T> from(Comparator<T> ordering) {
        if (ordering instanceof Ordering) {
            return ordering;
        }
        ComparatorOrdering comparatorOrdering = new ComparatorOrdering(ordering);
        return comparatorOrdering;
    }

    protected Ordering() {
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        ByFunctionOrdering<F, ? extends T> byFunctionOrdering = new ByFunctionOrdering<F, T>(function, this);
        return byFunctionOrdering;
    }

    @Override
    public abstract int compare(T var1, T var2);
}

