/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.collect;

import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.core.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.core.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.core.internal.deps.guava.collect.RegularImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.Sets;
import androidx.test.espresso.core.internal.deps.guava.collect.SingletonImmutableSet;
import androidx.test.espresso.core.internal.deps.guava.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList<E> asList;

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e) {
        SingletonImmutableSet<E> singletonImmutableSet = new SingletonImmutableSet<E>(e);
        return singletonImmutableSet;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static <E> ImmutableSet<E> construct(int var0, Object ... var1_3) {
        switch (var0) {
            default: {
                var6_4 = ImmutableSet.chooseTableSize(var0);
                var7_5 = new Object[var6_4];
                var8_6 = var6_4 + -1;
                var2_7 = 0;
                var3_8 = 0;
                block4: for (var4_9 = 0; var4_9 < var0; ++var4_9) {
                    var9_11 = ObjectArrays.checkElementNotNull(var1_3[var4_9], var4_9);
                    var10_12 = var9_11.hashCode();
                    var5_10 = Hashing.smear(var10_12);
                    while (true) {
                        if ((var12_14 = var7_5[var11_13 = var5_10 & var8_6]) == null) {
                            var5_10 = var3_8 + 1;
                            var1_3[var3_8] = var9_11;
                            var7_5[var11_13] = var9_11;
                            var2_7 += var10_12;
lbl18:
                            // 2 sources

                            while (true) {
                                var3_8 = var5_10;
                                continue block4;
                                break;
                            }
                        }
                        if (var12_14.equals(var9_11)) {
                            var5_10 = var3_8;
                            ** continue;
                        }
                        ++var5_10;
                    }
                }
                Arrays.fill(var1_3, var3_8, var0, null);
                if (var3_8 == 1) {
                    var0_1 = var1_3[0];
                    var1_3 = new SingletonImmutableSet(var0_1, var2_7);
                    return var1_3;
                }
                if (ImmutableSet.chooseTableSize(var3_8) < var6_4 / 2) {
                    return ImmutableSet.construct(var3_8, var1_3);
                }
                if (ImmutableSet.shouldTrim(var3_8, var1_3.length)) {
                    var0_2 = Arrays.copyOf(var1_3, var3_8);
lbl35:
                    // 2 sources

                    while (true) {
                        var1_3 = new RegularImmutableSet(var0_2, var2_7, var7_5, var8_6, var3_8);
                        return var1_3;
                    }
                }
                var0_2 = var1_3;
                ** continue;
            }
            case 1: {
                return ImmutableSet.of(var1_3[0]);
            }
            case 0: 
        }
        return ImmutableSet.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldTrim(int n, int n2) {
        if (n >= (n2 >> 1) + (n2 >> 2)) return 0 != 0;
        return 1 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int chooseTableSize(int n) {
        int n2 = Math.max(n, 2);
        if (n2 < 0x2CCCCCCC) {
            n = Integer.highestOneBit(n2 + -1);
            n += n;
            while (true) {
                if (!((double)n * 0.7 < (double)n2)) {
                    return n;
                }
                n += n;
            }
        }
        n = n2 < 0x40000000 ? 1 : 0;
        Preconditions.checkArgument(n != 0, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(E[] EArray) {
        switch (EArray.length) {
            default: {
                return ImmutableSet.construct(EArray.length, (Object[])EArray.clone());
            }
            case 1: {
                return ImmutableSet.of(EArray[0]);
            }
            case 0: 
        }
        return ImmutableSet.of();
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    public ImmutableList<E> asList() {
        ImmutableList<E> immutableList = this.asList;
        if (immutableList == null) {
            this.asList = immutableList = this.createAsList();
            return immutableList;
        }
        return immutableList;
    }

    ImmutableList<E> createAsList() {
        return ImmutableList.asImmutableList(this.toArray());
    }

    @Override
    Object writeReplace() {
        SerializedForm serializedForm = new SerializedForm(this.toArray());
        return serializedForm;
    }

    public static <E> Builder<E> builder() {
        Builder builder = new Builder();
        return builder;
    }

    public static class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        Object[] hashTable;
        private int hashCode;

        public Builder() {
            super(4);
        }

        @Override
        public Builder<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) <= this.hashTable.length) {
                this.addDeduping(e);
                return this;
            }
            this.hashTable = null;
            super.add(e);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Builder<E> add(E ... EArray) {
            if (this.hashTable != null) {
                int n = EArray.length;
                for (int i = 0; i < n; ++i) {
                    this.add(EArray[i]);
                }
                return this;
            }
            super.add(EArray);
            return this;
        }

        private void addDeduping(E e) {
            int n = this.hashTable.length + -1;
            int n2 = e.hashCode();
            int n3 = Hashing.smear(n2);
            while (true) {
                Object object;
                if ((object = this.hashTable[n3 &= n]) == null) {
                    this.hashTable[n3] = e;
                    this.hashCode += n2;
                    super.add(e);
                    return;
                }
                if (object.equals(e)) {
                    return;
                }
                ++n3;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public ImmutableSet<E> build() {
            switch (this.size) {
                default: {
                    void var1_4;
                    if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) == this.hashTable.length) {
                        void var1_2;
                        RegularImmutableSet regularImmutableSet;
                        if (ImmutableSet.shouldTrim(this.size, this.contents.length)) {
                            Object[] objectArray = Arrays.copyOf(this.contents, this.size);
                        } else {
                            Object[] objectArray = this.contents;
                        }
                        RegularImmutableSet regularImmutableSet2 = regularImmutableSet = new RegularImmutableSet((Object[])var1_2, this.hashCode, this.hashTable, this.hashTable.length + -1, this.size);
                    } else {
                        ImmutableSet immutableSet = ImmutableSet.construct(this.size, this.contents);
                        this.size = immutableSet.size();
                    }
                    this.forceCopy = true;
                    this.hashTable = null;
                    return var1_4;
                }
                case 1: {
                    return ImmutableSet.of(this.contents[0]);
                }
                case 0: 
            }
            return ImmutableSet.of();
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }
}

