/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Objects;
import androidx.test.espresso.core.internal.deps.guava.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> ofInstance(T t) {
        SupplierOfInstance<T> supplierOfInstance = new SupplierOfInstance<T>(t);
        return supplierOfInstance;
    }

    private static class SupplierOfInstance<T>
    implements Supplier<T>,
    Serializable {
        final T instance;
        private static final long serialVersionUID = 0L;

        SupplierOfInstance(T t) {
            this.instance = t;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public boolean equals(Object object) {
            if (object instanceof SupplierOfInstance) {
                object = (SupplierOfInstance)object;
                return Objects.equal(this.instance, ((SupplierOfInstance)object).instance);
            }
            return false;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.instance};
            return Objects.hashCode(objectArray);
        }

        public String toString() {
            String string = String.valueOf(((SupplierOfInstance)((Object)string)).instance);
            String string2 = String.valueOf(string);
            int n = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 22);
            return stringBuilder.append("Suppliers.ofInstance(").append(string).append(")").toString();
        }
    }
}

