/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.guava.base;

import androidx.test.espresso.core.internal.deps.guava.base.Platform;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Strings {
    public static String emptyToNull(String string) {
        return Platform.emptyToNull(string);
    }

    public static String padStart(String string, int n, char c) {
        Preconditions.checkNotNull(string);
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String lenientFormat(String objectArray, Object ... objectArray2) {
        String string = String.valueOf(objectArray);
        if (objectArray2 == null) {
            objectArray = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = Strings.lenientToString(objectArray2[i]);
            }
            objectArray = objectArray2;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + objectArray.length * 16);
        int n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= objectArray.length || (n3 = string.indexOf("%s", n)) == -1) {
                stringBuilder.append(string, n, string.length());
                if (n2 < objectArray.length) {
                    stringBuilder.append(" [");
                    n = n2 + 1;
                    stringBuilder.append(objectArray[n2]);
                    while (n < objectArray.length) {
                        stringBuilder.append(", ");
                        n2 = n + 1;
                        stringBuilder.append(objectArray[n]);
                        n = n2;
                    }
                    stringBuilder.append(']');
                }
                return stringBuilder.toString();
            }
            stringBuilder.append(string, n, n3);
            int n4 = n2 + 1;
            stringBuilder.append(objectArray[n2]);
            n = n3 + 2;
            n2 = n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String lenientToString(Object object) {
        if (object == null) {
            return "null";
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            String string = object.getClass().getName();
            object = Integer.toHexString(System.identityHashCode(object));
            String string2 = String.valueOf(string);
            int n = string2.length();
            String string3 = String.valueOf(object);
            int n2 = string3.length();
            CharSequence charSequence = new StringBuilder(n + 1 + n2);
            string = ((StringBuilder)charSequence).append(string).append('@').append((String)object).toString();
            Object object2 = Logger.getLogger("androidx.test.espresso.core.internal.deps.guava.base.Strings");
            Serializable serializable = Level.WARNING;
            object = String.valueOf(string);
            charSequence = "Exception during lenientFormat for ";
            object = ((String)object).length() != 0 ? ((String)charSequence).concat((String)object) : new String((String)charSequence);
            ((Logger)object2).logp((Level)serializable, "androidx.test.espresso.core.internal.deps.guava.base.Strings", "lenientToString", (String)object, exception);
            object = exception.getClass().getName();
            String string4 = String.valueOf(string);
            int n3 = string4.length();
            object2 = String.valueOf(object);
            int n4 = ((String)object2).length();
            serializable = new StringBuilder(n3 + 9 + n4);
            return ((StringBuilder)serializable).append("<").append(string).append(" threw ").append((String)object).append(">").toString();
        }
    }
}

