/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.core.internal.deps.desugar;

import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public final class ThrowableExtension {
    static final AbstractDesugaringStrategy STRATEGY;
    static final int API_LEVEL;

    public static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        STRATEGY.printStackTrace(throwable, printWriter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean useMimicStrategy() {
        if (Boolean.getBoolean("androidx.test.espresso.core.internal.deps.desugar.twr_disable_mimic")) return false;
        return true;
    }

    private static Integer readApiLevelFromBuildVersion() {
        try {
            Integer n = (Integer)Class.forName("android.os.Build$VERSION").getField("SDK_INT").get(null);
            return n;
        }
        catch (Exception exception) {
            System.err.println("Failed to retrieve value from android.os.Build$VERSION.SDK_INT due to the following exception.");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block11: {
            var1 = ThrowableExtension.readApiLevelFromBuildVersion();
            if (var1 == null) break block11;
            var0_1 = var1;
            if (var0_1 < 19) break block11;
            var0_2 = new ReuseDesugaringStrategy();
lbl9:
            // 4 sources

            while (true) {
                ThrowableExtension.STRATEGY = var0_2;
                if (var1 == null) {
                    var0_3 = 1;
lbl13:
                    // 2 sources

                    while (true) {
                        ThrowableExtension.API_LEVEL = var0_3;
                        return;
                    }
                }
                var0_3 = var1;
                ** continue;
                break;
            }
        }
        try {
            var0_1 = ThrowableExtension.useMimicStrategy();
            if (var0_1 == 0) ** GOTO lbl27
        }
        catch (Throwable var0_5) {
            ** continue;
        }
        var0_2 = new MimicDesugaringStrategy();
        ** GOTO lbl9
lbl27:
        // 1 sources

        var0_2 = new NullDesugaringStrategy();
        ** GOTO lbl9
        catch (Throwable var0_4) {
            var1 = null;
lbl31:
            // 2 sources

            while (true) {
                var2_6 = System.err;
                var3_7 = NullDesugaringStrategy.class.getName();
                var4_8 = String.valueOf(var3_7);
                var4_9 = var4_8.length();
                var5_10 = new StringBuilder(var4_9 + 133);
                var2_6.println(var5_10.append("An error has occurred when initializing the try-with-resources desuguring strategy. The default strategy ").append(var3_7).append("will be used. The error is: ").toString());
                var0_2.printStackTrace(System.err);
                var0_2 = new NullDesugaringStrategy();
                ** continue;
                break;
            }
        }
    }

    static final class NullDesugaringStrategy
    extends AbstractDesugaringStrategy {
        NullDesugaringStrategy() {
        }

        @Override
        public void printStackTrace(Throwable throwable, PrintWriter printWriter) {
            throwable.printStackTrace(printWriter);
        }
    }

    static final class ConcurrentWeakIdentityHashMap {
        private final ConcurrentHashMap<WeakKey, List<Throwable>> map;
        private final ReferenceQueue<Throwable> referenceQueue;

        ConcurrentWeakIdentityHashMap() {
            ReferenceQueue referenceQueue = new ReferenceQueue(16, 0.75f, 10);
            this.map = referenceQueue;
            referenceQueue = new ReferenceQueue();
            this.referenceQueue = referenceQueue;
        }

        public List<Throwable> get(Throwable throwable, boolean bl) {
            ((ConcurrentWeakIdentityHashMap)((Object)list)).deleteEmptyKeys();
            ConcurrentHashMap<WeakKey, List<Throwable>> concurrentHashMap = new ConcurrentHashMap<WeakKey, List<Throwable>>(throwable, null);
            concurrentHashMap = ((ConcurrentWeakIdentityHashMap)((Object)list)).map.get(concurrentHashMap);
            if (!bl) {
                return concurrentHashMap;
            }
            if (concurrentHashMap != null) {
                return concurrentHashMap;
            }
            concurrentHashMap = ((ConcurrentWeakIdentityHashMap)((Object)list)).map;
            WeakKey weakKey = new WeakKey(throwable, ((ConcurrentWeakIdentityHashMap)((Object)list)).referenceQueue);
            Vector<Throwable> vector = new Vector<Throwable>(2);
            List list = concurrentHashMap.putIfAbsent(weakKey, vector);
            if (list == null) {
                return vector;
            }
            return list;
        }

        void deleteEmptyKeys() {
            Reference<Throwable> reference = this.referenceQueue.poll();
            while (reference != null) {
                this.map.remove(reference);
                reference = this.referenceQueue.poll();
            }
        }

        private static final class WeakKey
        extends WeakReference<Throwable> {
            private final int hash;

            public WeakKey(Throwable throwable, ReferenceQueue<Throwable> referenceQueue) {
                super(throwable, referenceQueue);
                if (throwable == null) {
                    Object object = new NullPointerException("The referent cannot be null");
                    throw object;
                }
                ((WeakKey)object).hash = System.identityHashCode(throwable);
            }

            public int hashCode() {
                return this.hash;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object object) {
                if (object == null) return false;
                if (object.getClass() != this.getClass()) {
                    return false;
                }
                if (this == object) {
                    return true;
                }
                object = (WeakKey)object;
                if (this.hash != ((WeakKey)object).hash) return false;
                if (this.get() != ((Reference)object).get()) return false;
                return true;
            }
        }
    }

    static final class MimicDesugaringStrategy
    extends AbstractDesugaringStrategy {
        private final ConcurrentWeakIdentityHashMap map;

        MimicDesugaringStrategy() {
            ConcurrentWeakIdentityHashMap concurrentWeakIdentityHashMap;
            this.map = concurrentWeakIdentityHashMap = new ConcurrentWeakIdentityHashMap();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void printStackTrace(Throwable object, PrintWriter printWriter) {
            ((Throwable)object).printStackTrace(printWriter);
            List<Throwable> list = ((MimicDesugaringStrategy)((Object)list)).map.get((Throwable)object, false);
            if (list == null) {
                return;
            }
            synchronized (list) {
                boolean bl;
                object = list.iterator();
                while (bl = object.hasNext()) {
                    Object object2 = object.next();
                    object2 = (Throwable)object2;
                    printWriter.print("Suppressed: ");
                    ((Throwable)object2).printStackTrace(printWriter);
                }
                return;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
    }

    static final class ReuseDesugaringStrategy
    extends AbstractDesugaringStrategy {
        ReuseDesugaringStrategy() {
        }

        @Override
        public void printStackTrace(Throwable throwable, PrintWriter printWriter) {
            throwable.printStackTrace(printWriter);
        }
    }

    static abstract class AbstractDesugaringStrategy {
        protected static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];

        AbstractDesugaringStrategy() {
        }

        public abstract void printStackTrace(Throwable var1, PrintWriter var2);
    }
}

