/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.test.espresso.core.internal.deps.guava.base.Optional;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;

final class ThreadPoolExecutorExtractor {
    private static final String ASYNC_TASK_CLASS_NAME = "android.os.AsyncTask";
    private static final String MODERN_ASYNC_TASK_CLASS_NAME = "androidx.loader.content.ModernAsyncTask";
    private static final String MODERN_ASYNC_TASK_FIELD_NAME = "THREAD_POOL_EXECUTOR";
    private static final String LEGACY_ASYNC_TASK_FIELD_NAME = "sExecutor";
    private final Handler mainHandler;
    private static final Callable<Optional<ThreadPoolExecutor>> MODERN_ASYNC_TASK_EXTRACTOR;
    private static final Callable<Class<?>> LOAD_ASYNC_TASK_CLASS;
    private static final Callable<Optional<ThreadPoolExecutor>> LEGACY_ASYNC_TASK_EXECUTOR;
    private static final Callable<Optional<ThreadPoolExecutor>> POST_HONEYCOMB_ASYNC_TASK_EXECUTOR;

    /*
     * WARNING - void declaration
     */
    ThreadPoolExecutorExtractor(Looper looper) {
        void var1_1;
        Handler handler;
        this.mainHandler = handler = new Handler((Looper)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThreadPoolExecutor getAsyncTaskThreadPool() {
        Object object = Build.VERSION.SDK_INT < 11 ? new FutureTask(LEGACY_ASYNC_TASK_EXECUTOR) : new FutureTask(POST_HONEYCOMB_ASYNC_TASK_EXECUTOR);
        try {
            return ((ThreadPoolExecutorExtractor)this).runOnMainThread((FutureTask)object).get().get();
        }
        catch (ExecutionException executionException) {
            object = new RuntimeException(executionException.getCause());
            throw object;
        }
        catch (InterruptedException interruptedException) {
            object = new RuntimeException("Interrupted while trying to get the async task executor!", interruptedException);
            throw object;
        }
    }

    public Optional<ThreadPoolExecutor> getCompatAsyncTaskThreadPool() {
        try {
            FutureTask<Optional<ThreadPoolExecutor>> futureTask = new FutureTask<Optional<ThreadPoolExecutor>>(MODERN_ASYNC_TASK_EXTRACTOR);
            Optional<ThreadPoolExecutor> optional = ((ThreadPoolExecutorExtractor)((Object)optional)).runOnMainThread(futureTask).get();
        }
        catch (ExecutionException executionException) {
            RuntimeException runtimeException = new RuntimeException(executionException.getCause());
            throw runtimeException;
        }
        catch (InterruptedException interruptedException) {
            RuntimeException runtimeException = new RuntimeException("Interrupted while trying to get the compat async executor!", interruptedException);
            throw runtimeException;
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> FutureTask<T> runOnMainThread(FutureTask<T> futureToRun) {
        RuntimeException runtimeException;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            ((FutureTask)((Object)runtimeException)).run();
            return runtimeException;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Handler handler = this.mainHandler;
        Runnable runnable = new Runnable(this, (FutureTask)((Object)runtimeException), countDownLatch){
            final /* synthetic */ FutureTask val$futureToRun;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$futureToRun = futureTask;
                this.val$latch = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    this.val$futureToRun.run();
                }
                finally {
                    this.val$latch.countDown();
                }
            }
        };
        handler.post(runnable);
        try {
            countDownLatch.await();
            return runtimeException;
        }
        catch (InterruptedException interruptedException) {
            if (((FutureTask)((Object)runtimeException)).isDone()) return runtimeException;
        }
        runtimeException = new RuntimeException("Interrupted while waiting for task to complete.", interruptedException);
        throw runtimeException;
    }

    static {
        Callable<Optional<ThreadPoolExecutor>> callable;
        MODERN_ASYNC_TASK_EXTRACTOR = callable = new Callable<Optional<ThreadPoolExecutor>>(){

            @Override
            public Optional<ThreadPoolExecutor> call() throws Exception {
                try {
                    Optional<ThreadPoolExecutor> optional = Optional.of((ThreadPoolExecutor)Class.forName(ThreadPoolExecutorExtractor.MODERN_ASYNC_TASK_CLASS_NAME).getField(ThreadPoolExecutorExtractor.MODERN_ASYNC_TASK_FIELD_NAME).get(null));
                    return optional;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Optional.absent();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return Optional.absent();
                }
            }
        };
        LOAD_ASYNC_TASK_CLASS = callable = new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return Class.forName(ThreadPoolExecutorExtractor.ASYNC_TASK_CLASS_NAME);
            }
        };
        LEGACY_ASYNC_TASK_EXECUTOR = callable = new Callable<Optional<ThreadPoolExecutor>>(){

            @Override
            public Optional<ThreadPoolExecutor> call() throws Exception {
                try {
                    Optional<ThreadPoolExecutor> optional = ((Class)LOAD_ASYNC_TASK_CLASS.call()).getDeclaredField(ThreadPoolExecutorExtractor.LEGACY_ASYNC_TASK_FIELD_NAME);
                    ((Field)((Object)optional)).setAccessible(true);
                    optional = Optional.of((ThreadPoolExecutor)((Field)((Object)optional)).get(null));
                    return optional;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Optional.absent();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return Optional.absent();
                }
            }
        };
        POST_HONEYCOMB_ASYNC_TASK_EXECUTOR = callable = new Callable<Optional<ThreadPoolExecutor>>(){

            @Override
            public Optional<ThreadPoolExecutor> call() throws Exception {
                try {
                    Optional<ThreadPoolExecutor> optional = Optional.of((ThreadPoolExecutor)((Class)LOAD_ASYNC_TASK_CLASS.call()).getField(ThreadPoolExecutorExtractor.MODERN_ASYNC_TASK_FIELD_NAME).get(null));
                    return optional;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Optional.absent();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return Optional.absent();
                }
            }
        };
    }
}

