/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.base;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Throwables;
import androidx.test.espresso.internal.inject.TargetContext;
import androidx.test.internal.platform.util.TestOutputEmitter;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;

public final class DefaultFailureHandler
implements FailureHandler {
    private static final AtomicInteger failureCount;
    private final Context appContext;

    /*
     * WARNING - void declaration
     */
    public DefaultFailureHandler(@TargetContext Context appContext) {
        void var1_1;
        this.appContext = (Context)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(Throwable error, Matcher<View> viewMatcher) {
        void var2_2;
        void var1_1;
        int n = failureCount.incrementAndGet();
        StringBuilder stringBuilder = new StringBuilder(29);
        TestOutputEmitter.takeScreenshot((String)stringBuilder.append("view-op-error-").append(n).append(".png").toString());
        stringBuilder = new StringBuilder(40);
        TestOutputEmitter.captureWindowHierarchy((String)stringBuilder.append("explore-window-hierarchy-").append(n).append(".xml").toString());
        if (!(var1_1 instanceof EspressoException) && !(var1_1 instanceof AssertionFailedError)) {
            if (!(var1_1 instanceof AssertionError)) {
                Throwables.throwIfUnchecked((Throwable)var1_1);
                Object object = new RuntimeException((Throwable)var1_1);
                throw object;
            }
        }
        Throwables.throwIfUnchecked(((DefaultFailureHandler)object).getUserFriendlyError((Throwable)var1_1, (Matcher<View>)var2_2));
        RuntimeException runtimeException = new RuntimeException(((DefaultFailureHandler)object).getUserFriendlyError((Throwable)var1_1, (Matcher<View>)var2_2));
        throw runtimeException;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Throwable getUserFriendlyError(Throwable error, Matcher<View> viewMatcher) {
        void var1_1;
        Object object;
        if (error instanceof PerformException) {
            void var2_2;
            StringBuilder stringBuilder = new StringBuilder();
            if (!DefaultFailureHandler.isAnimationAndTransitionDisabled(((DefaultFailureHandler)object).appContext)) {
                stringBuilder.append("Animations or transitions are enabled on the target device.\nFor more info check: https://developer.android.com/training/testing/espresso/setup#set-up-environment\n\n");
            }
            stringBuilder.append(var2_2.toString());
            object = new PerformException.Builder();
            throw ((PerformException.Builder)object).from((PerformException)var1_1).withViewDescription(stringBuilder.toString()).build();
        }
        object = var1_1 instanceof AssertionError ? new AssertionFailedWithCauseError(var1_1.getMessage(), (Throwable)var1_1) : var1_1;
        ((Throwable)object).setStackTrace(Thread.currentThread().getStackTrace());
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAnimationAndTransitionDisabled(Context context) {
        Context context2 = context.getContentResolver();
        float f = DefaultFailureHandler.getTransitionAnimationScale((ContentResolver)context2);
        boolean bl = DefaultFailureHandler.isEqualToZero(f);
        boolean bl2 = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getWindowAnimationScale((ContentResolver)context2));
        boolean bl3 = DefaultFailureHandler.isEqualToZero(DefaultFailureHandler.getAnimatorDurationScale((ContentResolver)context2));
        if (!bl) return false;
        if (!bl2) return false;
        if (!bl3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isEqualToZero(float value) {
        if (Float.compare(Math.abs(value), 0.0f) != 0) return false;
        return true;
    }

    private static float getTransitionAnimationScale(ContentResolver resolver) {
        return DefaultFailureHandler.getSetting(resolver, "transition_animation_scale", "transition_animation_scale");
    }

    private static float getWindowAnimationScale(ContentResolver resolver) {
        return DefaultFailureHandler.getSetting(resolver, "window_animation_scale", "window_animation_scale");
    }

    private static float getAnimatorDurationScale(ContentResolver resolver) {
        if (DefaultFailureHandler.isJellyBeanMR1OrHigher()) {
            ContentResolver contentResolver;
            return DefaultFailureHandler.getSetting(contentResolver, "animator_duration_scale", "animator_duration_scale");
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private static float getSetting(ContentResolver resolver, String current, String deprecated) {
        void var2_2;
        ContentResolver contentResolver;
        if (DefaultFailureHandler.isJellyBeanMR1OrHigher()) {
            void var1_1;
            return DefaultFailureHandler.getGlobalSetting(contentResolver, (String)var1_1);
        }
        return DefaultFailureHandler.getSystemSetting(contentResolver, (String)var2_2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isJellyBeanMR1OrHigher() {
        if (Build.VERSION.SDK_INT < 17) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static float getGlobalSetting(ContentResolver resolver, String setting) {
        try {
            void var1_2;
            float f = Settings.Global.getFloat((ContentResolver)resolver, (String)var1_2);
            return f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float getSystemSetting(ContentResolver resolver, String setting) {
        try {
            void var1_2;
            float f = Settings.System.getFloat((ContentResolver)resolver, (String)var1_2);
            return f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return 0.0f;
        }
    }

    static {
        AtomicInteger atomicInteger;
        failureCount = atomicInteger = new AtomicInteger(0);
    }

    private static final class AssertionFailedWithCauseError
    extends AssertionFailedError {
        /*
         * WARNING - void declaration
         */
        public AssertionFailedWithCauseError(String message, Throwable cause) {
            super((String)var1_1);
            void var2_2;
            void var1_1;
            this.initCause((Throwable)var2_2);
        }
    }
}

