/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.CloseKeyboardAction;
import androidx.test.espresso.action.EditorAction;
import androidx.test.espresso.action.EspressoKey;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.GeneralLocation;
import androidx.test.espresso.action.GeneralSwipeAction;
import androidx.test.espresso.action.KeyEventAction;
import androidx.test.espresso.action.OpenLinkAction;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.PressBackAction;
import androidx.test.espresso.action.RepeatActionUntilViewState;
import androidx.test.espresso.action.ReplaceTextAction;
import androidx.test.espresso.action.ScrollToAction;
import androidx.test.espresso.action.Swipe;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.TypeTextAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ViewActions {
    private static final float EDGE_FUZZ_FACTOR = 0.083f;
    private static Set<Pair<String, ViewAssertion>> globalAssertions;

    private ViewActions() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void addGlobalAssertion(String name, ViewAssertion viewAssertion) {
        String string;
        void var1_1;
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(var1_1);
        Pair pair = new Pair((Object)string, (Object)var1_1);
        boolean bl = !globalAssertions.contains(pair);
        Preconditions.checkArgument(bl, "ViewAssertion with name %s is already in the global assertions!", string);
        globalAssertions.add((Pair<String, ViewAssertion>)pair);
    }

    public static void removeGlobalAssertion(ViewAssertion viewAssertion) {
        Iterator<Pair<String, ViewAssertion>> iterator = globalAssertions.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ViewAssertion viewAssertion2;
            Pair<String, ViewAssertion> pair = iterator.next();
            if (viewAssertion2 == null || !viewAssertion2.equals(pair.second)) continue;
            if (bl || globalAssertions.remove(pair)) {
                bl = true;
                continue;
            }
            bl = false;
        }
        Preconditions.checkArgument(bl, "ViewAssertion was not in global assertions!");
    }

    public static void clearGlobalAssertions() {
        globalAssertions.clear();
    }

    public static ViewAction actionWithAssertions(ViewAction viewAction) {
        ViewAction viewAction2;
        if (globalAssertions.isEmpty()) {
            return viewAction2;
        }
        ViewAction viewAction3 = new ViewAction(){

            @Override
            public String getDescription() {
                StringBuilder stringBuilder = new StringBuilder("Running view assertions[");
                Iterator iterator = globalAssertions.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)((Pair)iterator.next()).first);
                    stringBuilder.append(", ");
                }
                stringBuilder.append("] and then running: ");
                stringBuilder.append(viewAction2.getDescription());
                return stringBuilder.toString();
            }

            @Override
            public Matcher<View> getConstraints() {
                return viewAction2.getConstraints();
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            public void perform(UiController uic, View view) {
                Iterator iterator = globalAssertions.iterator();
                while (true) {
                    void var2_2;
                    if (!iterator.hasNext()) {
                        void var1_1;
                        viewAction2.perform((UiController)var1_1, (View)var2_2);
                        return;
                    }
                    Pair pair = (Pair)iterator.next();
                    String string = String.valueOf((String)pair.first);
                    String string2 = "Asserting ";
                    string = string.length() != 0 ? string2.concat(string) : new String(string2);
                    Log.i((String)"ViewAssertion", (String)string);
                    ((ViewAssertion)pair.second).check((View)var2_2, null);
                }
            }
        };
        return viewAction3;
    }

    public static ViewAction clearText() {
        ReplaceTextAction replaceTextAction = new ReplaceTextAction("");
        return ViewActions.actionWithAssertions(replaceTextAction);
    }

    /*
     * WARNING - void declaration
     */
    public static ViewAction click(int inputDevice, int buttonState) {
        void var1_2;
        int n;
        if (Build.VERSION.SDK_INT < 14) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            throw unsupportedOperationException;
        }
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, n, (int)var1_2);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction click() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.VISIBLE_CENTER, Press.FINGER, 0, 1);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction click(ViewAction rollbackAction) {
        ViewAction viewAction;
        Preconditions.checkNotNull(rollbackAction);
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.SINGLE, GeneralLocation.CENTER, Press.FINGER, 0, 1, viewAction);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction swipeLeft() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_RIGHT, -0.083f, 0.0f), GeneralLocation.CENTER_LEFT, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction swipeRight() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.CENTER_LEFT, 0.083f, 0.0f), GeneralLocation.CENTER_RIGHT, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction swipeDown() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.TOP_CENTER, 0.0f, 0.083f), GeneralLocation.BOTTOM_CENTER, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction swipeUp() {
        GeneralSwipeAction generalSwipeAction = new GeneralSwipeAction(Swipe.FAST, GeneralLocation.translate(GeneralLocation.BOTTOM_CENTER, 0.0f, -0.083f), GeneralLocation.TOP_CENTER, Press.FINGER);
        return ViewActions.actionWithAssertions(generalSwipeAction);
    }

    public static ViewAction closeSoftKeyboard() {
        CloseKeyboardAction closeKeyboardAction = new CloseKeyboardAction();
        return ViewActions.actionWithAssertions(closeKeyboardAction);
    }

    public static ViewAction pressImeActionButton() {
        EditorAction editorAction = new EditorAction();
        return ViewActions.actionWithAssertions(editorAction);
    }

    public static ViewAction pressBack() {
        PressBackAction pressBackAction = new PressBackAction(true);
        return ViewActions.actionWithAssertions(pressBackAction);
    }

    public static ViewAction pressBackUnconditionally() {
        PressBackAction pressBackAction = new PressBackAction(false);
        return ViewActions.actionWithAssertions(pressBackAction);
    }

    public static ViewAction pressMenuKey() {
        return ViewActions.pressKey(82);
    }

    public static ViewAction pressKey(int keyCode) {
        int n;
        EspressoKey.Builder builder = new EspressoKey.Builder();
        KeyEventAction keyEventAction = new KeyEventAction(builder.withKeyCode(n).build());
        return ViewActions.actionWithAssertions(keyEventAction);
    }

    public static ViewAction pressKey(EspressoKey key) {
        EspressoKey espressoKey;
        KeyEventAction keyEventAction = new KeyEventAction(espressoKey);
        return ViewActions.actionWithAssertions(keyEventAction);
    }

    public static ViewAction doubleClick() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.DOUBLE, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction longClick() {
        GeneralClickAction generalClickAction = new GeneralClickAction(Tap.LONG, GeneralLocation.CENTER, Press.FINGER, 0, 1);
        return ViewActions.actionWithAssertions(generalClickAction);
    }

    public static ViewAction scrollTo() {
        ScrollToAction scrollToAction = new ScrollToAction();
        return ViewActions.actionWithAssertions(scrollToAction);
    }

    public static ViewAction typeTextIntoFocusedView(String stringToBeTyped) {
        String string;
        TypeTextAction typeTextAction = new TypeTextAction(string, false);
        return ViewActions.actionWithAssertions(typeTextAction);
    }

    public static ViewAction typeText(String stringToBeTyped) {
        String string;
        TypeTextAction typeTextAction = new TypeTextAction(string);
        return ViewActions.actionWithAssertions(typeTextAction);
    }

    public static ViewAction replaceText(String stringToBeSet) {
        String string;
        ReplaceTextAction replaceTextAction = new ReplaceTextAction(string);
        return ViewActions.actionWithAssertions(replaceTextAction);
    }

    public static ViewAction openLinkWithText(String linkText) {
        return ViewActions.openLinkWithText((Matcher<String>)Matchers.is((Object)linkText));
    }

    public static ViewAction openLinkWithText(Matcher<String> linkTextMatcher) {
        return ViewActions.openLink(linkTextMatcher, (Matcher<Uri>)Matchers.any(Uri.class));
    }

    public static ViewAction openLinkWithUri(String uri) {
        return ViewActions.openLinkWithUri((Matcher<Uri>)Matchers.is((Object)Uri.parse((String)uri)));
    }

    public static ViewAction openLinkWithUri(Matcher<Uri> uriMatcher) {
        Matcher<Uri> matcher;
        return ViewActions.openLink((Matcher<String>)Matchers.any(String.class), matcher);
    }

    /*
     * WARNING - void declaration
     */
    public static ViewAction openLink(Matcher<String> linkTextMatcher, Matcher<Uri> uriMatcher) {
        Matcher<String> matcher;
        void var1_1;
        Preconditions.checkNotNull(linkTextMatcher);
        Preconditions.checkNotNull(var1_1);
        OpenLinkAction openLinkAction = new OpenLinkAction(matcher, (Matcher<Uri>)var1_1);
        return ViewActions.actionWithAssertions(openLinkAction);
    }

    /*
     * WARNING - void declaration
     */
    public static ViewAction repeatedlyUntil(ViewAction action, Matcher<View> desiredStateMatcher, int maxAttempts) {
        void var2_2;
        ViewAction viewAction;
        void var1_1;
        Preconditions.checkNotNull(action);
        Preconditions.checkNotNull(var1_1);
        RepeatActionUntilViewState repeatActionUntilViewState = new RepeatActionUntilViewState(viewAction, (Matcher<View>)var1_1, (int)var2_2);
        return ViewActions.actionWithAssertions(repeatActionUntilViewState);
    }

    static {
        CopyOnWriteArraySet<Pair<String, ViewAssertion>> copyOnWriteArraySet = new CopyOnWriteArraySet<Pair<String, ViewAssertion>>();
        globalAssertions = copyOnWriteArraySet;
    }
}

