/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.widget.HorizontalScrollView;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ScrollToAction
implements ViewAction {
    private static final String TAG = ScrollToAction.class.getSimpleName();

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.allOf(ViewMatchers.withEffectiveVisibility(ViewMatchers.Visibility.VISIBLE), ViewMatchers.isDescendantOfA((Matcher<View>)Matchers.anyOf(ViewMatchers.isAssignableFrom(ScrollView.class), ViewMatchers.isAssignableFrom(HorizontalScrollView.class), ViewMatchers.isAssignableFrom(ListView.class))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void perform(UiController uiController, View view) {
        Object object;
        void var2_2;
        if (ViewMatchers.isDisplayingAtLeast(90).matches((Object)var2_2)) {
            Log.i((String)TAG, (String)"View is already displayed. Returning.");
            return;
        }
        Rect rect = new Rect();
        var2_2.getDrawingRect(rect);
        if (!var2_2.requestRectangleOnScreen(rect, true)) {
            Log.w((String)TAG, (String)"Scrolling to view was requested, but none of the parents scrolled.");
        }
        object.loopMainThreadUntilIdle();
        if (!ViewMatchers.isDisplayingAtLeast(90).matches((Object)var2_2)) {
            object = new PerformException.Builder();
            Object object2 = ((ScrollToAction)object2).getDescription();
            object2 = ((PerformException.Builder)object).withActionDescription((String)object2);
            object = HumanReadables.describe((View)var2_2);
            object2 = ((PerformException.Builder)object2).withViewDescription((String)object);
            object = new RuntimeException("Scrolling to view was attempted, but the view is not displayed");
            throw ((PerformException.Builder)object2).withCause((Throwable)object).build();
        }
    }

    @Override
    public String getDescription() {
        return "scroll to";
    }
}

