/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.InjectEventSecurityException;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import java.util.Locale;

public final class MotionEvents {
    private static final String TAG = MotionEvents.class.getSimpleName();
    static final int MAX_CLICK_ATTEMPTS = 3;

    private MotionEvents() {
    }

    /*
     * WARNING - void declaration
     */
    public static DownResultHolder sendDown(UiController uiController, float[] coordinates, float[] precision) {
        void var2_2;
        void var1_1;
        return MotionEvents.sendDown(uiController, (float[])var1_1, (float[])var2_2, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainDownEvent(float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        void var3_3;
        void var2_2;
        float[] fArray;
        void var1_1;
        Preconditions.checkNotNull(coordinates);
        Preconditions.checkNotNull(var1_1);
        long l = SystemClock.uptimeMillis();
        if (Build.VERSION.SDK_INT < 14) {
            return MotionEvents.downPressGingerBread(l, fArray, (float[])var1_1);
        }
        return MotionEvents.downPressICS(l, fArray, (float[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainDownEvent(float[] coordinates, float[] precision) {
        void var1_1;
        return MotionEvents.obtainDownEvent(coordinates, (float[])var1_1, 0, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DownResultHolder sendDown(UiController uiController, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        Preconditions.checkNotNull(uiController);
        Preconditions.checkNotNull(var1_2);
        Preconditions.checkNotNull(var2_3);
        var5_6 = 0;
        block5: while (true) {
            if (var5_6 >= 3) {
                var0 = new PerformException.Builder();
                var1_2 = Locale.ROOT;
                var2_3 = new Object[]{3};
                throw var0.withActionDescription(String.format((Locale)var1_2, "click (after %s attempts)", var2_3)).withViewDescription("unknown").build();
            }
            try {
                var7_8 = MotionEvents.obtainDownEvent((float[])var1_2, (float[])var2_3, (int)var3_4, (int)var4_5);
                var8_9 = var7_8.getDownTime();
                var6_7 = ViewConfiguration.getTapTimeout() / 2;
                var10_10 = var8_9 + (long)var6_7;
                var12_11 = var0.injectMotionEvent(var7_8);
lbl20:
                // 2 sources

                while (true) {
                    var13_12 = SystemClock.uptimeMillis();
                    var15_13 = var10_10 - var13_12;
                    if (var15_13 > 10L) break block5;
                    break;
                }
            }
            catch (InjectEventSecurityException var0_1) {
                var1_2 = new PerformException.Builder();
                throw var1_2.withActionDescription("Send down motion event").withViewDescription("unknown").withCause((Throwable)var0_1).build();
            }
            {
                var13_12 = SystemClock.uptimeMillis();
                var6_7 = ViewConfiguration.getLongPressTimeout();
                if (var13_12 > var8_9 + (long)var6_7) {
                    Log.w((String)MotionEvents.TAG, (String)"Overslept and turned a tap into a long press");
                    var6_7 = true;
                } else {
                    var6_7 = false;
                }
                if (var12_11 != false) return new DownResultHolder(var7_8, var6_7);
                var7_8.recycle();
                ++var5_6;
                continue;
            }
            break;
        }
        {
            var0.loopMainThreadForAtLeast(var15_13 / 4L);
            ** continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sendUp(UiController uiController, MotionEvent downEvent) {
        UiController uiController2;
        void var1_1;
        float[] fArray = new float[]{var1_1.getX(), var1_1.getY()};
        return MotionEvents.sendUp(uiController2, (MotionEvent)var1_1, fArray);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainUpEvent(MotionEvent downEvent, float[] coordinates) {
        MotionEvent motionEvent;
        void var1_1;
        Preconditions.checkNotNull(downEvent);
        Preconditions.checkNotNull(var1_1);
        if (Build.VERSION.SDK_INT < 14) {
            return MotionEvents.upPressGingerBread(motionEvent, (float[])var1_1);
        }
        return MotionEvents.upPressICS(motionEvent, (float[])var1_1);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sendUp(UiController uiController, MotionEvent downEvent, float[] coordinates) {
        block13: {
            block14: {
                Preconditions.checkNotNull(uiController);
                Preconditions.checkNotNull(var1_10);
                Preconditions.checkNotNull(var2_11);
                var2_11 = MotionEvents.obtainUpEvent(var1_10, (float[])var2_11);
                var0_1 = var0.injectMotionEvent(var2_11);
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of up event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_11;
                    ** GOTO lbl36
                }
                var2_11.recycle();
            }
            return false;
        }
        if (var2_11 != null) {
            var2_11.recycle();
        }
        return true;
        catch (InjectEventSecurityException var0_3) {
            var2_11 = null;
lbl28:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10};
                throw var3_13.withActionDescription(String.format(var4_15, "inject up event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl36:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_11;
                ** continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void sendCancel(UiController uiController, MotionEvent downEvent) {
        block13: {
            block14: {
                Preconditions.checkNotNull(uiController);
                Preconditions.checkNotNull(var1_10);
                var3_11 = var1_10.getDownTime();
                var5_12 = SystemClock.uptimeMillis();
                var2_13 = MotionEvent.obtain((long)var3_11, (long)var5_12, (int)3, (float)var1_10.getX(), (float)var1_10.getY(), (int)0);
                var0_1 = var0.injectMotionEvent(var2_13);
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var7_14 = Locale.ROOT;
                    var8_16 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var7_14, "Injection of cancel event failed (corresponding down event: %s)", var8_16));
                    if (var2_13 == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_13;
                    ** GOTO lbl38
                }
                var2_13.recycle();
                return;
            }
            return;
        }
        if (var2_13 != null) {
            var2_13.recycle();
            return;
        }
        return;
        catch (InjectEventSecurityException var0_3) {
            var2_13 = null;
lbl30:
            // 2 sources

            while (true) {
                var7_15 = new PerformException.Builder();
                var8_17 = Locale.ROOT;
                var9_18 = new Object[]{var1_10};
                throw var7_15.withActionDescription(String.format(var8_17, "inject cancel event (corresponding down event: %s)", var9_18)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl38:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_13;
                ** continue;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainMovement(long downTime, float[] coordinates) {
        void var2_1;
        return MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)2, (float)var2_1[0], (float)var2_1[1], (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public static MotionEvent obtainMovement(long downTime, long eventTime, float[] coordinates) {
        void var4_1;
        void var2_2;
        return MotionEvent.obtain((long)downTime, (long)var2_2, (int)2, (float)var4_1[0], (float)var4_1[1], (int)0);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sendMovement(UiController uiController, MotionEvent downEvent, float[] coordinates) {
        block13: {
            block14: {
                Preconditions.checkNotNull(uiController);
                Preconditions.checkNotNull(var1_10);
                Preconditions.checkNotNull(var2_11);
                var2_11 = MotionEvents.obtainMovement(var1_10.getDownTime(), (float[])var2_11);
                var0_1 = var0.injectMotionEvent(var2_11);
                if (var0_1) break block13;
                try {
                    var0_2 = MotionEvents.TAG;
                    var3_12 = Locale.ROOT;
                    var4_14 = new Object[]{var1_10};
                    Log.e((String)var0_2, (String)String.format(var3_12, "Injection of motion event failed (corresponding down event: %s)", var4_14));
                    if (var2_11 == null) break block14;
                }
                catch (InjectEventSecurityException var0_7) {
                    ** continue;
                }
                catch (Throwable var0_8) {
                    var1_10 = var2_11;
                    ** GOTO lbl36
                }
                var2_11.recycle();
            }
            return false;
        }
        if (var2_11 != null) {
            var2_11.recycle();
        }
        return true;
        catch (InjectEventSecurityException var0_3) {
            var2_11 = null;
lbl28:
            // 2 sources

            while (true) {
                var3_13 = new PerformException.Builder();
                var4_15 = Locale.ROOT;
                var5_16 = new Object[]{var1_10};
                throw var3_13.withActionDescription(String.format(var4_15, "inject motion event (corresponding down event: %s)", var5_16)).withViewDescription("unknown").withCause((Throwable)var0_4).build();
                break;
            }
        }
        catch (Throwable var0_5) {
            var1_10 = null;
lbl36:
            // 3 sources

            while (true) {
                if (var1_10 != null) {
                    var1_10.recycle();
                }
                throw var0_6;
            }
        }
        {
            catch (Throwable var0_9) {
                var1_10 = var2_11;
                ** continue;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent downPressGingerBread(long downTime, float[] coordinates, float[] precision) {
        void var3_2;
        void var2_1;
        return MotionEvent.obtain((long)downTime, (long)SystemClock.uptimeMillis(), (int)0, (float)var2_1[0], (float)var2_1[1], (float)0.0f, (float)1.0f, (int)0, (float)var3_2[0], (float)var3_2[1], (int)0, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent downPressICS(long downTime, float[] coordinates, float[] precision, int inputDevice, int buttonState) {
        void var3_2;
        void var5_4;
        long l;
        void var2_1;
        void var4_3;
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerCoords();
        pointerCoordsArray[0] = pointerPropertiesArray;
        pointerPropertiesArray = MotionEvents.getPointerProperties((int)var4_3);
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = var2_1[0];
        pointerCoordsArray[0].y = var2_1[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)l, (long)SystemClock.uptimeMillis(), (int)0, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)var5_4, (float)var3_2[0], (float)var3_2[1], (int)0, (int)0, (int)var4_3, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent upPressGingerBread(MotionEvent downEvent, float[] coordinates) {
        void var1_1;
        return MotionEvent.obtain((long)downEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)1, (float)var1_1[0], (float)var1_1[1], (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private static MotionEvent upPressICS(MotionEvent downEvent, float[] coordinates) {
        void var1_1;
        MotionEvent motionEvent;
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[]{pointerCoords};
        int n = motionEvent.getSource();
        MotionEvent.PointerProperties[] pointerPropertiesArray = MotionEvents.getPointerProperties(n);
        pointerCoordsArray[0].clear();
        pointerCoordsArray[0].x = var1_1[0];
        pointerCoordsArray[0].y = var1_1[1];
        pointerCoordsArray[0].pressure = 0.0f;
        pointerCoordsArray[0].size = 1.0f;
        return MotionEvent.obtain((long)motionEvent.getDownTime(), (long)SystemClock.uptimeMillis(), (int)1, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray, (int)0, (int)motionEvent.getButtonState(), (float)motionEvent.getXPrecision(), (float)motionEvent.getYPrecision(), (int)0, (int)0, (int)motionEvent.getSource(), (int)0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MotionEvent.PointerProperties[] getPointerProperties(int inputDevice) {
        int n;
        MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[]{pointerProperties};
        pointerPropertiesArray[0].clear();
        pointerPropertiesArray[0].id = 0;
        switch (n) {
            default: {
                pointerPropertiesArray[0].toolType = 0;
                return pointerPropertiesArray;
            }
            case 16386: {
                pointerPropertiesArray[0].toolType = 2;
                return pointerPropertiesArray;
            }
            case 8194: {
                pointerPropertiesArray[0].toolType = 3;
                return pointerPropertiesArray;
            }
            case 4098: 
        }
        pointerPropertiesArray[0].toolType = 1;
        return pointerPropertiesArray;
    }

    public static class DownResultHolder {
        public final MotionEvent down;
        public final boolean longPress;

        /*
         * WARNING - void declaration
         */
        DownResultHolder(MotionEvent down, boolean longPress) {
            void var2_2;
            void var1_1;
            this.down = var1_1;
            this.longPress = var2_2;
        }
    }
}

