/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Swiper;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.HumanReadables;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class GeneralSwipeAction
implements ViewAction {
    private static final int MAX_TRIES = 3;
    private static final int VIEW_DISPLAY_PERCENTAGE = 90;
    final CoordinatesProvider startCoordinatesProvider;
    final CoordinatesProvider endCoordinatesProvider;
    final Swiper swiper;
    final PrecisionDescriber precisionDescriber;

    /*
     * WARNING - void declaration
     */
    public GeneralSwipeAction(Swiper swiper, CoordinatesProvider startCoordinatesProvider, CoordinatesProvider endCoordinatesProvider, PrecisionDescriber precisionDescriber) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        this.swiper = var1_1;
        this.startCoordinatesProvider = var2_2;
        this.endCoordinatesProvider = var3_3;
        this.precisionDescriber = var4_4;
    }

    @Override
    public Matcher<View> getConstraints() {
        return ViewMatchers.isDisplayingAtLeast(90);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void perform(UiController uiController, View view) {
        PerformException.Builder builder;
        Object object;
        float[] fArray = this.startCoordinatesProvider.calculateCoordinates((View)object);
        float[] fArray2 = this.endCoordinatesProvider.calculateCoordinates((View)object);
        float[] fArray3 = this.precisionDescriber.describePrecision();
        Object object2 = Swiper.Status.FAILURE;
        for (int i = 0; i < 3 && object2 != Swiper.Status.SUCCESS; ++i) {
            try {
                object2 = this.swiper.sendSwipe((UiController)((Object)builder), fArray, fArray2, fArray3);
            }
            catch (RuntimeException runtimeException) {
                object2 = new PerformException.Builder();
                throw ((PerformException.Builder)object2).withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)object)).withCause(runtimeException).build();
            }
            int n = ViewConfiguration.getPressedStateDuration();
            if (n <= 0) continue;
            builder.loopMainThreadForAtLeast(n);
        }
        if (object2 == Swiper.Status.FAILURE) {
            builder = new PerformException.Builder();
            object2 = this.getDescription();
            builder = builder.withActionDescription((String)object2);
            object = HumanReadables.describe((View)object);
            builder = builder.withViewDescription((String)object);
            object2 = Locale.ROOT;
            Object[] objectArray = new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray2[0]), Float.valueOf(fArray2[1]), Float.valueOf(fArray3[0]), Float.valueOf(fArray3[1]), this.swiper, this.startCoordinatesProvider, this.precisionDescriber, 3};
            object = new RuntimeException(String.format((Locale)object2, "Couldn't swipe from: %s,%s to: %s,%s precision: %s, %s . Swiper: %s start coordinate provider: %s precision describer: %s. Tried %s times", objectArray));
            throw builder.withCause((Throwable)object).build();
        }
    }

    @Override
    public String getDescription() {
        return String.valueOf(this.swiper.toString().toLowerCase()).concat(" swipe");
    }
}

