/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.util.HumanReadables;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class CloseKeyboardAction
implements ViewAction {
    private static final int NUM_RETRIES = 3;
    private static final String TAG = CloseKeyboardAction.class.getSimpleName();

    @RemoteMsgConstructor
    public CloseKeyboardAction() {
    }

    @Override
    public Matcher<View> getConstraints() {
        return Matchers.any(View.class);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void perform(UiController uiController, View view) {
        int n = 0;
        while (n < 3) {
            PerformException.Builder builder;
            void var2_2;
            try {
                this.tryToCloseKeyboard((View)var2_2, (UiController)((Object)builder));
                return;
            }
            catch (TimeoutException timeoutException) {
                Log.w((String)TAG, (String)"Caught timeout exception. Retrying.");
                if (n == 2) {
                    builder = new PerformException.Builder();
                    throw builder.withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)var2_2)).withCause(timeoutException).build();
                }
                ++n;
            }
        }
    }

    private void tryToCloseKeyboard(View view, UiController uiController) throws TimeoutException {
        Object object;
        Object object2;
        CloseKeyboardIdlingResult closeKeyboardIdlingResult;
        block7: {
            IdlingResource[] idlingResourceArray;
            block6: {
                InputMethodManager inputMethodManager = (InputMethodManager)CloseKeyboardAction.getRootActivity(uiController).getSystemService("input_method");
                Handler handler = new Handler(Looper.getMainLooper());
                closeKeyboardIdlingResult = new CloseKeyboardIdlingResult(handler);
                handler = IdlingRegistry.getInstance();
                IdlingResource[] idlingResourceArray2 = new IdlingResource[]{closeKeyboardIdlingResult};
                handler.register(idlingResourceArray2);
                try {
                    boolean bl = inputMethodManager.hideSoftInputFromWindow(object2.getWindowToken(), 0, (ResultReceiver)closeKeyboardIdlingResult);
                    if (bl) break block6;
                }
                catch (Throwable throwable) {
                    object2 = IdlingRegistry.getInstance();
                    idlingResourceArray = new IdlingResource[]{closeKeyboardIdlingResult};
                    object2.unregister(idlingResourceArray);
                    throw throwable;
                }
                Log.w((String)TAG, (String)"Attempting to close soft keyboard, while it is not shown.");
                object = IdlingRegistry.getInstance();
                object2 = new IdlingResource[]{closeKeyboardIdlingResult};
                object.unregister(object2);
                return;
            }
            CloseKeyboardIdlingResult.access$100(closeKeyboardIdlingResult, 2000L);
            idlingResourceArray.loopMainThreadUntilIdle();
            boolean bl = closeKeyboardIdlingResult.timedOut;
            if (!bl) break block7;
            object = new TimeoutException("Wait on operation result timed out.");
            throw object;
        }
        IdlingRegistry idlingRegistry = IdlingRegistry.getInstance();
        Object object3 = new IdlingResource[]{closeKeyboardIdlingResult};
        idlingRegistry.unregister((IdlingResource[])object3);
        if (closeKeyboardIdlingResult.result != 1 && closeKeyboardIdlingResult.result != 3) {
            int n = closeKeyboardIdlingResult.result;
            object3 = new StringBuilder(105);
            String string = ((StringBuilder)object3).append("Attempt to close the soft keyboard did not result in soft keyboard to be hidden. resultCode = ").append(n).toString();
            Log.e((String)TAG, (String)string);
            object3 = new PerformException.Builder();
            object = ((CloseKeyboardAction)object).getDescription();
            object = ((PerformException.Builder)object3).withActionDescription((String)object);
            object2 = HumanReadables.describe((View)object2);
            object = ((PerformException.Builder)object).withViewDescription((String)object2);
            object2 = new RuntimeException(string);
            throw ((PerformException.Builder)object).withCause((Throwable)object2).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Activity getRootActivity(UiController uiController) {
        Object object;
        Collection collection = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        if (collection.isEmpty()) {
            object.loopMainThreadUntilIdle();
            object = ActivityLifecycleMonitorRegistry.getInstance().getActivitiesInStage(Stage.RESUMED);
        } else {
            object = collection;
        }
        boolean bl = object.size() == 1;
        Preconditions.checkState(bl, "More than one activity is in RESUMED stage. There may have been an error during the activity creation/startup process, please check your logs.");
        return (Activity)Iterables.getOnlyElement(object);
    }

    @Override
    public String getDescription() {
        return "close keyboard";
    }

    private static class CloseKeyboardIdlingResult
    extends ResultReceiver
    implements IdlingResource {
        private IdlingResource.ResourceCallback resourceCallback;
        private boolean receivedResult = false;
        private int result = -1;
        private boolean timedOut = false;
        private boolean idle = false;
        private final Handler handler;

        /*
         * WARNING - void declaration
         */
        private CloseKeyboardIdlingResult(Handler h) {
            super((Handler)var1_1);
            void var1_1;
            this.handler = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void scheduleTimeout(long millis) {
            void var1_1;
            Handler handler = this.handler;
            Runnable runnable = new Runnable(this){
                final /* synthetic */ CloseKeyboardIdlingResult this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    if (!this.this$0.receivedResult) {
                        CloseKeyboardIdlingResult.access$202(this.this$0, true);
                        if (this.this$0.resourceCallback != null) {
                            this.this$0.resourceCallback.onTransitionToIdle();
                            return;
                        }
                    }
                }
            };
            handler.postDelayed(runnable, (long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void notifyEspresso(long millis) {
            void var1_1;
            Preconditions.checkState(this.receivedResult);
            Handler handler = this.handler;
            Runnable runnable = new Runnable(this){
                final /* synthetic */ CloseKeyboardIdlingResult this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    CloseKeyboardIdlingResult.access$602(this.this$0, true);
                    if (this.this$0.resourceCallback != null) {
                        this.this$0.resourceCallback.onTransitionToIdle();
                        return;
                    }
                }
            };
            handler.postDelayed(runnable, (long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected void onReceiveResult(int resultCode, Bundle bundle) {
            void var1_1;
            this.result = var1_1;
            this.receivedResult = true;
            this.notifyEspresso(300L);
        }

        public String getName() {
            return "CloseKeyboardIdlingResource";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isIdleNow() {
            if (this.idle) return true;
            if (!this.timedOut) return false;
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
            void var1_1;
            this.resourceCallback = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$100(CloseKeyboardIdlingResult x0, long x1) {
            void var1_1;
            x0.scheduleTimeout((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$202(CloseKeyboardIdlingResult x0, boolean x1) {
            void var1_1;
            x0.timedOut = var1_1;
            return (boolean)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$602(CloseKeyboardIdlingResult x0, boolean x1) {
            void var1_1;
            x0.idle = var1_1;
            return (boolean)var1_1;
        }
    }
}

