/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.action;

import android.database.Cursor;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.AdapterViewFlipper;
import androidx.test.espresso.action.AdapterViewProtocol;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.core.internal.deps.guava.collect.Range;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.EspressoOptional;
import java.util.ArrayList;

public final class AdapterViewProtocols {
    private static final int FULLY_RENDERED_PERCENTAGE_CUTOFF = 90;
    private static final AdapterViewProtocol STANDARD_PROTOCOL;

    private AdapterViewProtocols() {
    }

    public static AdapterViewProtocol standardProtocol() {
        return STANDARD_PROTOCOL;
    }

    static {
        StandardAdapterViewProtocol standardAdapterViewProtocol = new StandardAdapterViewProtocol();
        STANDARD_PROTOCOL = standardAdapterViewProtocol;
    }

    private static final class StandardAdapterViewProtocol
    implements AdapterViewProtocol {
        private static final String TAG = "StdAdapterViewProtocol";

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterable<AdapterViewProtocol.AdaptedData> getDataInAdapterView(AdapterView<? extends Adapter> adapterView) {
            void var1_2;
            ArrayList<AdapterViewProtocol.AdaptedData> arrayList = Lists.newArrayList();
            for (int i = 0; i < var1_2.getCount(); ++i) {
                Object object = var1_2.getItemAtPosition(i);
                AdapterViewProtocol.AdaptedData.Builder builder = new AdapterViewProtocol.AdaptedData.Builder();
                StandardDataFunction standardDataFunction = new StandardDataFunction(object, i);
                arrayList.add(builder.withDataFunction(standardDataFunction).withOpaqueToken(i).build());
            }
            return arrayList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public EspressoOptional<AdapterViewProtocol.AdaptedData> getDataRenderedByView(AdapterView<? extends Adapter> adapterView, View descendantView) {
            void var1_2;
            int n;
            AdapterViewProtocol.AdaptedData.Builder builder;
            if (adapterView == builder.getParent() && (n = var1_2.getPositionForView((View)builder)) != -1) {
                builder = new AdapterViewProtocol.AdaptedData.Builder();
                StandardDataFunction standardDataFunction = new StandardDataFunction(var1_2.getItemAtPosition(n), n);
                return EspressoOptional.of(builder.withDataFunction(standardDataFunction).withOpaqueToken(n).build());
            }
            return EspressoOptional.absent();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public void makeDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData data) {
            boolean bl;
            void var1_2;
            void var2_3;
            Preconditions.checkArgument(data.opaqueToken instanceof Integer, "Not my data: %s", var2_3);
            int n = (Integer)var2_3.opaqueToken;
            if (Build.VERSION.SDK_INT > 7) {
                if (var1_2 instanceof AbsListView) {
                    if (Build.VERSION.SDK_INT > 10) {
                        ((AbsListView)var1_2).smoothScrollToPositionFromTop(n, var1_2.getPaddingTop(), 0);
                    } else {
                        ((AbsListView)var1_2).smoothScrollToPosition(n);
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                if (Build.VERSION.SDK_INT > 10 && var1_2 instanceof AdapterViewAnimator) {
                    if (var1_2 instanceof AdapterViewFlipper) {
                        ((AdapterViewFlipper)var1_2).stopFlipping();
                    }
                    ((AdapterViewAnimator)var1_2).setDisplayedChild(n);
                    return;
                }
            } else {
                bl = false;
            }
            if (bl) return;
            var1_2.setSelection(n);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isDataRenderedWithinAdapterView(AdapterView<? extends Adapter> adapterView, AdapterViewProtocol.AdaptedData adaptedData) {
            void var1_2;
            void var2_3;
            Preconditions.checkArgument(adaptedData.opaqueToken instanceof Integer, "Not my data: %s", var2_3);
            int n = (Integer)var2_3.opaqueToken;
            if (!Range.closed(var1_2.getFirstVisiblePosition(), var1_2.getLastVisiblePosition()).contains(n)) return false;
            boolean bl = var1_2.getFirstVisiblePosition() == var1_2.getLastVisiblePosition() ? true : this.isElementFullyRendered((AdapterView<? extends Adapter>)var1_2, n - var1_2.getFirstVisiblePosition());
            if (!bl) return bl;
            var1_2.setSelection(n);
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private boolean isElementFullyRendered(AdapterView<? extends Adapter> adapterView, int childAt) {
            void var2_2;
            StandardAdapterViewProtocol standardAdapterViewProtocol = adapterView.getChildAt((int)var2_2);
            return ViewMatchers.isDisplayingAtLeast(90).matches((Object)standardAdapterViewProtocol);
        }

        private static final class StandardDataFunction
        implements AdapterViewProtocol.DataFunction {
            private final Object dataAtPosition;
            private final int position;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            private StandardDataFunction(Object dataAtPosition, int position) {
                void var1_1;
                void var2_2;
                boolean bl = var2_2 >= 0;
                Preconditions.checkArgument(bl, "position must be >= 0");
                this.dataAtPosition = var1_1;
                this.position = var2_2;
            }

            @Override
            public Object getData() {
                if (this.dataAtPosition instanceof Cursor && !((Cursor)this.dataAtPosition).moveToPosition(this.position)) {
                    int n = this.position;
                    StringBuilder stringBuilder = new StringBuilder(43);
                    Log.e((String)StandardAdapterViewProtocol.TAG, (String)stringBuilder.append("Cannot move cursor to position: ").append(n).toString());
                }
                return this.dataAtPosition;
            }
        }
    }
}

