/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.view.View;
import androidx.test.espresso.EspressoException;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.collect.Lists;
import androidx.test.espresso.util.EspressoOptional;
import androidx.test.espresso.util.HumanReadables;
import java.util.List;
import java.util.Locale;
import org.hamcrest.Matcher;

public final class NoMatchingViewException
extends RuntimeException
implements EspressoException {
    private Matcher<? super View> viewMatcher;
    private View rootView;
    private List<View> adapterViews = Lists.newArrayList();
    private boolean includeViewHierarchy = true;
    private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();

    /*
     * WARNING - void declaration
     */
    private NoMatchingViewException(String description) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private NoMatchingViewException(Builder builder) {
        super(NoMatchingViewException.getErrorMessage((Builder)var1_1), ((Builder)var1_1).cause);
        void var1_1;
        this.viewMatcher = ((Builder)var1_1).viewMatcher;
        this.rootView = ((Builder)var1_1).rootView;
        this.adapterViews = ((Builder)var1_1).adapterViews;
        this.adapterViewWarning = ((Builder)var1_1).adapterViewWarning;
        this.includeViewHierarchy = ((Builder)var1_1).includeViewHierarchy;
    }

    public String getViewMatcherDescription() {
        if (this.viewMatcher != null) {
            return this.viewMatcher.toString();
        }
        return "unknown";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getErrorMessage(Builder builder) {
        Object object;
        if (builder.includeViewHierarchy) {
            Object object2 = Locale.ROOT;
            Object object3 = new Object[]{((Builder)object).viewMatcher};
            object2 = String.format((Locale)object2, "No views in hierarchy found matching: %s", (Object[])object3);
            if (!((Builder)object).adapterViewWarning.isPresent()) return HumanReadables.getViewHierarchyErrorMessage(((Builder)object).rootView, null, (String)object2, null);
            object2 = String.valueOf(object2);
            object3 = String.valueOf((String)((Builder)object).adapterViewWarning.get());
            if (((String)object3).length() != 0) {
                object2 = ((String)object2).concat((String)object3);
                return HumanReadables.getViewHierarchyErrorMessage(((Builder)object).rootView, null, (String)object2, null);
            }
            object2 = object3 = new String((String)object2);
            return HumanReadables.getViewHierarchyErrorMessage(((Builder)object).rootView, null, (String)object2, null);
        }
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{((Builder)object).viewMatcher};
        return String.format(locale, "Could not find a view that matches %s", objectArray);
    }

    public static class Builder {
        private Matcher<? super View> viewMatcher;
        private View rootView;
        private List<View> adapterViews = Lists.newArrayList();
        private boolean includeViewHierarchy = true;
        private EspressoOptional<String> adapterViewWarning = EspressoOptional.absent();
        private Throwable cause;

        /*
         * WARNING - void declaration
         */
        public Builder from(NoMatchingViewException exception) {
            void var1_1;
            this.viewMatcher = ((NoMatchingViewException)var1_1).viewMatcher;
            this.rootView = ((NoMatchingViewException)var1_1).rootView;
            this.adapterViews = ((NoMatchingViewException)var1_1).adapterViews;
            this.adapterViewWarning = ((NoMatchingViewException)var1_1).adapterViewWarning;
            this.includeViewHierarchy = ((NoMatchingViewException)var1_1).includeViewHierarchy;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withViewMatcher(Matcher<? super View> viewMatcher) {
            void var1_1;
            this.viewMatcher = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withRootView(View rootView) {
            void var1_1;
            this.rootView = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withAdapterViews(List<View> adapterViews) {
            void var1_1;
            this.adapterViews = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder includeViewHierarchy(boolean includeViewHierarchy) {
            void var1_1;
            this.includeViewHierarchy = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withAdapterViewWarning(EspressoOptional<String> adapterViewWarning) {
            void var1_1;
            this.adapterViewWarning = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withCause(Throwable cause) {
            void var1_1;
            this.cause = var1_1;
            return this;
        }

        public NoMatchingViewException build() {
            Preconditions.checkNotNull(this.viewMatcher);
            Preconditions.checkNotNull(this.rootView);
            Preconditions.checkNotNull(this.adapterViews);
            Preconditions.checkNotNull(this.adapterViewWarning);
            NoMatchingViewException noMatchingViewException = new NoMatchingViewException(this);
            return noMatchingViewException;
        }
    }
}

