/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.util.Log;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.AppNotIdleException;
import androidx.test.espresso.BaseLayerComponent;
import androidx.test.espresso.DataInteraction;
import androidx.test.espresso.Espresso$$Lambda$0;
import androidx.test.espresso.Espresso$$Lambda$1;
import androidx.test.espresso.FailureHandler;
import androidx.test.espresso.GraphHolder;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.ViewInteraction;
import androidx.test.espresso.ViewInteractionModule;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.base.IdlingResourceRegistry;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFutureTask;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.util.TreeIterables;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class Espresso {
    private static final String TAG = Espresso.class.getSimpleName();
    private static final BaseLayerComponent BASE = GraphHolder.baseLayer();
    private static final IdlingResourceRegistry baseRegistry = BASE.idlingResourceRegistry();
    private static final int TIMEOUT_SECONDS = 5;
    private static final Matcher<View> OVERFLOW_BUTTON_MATCHER = Matchers.anyOf((Matcher)Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.withContentDescription("More options")), (Matcher)Matchers.allOf(ViewMatchers.isDisplayed(), ViewMatchers.withClassName((Matcher<String>)Matchers.endsWith((String)"OverflowMenuButton"))));

    private Espresso() {
    }

    public static ViewInteraction onView(Matcher<View> viewMatcher) {
        Matcher<View> matcher;
        BaseLayerComponent baseLayerComponent = BASE;
        ViewInteractionModule viewInteractionModule = new ViewInteractionModule(matcher);
        return baseLayerComponent.plus(viewInteractionModule).viewInteraction();
    }

    public static DataInteraction onData(Matcher<? extends Object> dataMatcher) {
        Matcher<? extends Object> matcher;
        DataInteraction dataInteraction = new DataInteraction(matcher);
        return dataInteraction;
    }

    @Deprecated
    public static void registerLooperAsIdlingResource(Looper looper) {
        Espresso.registerLooperAsIdlingResource(looper, false);
    }

    @Deprecated
    public static void registerLooperAsIdlingResource(Looper looper, boolean bl) {
        Looper looper2;
        IdlingRegistry.getInstance().registerLooperAsIdlingResource(looper2);
        baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static boolean registerIdlingResources(IdlingResource ... resources) {
        IdlingResource[] idlingResourceArray;
        if (IdlingRegistry.getInstance().register(idlingResourceArray)) {
            baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
            return true;
        }
        if (idlingResourceArray.length != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static boolean unregisterIdlingResources(IdlingResource ... resources) {
        IdlingResource[] idlingResourceArray;
        if (IdlingRegistry.getInstance().unregister(idlingResourceArray)) {
            baseRegistry.sync(IdlingRegistry.getInstance().getResources(), IdlingRegistry.getInstance().getLoopers());
            return true;
        }
        if (idlingResourceArray.length != 0) return false;
        return true;
    }

    @Deprecated
    public static List<IdlingResource> getIdlingResources() {
        return baseRegistry.getResources();
    }

    public static void setFailureHandler(FailureHandler failureHandler) {
        FailureHandler failureHandler2;
        BASE.failureHolder().update(Preconditions.checkNotNull(failureHandler2));
    }

    public static void closeSoftKeyboard() {
        Object object = ViewMatchers.isRoot();
        object = Espresso.onView(object);
        ViewAction[] viewActionArray = new ViewAction[]{ViewActions.closeSoftKeyboard()};
        ((ViewInteraction)object).perform(viewActionArray);
    }

    public static void openContextualActionModeOverflowMenu() {
        Object object = ViewMatchers.isRoot();
        object = Espresso.onView(object);
        ViewAction[] viewActionArray = new ViewAction[1];
        TransitionBridgingViewAction transitionBridgingViewAction = new TransitionBridgingViewAction();
        viewActionArray[0] = transitionBridgingViewAction;
        ((ViewInteraction)object).perform(viewActionArray);
        object = OVERFLOW_BUTTON_MATCHER;
        object = Espresso.onView((Matcher<View>)object);
        viewActionArray = new ViewAction[]{ViewActions.click(ViewActions.pressBack())};
        ((ViewInteraction)object).perform(viewActionArray);
    }

    public static void pressBack() {
        Object object = ViewMatchers.isRoot();
        object = Espresso.onView(object);
        ViewAction[] viewActionArray = new ViewAction[]{ViewActions.pressBack()};
        ((ViewInteraction)object).perform(viewActionArray);
    }

    public static void pressBackUnconditionally() {
        Object object = ViewMatchers.isRoot();
        object = Espresso.onView(object);
        ViewAction[] viewActionArray = new ViewAction[]{ViewActions.pressBackUnconditionally()};
        ((ViewInteraction)object).perform(viewActionArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void openActionBarOverflowOrOptionsMenu(Context context) {
        Object object;
        Espresso.waitUntilNextFrame(2);
        if (object.getApplicationInfo().targetSdkVersion < 11) {
            object = ViewMatchers.isRoot();
            object = Espresso.onView(object);
            ViewAction[] viewActionArray = new ViewAction[]{ViewActions.pressMenuKey()};
            ((ViewInteraction)object).perform(viewActionArray);
        } else if (Espresso.hasVirtualOverflowButton(object)) {
            object = ViewMatchers.isRoot();
            object = Espresso.onView(object);
            ViewAction[] viewActionArray = new ViewAction[1];
            TransitionBridgingViewAction transitionBridgingViewAction = new TransitionBridgingViewAction();
            viewActionArray[0] = transitionBridgingViewAction;
            ((ViewInteraction)object).perform(viewActionArray);
            object = OVERFLOW_BUTTON_MATCHER;
            object = Espresso.onView((Matcher<View>)object);
            viewActionArray = new ViewAction[]{ViewActions.click()};
            ((ViewInteraction)object).perform(viewActionArray);
        } else {
            object = ViewMatchers.isRoot();
            object = Espresso.onView(object);
            ViewAction[] viewActionArray = new ViewAction[]{ViewActions.pressMenuKey()};
            ((ViewInteraction)object).perform(viewActionArray);
        }
        Espresso.waitUntilNextFrame(2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void waitUntilNextFrame(int times) {
        if (Build.VERSION.SDK_INT < 16) {
            return;
        }
        int i = 0;
        int n;
        while (i < n) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
            Espresso$$Lambda$0 espresso$$Lambda$0 = new Espresso$$Lambda$0(countDownLatch);
            instrumentation.runOnMainSync((Runnable)espresso$$Lambda$0);
            BASE.controlledLooper().drainMainThreadUntilIdle();
            try {
                countDownLatch.await(5L, TimeUnit.SECONDS);
                ++i;
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)TAG, (String)"Waited for the next frame to start but never happened.");
                return;
            }
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T onIdle(Callable<T> action) {
        Callable<T> callable;
        Object object = BASE.mainThreadExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BASE.uiController().loopMainThreadUntilIdle();
            }
        };
        runnable = ListenableFutureTask.create(runnable, null);
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        ((ListenableFutureTask)runnable).addListener(futureTask, (Executor)object);
        object.execute(runnable);
        BASE.controlledLooper().drainMainThreadUntilIdle();
        try {
            ((FutureTask)runnable).get();
            T t = futureTask.get();
            return t;
        }
        catch (InterruptedException interruptedException) {
            object = new RuntimeException(interruptedException);
            throw object;
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof AppNotIdleException) {
                throw (AppNotIdleException)executionException.getCause();
            }
        }
        object = new RuntimeException(executionException);
        throw object;
    }

    public static void onIdle() {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return null;
            }
        };
        Espresso.onIdle(callable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasVirtualOverflowButton(Context context) {
        Context context2;
        if (Build.VERSION.SDK_INT < 14) {
            if (Build.VERSION.SDK_INT < 11) return false;
            return true;
        }
        if (ViewConfiguration.get((Context)context2).hasPermanentMenuKey()) return false;
        return true;
    }

    static final /* synthetic */ void lambda$waitUntilNextFrame$1$Espresso(CountDownLatch latch) {
        CountDownLatch countDownLatch;
        Choreographer choreographer = Choreographer.getInstance();
        Espresso$$Lambda$1 espresso$$Lambda$1 = new Espresso$$Lambda$1(countDownLatch);
        choreographer.postFrameCallback((Choreographer.FrameCallback)espresso$$Lambda$1);
    }

    static final /* synthetic */ void lambda$waitUntilNextFrame$0$Espresso(CountDownLatch latch, long l) {
        latch.countDown();
    }

    private static class TransitionBridgingViewAction
    implements ViewAction {
        private TransitionBridgingViewAction() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void perform(UiController controller, View view) {
            void var2_2;
            for (int i = 0; this.isTransitioningBetweenActionBars((View)var2_2) && i < 100; ++i) {
                void var1_1;
                var1_1.loopMainThreadForAtLeast(50L);
            }
        }

        @Override
        public String getDescription() {
            return "Handle transition between action bar and action bar context.";
        }

        @Override
        public Matcher<View> getConstraints() {
            return ViewMatchers.isRoot();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isTransitioningBetweenActionBars(View view) {
            Iterator<View> iterator = TreeIterables.breadthFirstViewTraversal(view).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                View view2 = iterator.next();
                if (!OVERFLOW_BUTTON_MATCHER.matches((Object)view2)) continue;
                ++n;
            }
            if (n <= true) return 0 != 0;
            return 1 != 0;
        }
    }
}

