/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.util;

import android.content.res.Resources;
import android.database.Cursor;
import android.os.Build;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.test.espresso.core.internal.deps.guava.base.Function;
import androidx.test.espresso.core.internal.deps.guava.base.Joiner;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.base.Strings;
import androidx.test.espresso.core.internal.deps.guava.collect.Iterables;
import androidx.test.espresso.util.TreeIterables;
import java.util.List;
import java.util.Locale;

public final class HumanReadables {
    private HumanReadables() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static String getViewHierarchyErrorMessage(View object, List<View> list, String object2, String string) {
        Object[] objectArray;
        Object object3;
        void var3_4;
        void var1_2;
        boolean bl = var1_2 == null || var3_4 != null;
        Preconditions.checkArgument(bl);
        StringBuilder stringBuilder = new StringBuilder((String)object3);
        if (var3_4 != null) {
            object3 = Locale.ROOT;
            objectArray = new Object[]{var3_4};
            stringBuilder.append(String.format((Locale)object3, "\nProblem views are marked with '%s' below.", objectArray));
        }
        stringBuilder.append("\n\nView Hierarchy:\n");
        object3 = Joiner.on("\n");
        Iterable<TreeIterables.ViewAndDistance> iterable = TreeIterables.depthFirstViewTraversalWithDistance(object);
        objectArray = new Function<TreeIterables.ViewAndDistance, String>((List)var1_2, (String)var3_4){
            final /* synthetic */ List val$problemViews;
            final /* synthetic */ String val$problemViewSuffix;
            {
                this.val$problemViews = list;
                this.val$problemViewSuffix = string;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public String apply(TreeIterables.ViewAndDistance viewAndDistance) {
                Object object;
                Object object2 = "+%s%s ";
                if (object.val$problemViews != null) {
                    if (object.val$problemViews.contains(viewAndDistance.getView())) {
                        object2 = String.valueOf(object2);
                        object = String.valueOf(object.val$problemViewSuffix);
                        object = ((String)object).length() == 0 ? new String((String)object2) : ((String)object2).concat((String)object);
                    } else {
                        object = object2;
                    }
                } else {
                    object = object2;
                }
                object = String.valueOf(object);
                object = ((String)object).concat("\n|");
                object2 = Locale.ROOT;
                Object[] objectArray = new Object[]{Strings.padStart(">", viewAndDistance.getDistanceFromRoot() + 1, '-'), HumanReadables.describe(viewAndDistance.getView())};
                return String.format((Locale)object2, (String)object, objectArray);
            }
        };
        ((Joiner)object3).appendTo(stringBuilder, Iterables.transform(iterable, objectArray));
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String describe(Cursor cursor) {
        if (cursor.isBeforeFirst()) {
            return "Cursor positioned before first element.";
        }
        if (cursor.isAfterLast()) {
            return "Cursor positioned after last element.";
        }
        StringBuilder stringBuilder = new StringBuilder("Row ");
        StringBuilder stringBuilder2 = stringBuilder.append(cursor.getPosition()).append(": {");
        String[] stringArray = cursor.getColumnNames();
        int n = 0;
        while (true) {
            if (n >= stringArray.length) {
                stringBuilder2.append("}");
                return stringBuilder2.toString();
            }
            stringBuilder2.append(stringArray[n]).append(":");
            int n2 = Build.VERSION.SDK_INT > 10 ? cursor.getType(n) : 3;
            switch (n2) {
                default: {
                    stringBuilder2.append("\"").append(cursor.getString(n)).append("\"");
                    break;
                }
                case 4: {
                    byte[] byArray = cursor.getBlob(n);
                    stringBuilder2.append("[");
                    for (n2 = 0; n2 < 5 && n2 < byArray.length; ++n2) {
                        stringBuilder2.append(byArray[n2]);
                        stringBuilder2.append(",");
                    }
                    if (byArray.length > 5) {
                        stringBuilder2.append("... (").append(byArray.length + -5).append(" more elements)");
                    }
                    stringBuilder2.append("]");
                    break;
                }
                case 3: {
                    stringBuilder2.append("\"").append(cursor.getString(n)).append("\"");
                    break;
                }
                case 2: {
                    stringBuilder2.append(cursor.getDouble(n));
                    stringBuilder2.append("f");
                    break;
                }
                case 1: {
                    stringBuilder2.append(cursor.getLong(n));
                    break;
                }
                case 0: {
                    stringBuilder2.append("null");
                }
            }
            stringBuilder2.append(", ");
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String describe(View view) {
        EditorInfo editorInfo;
        if (view == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(view).add("id", view.getId());
        if (view.getId() != -1 && view.getResources() != null && !HumanReadables.isViewIdGenerated(view.getId())) {
            try {
                toStringHelper.add("res-name", view.getResources().getResourceEntryName(view.getId()));
            }
            catch (Resources.NotFoundException notFoundException) {}
        }
        if (view.getContentDescription() != null) {
            toStringHelper.add("desc", view.getContentDescription());
        }
        switch (view.getVisibility()) {
            default: {
                toStringHelper.add("visibility", view.getVisibility());
                break;
            }
            case 8: {
                toStringHelper.add("visibility", "GONE");
                break;
            }
            case 4: {
                toStringHelper.add("visibility", "INVISIBLE");
                break;
            }
            case 0: {
                toStringHelper.add("visibility", "VISIBLE");
            }
        }
        toStringHelper.add("width", view.getWidth()).add("height", view.getHeight()).add("has-focus", view.hasFocus()).add("has-focusable", view.hasFocusable()).add("has-window-focus", view.hasWindowFocus()).add("is-clickable", view.isClickable()).add("is-enabled", view.isEnabled()).add("is-focused", view.isFocused()).add("is-focusable", view.isFocusable()).add("is-layout-requested", view.isLayoutRequested()).add("is-selected", view.isSelected()).add("layout-params", view.getLayoutParams()).add("tag", view.getTag());
        if (view.getRootView() != null) {
            toStringHelper.add("root-is-layout-requested", view.getRootView().isLayoutRequested());
        }
        boolean bl = view.onCreateInputConnection(editorInfo = new EditorInfo()) != null;
        toStringHelper.add("has-input-connection", bl);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            StringBuilderPrinter stringBuilderPrinter = new StringBuilderPrinter(stringBuilder);
            editorInfo.dump((Printer)stringBuilderPrinter, "");
            stringBuilder.append("]");
            toStringHelper.add("editor-info", stringBuilder.toString().replace("\n", " "));
        }
        if (Build.VERSION.SDK_INT > 10) {
            toStringHelper.add("x", view.getX()).add("y", view.getY());
        }
        if (view instanceof TextView) {
            HumanReadables.innerDescribe((TextView)view, toStringHelper);
        }
        if (view instanceof Checkable) {
            HumanReadables.innerDescribe((Checkable)view, toStringHelper);
        }
        if (view instanceof ViewGroup) {
            HumanReadables.innerDescribe((ViewGroup)view, toStringHelper);
        }
        return toStringHelper.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void innerDescribe(TextView textView, MoreObjects.ToStringHelper toStringHelper) {
        if (textView.getText() != null) {
            toStringHelper.add("text", textView.getText());
        }
        if (textView.getError() != null) {
            toStringHelper.add("error-text", textView.getError());
        }
        if (textView.getHint() != null) {
            toStringHelper.add("hint", textView.getHint());
        }
        toStringHelper.add("input-type", textView.getInputType());
        toStringHelper.add("ime-target", textView.isInputMethodTarget());
        boolean bl = textView.getUrls().length > 0;
        toStringHelper.add("has-links", bl);
    }

    private static void innerDescribe(Checkable checkable, MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("is-checked", checkable.isChecked());
    }

    private static void innerDescribe(ViewGroup viewGroup, MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("child-count", viewGroup.getChildCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isViewIdGenerated(int n) {
        if ((n & 0xFF000000) != 0) return 0 != 0;
        if ((n & 0xFFFFFF) == 0) return 0 != 0;
        return 1 != 0;
    }
}

